/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchProjectFactoryDescriptor;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

public abstract class AbstractWorkflowBranchProjectFactory
extends BranchProjectFactory<WorkflowJob, WorkflowRun> {
    private static final Logger LOGGER = Logger.getLogger(AbstractWorkflowBranchProjectFactory.class.getName());

    protected abstract FlowDefinition createDefinition();

    protected abstract SCMSourceCriteria getSCMSourceCriteria(SCMSource var1);

    public WorkflowJob newInstance(Branch branch) {
        WorkflowJob job = new WorkflowJob((ItemGroup)((WorkflowMultiBranchProject)this.getOwner()), branch.getEncodedName());
        this.setBranch(job, branch);
        return job;
    }

    public Branch getBranch(WorkflowJob project) {
        return ((BranchJobProperty)project.getProperty(BranchJobProperty.class)).getBranch();
    }

    public WorkflowJob setBranch(WorkflowJob project, Branch branch) {
        project.setDefinition(this.createDefinition());
        BranchJobProperty property = (BranchJobProperty)project.getProperty(BranchJobProperty.class);
        try {
            if (property == null) {
                project.addProperty((JobProperty)new BranchJobProperty(branch));
            } else {
                property.setBranch(branch);
                project.save();
            }
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        return project;
    }

    public boolean isProject(Item item) {
        return item instanceof WorkflowJob && ((WorkflowJob)item).getProperty(BranchJobProperty.class) != null;
    }

    protected static abstract class AbstractWorkflowBranchProjectFactoryDescriptor
    extends BranchProjectFactoryDescriptor {
        protected AbstractWorkflowBranchProjectFactoryDescriptor() {
        }

        public boolean isApplicable(Class<? extends MultiBranchProject> clazz) {
            return WorkflowMultiBranchProject.class.isAssignableFrom(clazz);
        }
    }
}

