/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.multibranch;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import jenkins.branch.Branch;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.jenkinsci.plugins.workflow.pickles.Pickle;
import org.jenkinsci.plugins.workflow.support.pickles.SingleTypedPickleFactory;
import org.jenkinsci.plugins.workflow.support.pickles.XStreamPickle;

@Extension
public class SCMVar
extends GlobalVariable {
    public String getName() {
        return "scm";
    }

    public SCM getValue(CpsScript script) throws Exception {
        SCMRevision tip;
        Run build = script.$build();
        if (!(build instanceof WorkflowRun)) {
            throw new AbortException("not available outside a Pipeline build");
        }
        Job job = build.getParent();
        BranchJobProperty property = (BranchJobProperty)job.getProperty(BranchJobProperty.class);
        if (property == null) {
            FlowDefinition defn;
            if (job instanceof WorkflowJob && (defn = ((WorkflowJob)job).getDefinition()) instanceof CpsScmFlowDefinition) {
                return ((CpsScmFlowDefinition)defn).getScm();
            }
            throw new IllegalStateException("inappropriate context");
        }
        Branch branch = property.getBranch();
        ItemGroup parent = job.getParent();
        if (!(parent instanceof WorkflowMultiBranchProject)) {
            throw new IllegalStateException("inappropriate context");
        }
        SCMSource scmSource = ((WorkflowMultiBranchProject)parent).getSCMSource(branch.getSourceId());
        if (scmSource == null) {
            throw new IllegalStateException(branch.getSourceId() + " not found");
        }
        SCMRevisionAction revisionAction = (SCMRevisionAction)build.getAction(SCMRevisionAction.class);
        if (revisionAction != null) {
            tip = revisionAction.getRevision();
        } else {
            TaskListener listener;
            SCMHead head = branch.getHead();
            tip = scmSource.fetch(head, listener = TaskListener.NULL);
            if (tip == null) {
                return branch.getScm();
            }
            revisionAction = new SCMRevisionAction(tip);
            build.addAction((Action)revisionAction);
        }
        return scmSource.build(branch.getHead(), tip);
    }

    @Extension
    public static class Pickler
    extends SingleTypedPickleFactory<SCM> {
        protected Pickle pickle(SCM scm) {
            return new XStreamPickle((Object)scm);
        }
    }
}

