/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps.scm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jenkinsci.plugins.workflow.steps.scm.MultiSCMRevisionState;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class SCMStep
extends AbstractStepImpl
implements Serializable {
    private boolean poll = true;
    private boolean changelog = true;
    private static final long serialVersionUID = 1L;

    public boolean isPoll() {
        return this.poll;
    }

    @DataBoundSetter
    public void setPoll(boolean poll) {
        this.poll = poll;
    }

    public boolean isChangelog() {
        return this.changelog;
    }

    @DataBoundSetter
    public void setChangelog(boolean changelog) {
        this.changelog = changelog;
    }

    @Nonnull
    protected abstract SCM createSCM();

    public final void checkout(Run<?, ?> run, FilePath workspace, TaskListener listener, Launcher launcher) throws Exception {
        MultiSCMRevisionState state;
        File changelogFile = null;
        if (this.changelog) {
            int i = 0;
            while ((changelogFile = new File(run.getRootDir(), "changelog" + i + ".xml")).exists()) {
                ++i;
            }
        }
        SCM scm = this.createSCM();
        SCMRevisionState baseline = null;
        Run prev = run.getPreviousBuild();
        if (prev != null && (state = (MultiSCMRevisionState)prev.getAction(MultiSCMRevisionState.class)) != null) {
            baseline = state.get(scm);
        }
        scm.checkout(run, launcher, workspace, listener, changelogFile, baseline);
        SCMRevisionState pollingBaseline = null;
        if ((this.poll || this.changelog) && (pollingBaseline = scm.calcRevisionsFromBuild(run, workspace, launcher, listener)) != null) {
            MultiSCMRevisionState state2 = (MultiSCMRevisionState)run.getAction(MultiSCMRevisionState.class);
            if (state2 == null) {
                state2 = new MultiSCMRevisionState();
                run.addAction((Action)state2);
            }
            state2.add(scm, pollingBaseline);
        }
        for (SCMListener l : SCMListener.all()) {
            l.onCheckout(run, scm, workspace, listener, changelogFile, pollingBaseline);
        }
        scm.postCheckout(run, launcher, workspace, listener);
    }

    public static abstract class SCMStepDescriptor
    extends AbstractStepDescriptorImpl {
        protected SCMStepDescriptor() {
            super(StepExecutionImpl.class);
        }
    }

    public static final class StepExecutionImpl
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        @Inject
        private transient SCMStep step;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        private static final long serialVersionUID = 1L;

        protected Void run() throws Exception {
            this.step.checkout(this.run, this.workspace, this.listener, this.launcher);
            return null;
        }
    }
}

