/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.structs;

import com.google.common.primitives.Primitives;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.NoStaplerConstructorException;
import org.kohsuke.stapler.lang.Klass;

public class DescribableHelper {
    private static final Logger LOG = Logger.getLogger(DescribableHelper.class.getName());
    public static final String CLAZZ = "$class";

    public static <T> T instantiate(Class<? extends T> clazz, Map<String, ?> arguments) throws Exception {
        String[] names = DescribableHelper.loadConstructorParamNames(clazz);
        Constructor<T> c = DescribableHelper.findConstructor(clazz, names.length);
        Object[] args = DescribableHelper.buildArguments(clazz, arguments, c.getGenericParameterTypes(), names, true);
        T o = c.newInstance(args);
        DescribableHelper.injectSetters(o, arguments);
        return o;
    }

    public static Map<String, Object> uninstantiate(Object o) throws UnsupportedOperationException {
        String[] names;
        Class<?> clazz = o.getClass();
        TreeMap<String, Object> r = new TreeMap<String, Object>();
        try {
            names = DescribableHelper.loadConstructorParamNames(clazz);
        }
        catch (NoStaplerConstructorException x) {
            throw new UnsupportedOperationException(x);
        }
        for (String name : names) {
            DescribableHelper.inspect(r, o, clazz, name);
        }
        r.values().removeAll(Collections.singleton(null));
        TreeMap<String, Object> constructorOnlyDataBoundProps = new TreeMap<String, Object>((Map<String, Object>)r);
        ArrayList<String> dataBoundSetters = new ArrayList<String>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            String field;
            for (Field field2 : c.getDeclaredFields()) {
                if (!field2.isAnnotationPresent(DataBoundSetter.class)) continue;
                field = field2.getName();
                dataBoundSetters.add(field);
                DescribableHelper.inspect(r, o, clazz, field);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(DataBoundSetter.class) || !((Method)accessibleObject).getName().startsWith("set")) continue;
                field = Introspector.decapitalize(((Method)accessibleObject).getName().substring(3));
                dataBoundSetters.add(field);
                DescribableHelper.inspect(r, o, clazz, field);
            }
        }
        DescribableHelper.clearDefaultSetters(clazz, r, constructorOnlyDataBoundProps, dataBoundSetters);
        return r;
    }

    public static Schema schemaFor(Class<?> clazz) {
        return new Schema(clazz);
    }

    private static Schema schemaFor(Class<?> clazz, Stack<String> tracker) {
        return new Schema(clazz, tracker);
    }

    private static void clearDefaultSetters(Class<?> clazz, Map<String, Object> allDataBoundProps, Map<String, Object> constructorOnlyDataBoundProps, Collection<String> dataBoundSetters) {
        Object control;
        if (dataBoundSetters.isEmpty()) {
            return;
        }
        try {
            control = DescribableHelper.instantiate(clazz, constructorOnlyDataBoundProps);
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "Cannot create control version of " + clazz + " using " + constructorOnlyDataBoundProps, x);
            return;
        }
        HashMap<String, Object> fromControl = new HashMap<String, Object>(constructorOnlyDataBoundProps);
        Iterator<String> fields = dataBoundSetters.iterator();
        while (fields.hasNext()) {
            String field = fields.next();
            try {
                DescribableHelper.inspect(fromControl, control, clazz, field);
            }
            catch (RuntimeException x) {
                LOG.log(Level.WARNING, "Failed to check property " + field + " of " + clazz + " on " + control, x);
                fields.remove();
            }
        }
        for (String field : dataBoundSetters) {
            if (!ObjectUtils.equals((Object)allDataBoundProps.get(field), fromControl.get(field))) continue;
            allDataBoundProps.remove(field);
        }
    }

    private static Object[] buildArguments(Class<?> clazz, Map<String, ?> arguments, Type[] types, String[] names, boolean callEvenIfNoArgs) throws Exception {
        Object[] args = new Object[names.length];
        boolean hasArg = callEvenIfNoArgs;
        for (int i = 0; i < args.length; ++i) {
            String name = names[i];
            hasArg |= arguments.containsKey(name);
            Object a = arguments.get(name);
            Type type = types[i];
            if (a != null) {
                args[i] = DescribableHelper.coerce(clazz.getName() + "." + name, type, a);
                continue;
            }
            if (type == Boolean.TYPE) {
                args[i] = false;
                continue;
            }
            if (!(type instanceof Class) || !((Class)type).isPrimitive() || !callEvenIfNoArgs) continue;
            throw new UnsupportedOperationException("not yet handling @DataBoundConstructor default value of " + type + "; pass an explicit value for " + name);
        }
        return hasArg ? args : null;
    }

    private static Object coerce(String context, Type type, @Nonnull Object o) throws Exception {
        if (type instanceof Class) {
            o = ReflectionCache.getCachedClass((Class)((Class)type)).coerceArgument(o);
        }
        if (type instanceof Class && Primitives.wrap((Class)((Class)type)).isInstance(o)) {
            return o;
        }
        if (o instanceof Map) {
            Class<?> clazz;
            HashMap m = new HashMap();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                m.put((String)entry.getKey(), entry.getValue());
            }
            String clazzS = (String)m.remove(CLAZZ);
            if (clazzS == null) {
                if (Modifier.isAbstract(((Class)type).getModifiers())) {
                    throw new UnsupportedOperationException("must specify $class with an implementation of " + type);
                }
                clazz = (Class<?>)type;
            } else if (clazzS.contains(".")) {
                Jenkins j = Jenkins.getInstance();
                ClassLoader loader = j != null ? j.getPluginManager().uberClassLoader : DescribableHelper.class.getClassLoader();
                clazz = loader.loadClass(clazzS);
            } else if (type instanceof Class) {
                clazz = null;
                for (Class<?> c : DescribableHelper.findSubtypes((Class)type)) {
                    if (!c.getSimpleName().equals(clazzS)) continue;
                    if (clazz != null) {
                        throw new UnsupportedOperationException(clazzS + " as a " + type + " could mean either " + clazz.getName() + " or " + c.getName());
                    }
                    clazz = c;
                }
                if (clazz == null) {
                    throw new UnsupportedOperationException("no known implementation of " + type + " is named " + clazzS);
                }
            } else {
                throw new UnsupportedOperationException("JENKINS-26535: do not know how to handle " + type);
            }
            return DescribableHelper.instantiate(clazz.asSubclass((Class)type), m);
        }
        if (o instanceof String && type instanceof Class && ((Class)type).isEnum()) {
            return Enum.valueOf(((Class)type).asSubclass(Enum.class), (String)o);
        }
        if (o instanceof String && type == URL.class) {
            return new URL((String)o);
        }
        if (o instanceof String && (type == Character.TYPE || type == Character.class) && ((String)o).length() == 1) {
            return Character.valueOf(((String)o).charAt(0));
        }
        if (o instanceof List && type instanceof Class && ((Class)type).isArray()) {
            Class<?> componentType = ((Class)type).getComponentType();
            List<Object> list = DescribableHelper.mapList(context, componentType, (List)o);
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        if (o instanceof List && DescribableHelper.acceptsList(type)) {
            return DescribableHelper.mapList(context, ((ParameterizedType)type).getActualTypeArguments()[0], (List)o);
        }
        throw new ClassCastException(context + " expects " + type + " but received " + o.getClass());
    }

    private static boolean acceptsList(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class && ((Class)((ParameterizedType)type).getRawType()).isAssignableFrom(List.class);
    }

    private static List<Object> mapList(String context, Type type, List<?> list) throws Exception {
        ArrayList<Object> r = new ArrayList<Object>();
        for (Object elt : list) {
            r.add(DescribableHelper.coerce(context, type, elt));
        }
        return r;
    }

    private static String[] loadConstructorParamNames(Class<?> clazz) {
        return new ClassDescriptor(clazz, new Class[0]).loadConstructorParamNames();
    }

    private static <T> Constructor<T> findConstructor(Class<? extends T> clazz, int length) {
        Constructor<?>[] ctrs;
        for (Constructor<?> c : ctrs = clazz.getConstructors()) {
            if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
            if (c.getParameterTypes().length != length) {
                throw new IllegalArgumentException(c + " has @DataBoundConstructor but it doesn't match with your .stapler file. Try clean rebuild");
            }
            return c;
        }
        for (Constructor<?> c : ctrs) {
            if (c.getParameterTypes().length != length) continue;
            return c;
        }
        throw new IllegalArgumentException(clazz + " does not have a constructor with " + length + " arguments");
    }

    private static void injectSetters(Object o, Map<String, ?> arguments) throws Exception {
        for (Class<?> c = o.getClass(); c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(DataBoundSetter.class)) continue;
                field.setAccessible(true);
                if (!arguments.containsKey(field.getName())) continue;
                Object v = arguments.get(field.getName());
                field.set(o, v != null ? DescribableHelper.coerce(c.getName() + "." + field.getName(), field.getType(), v) : null);
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(DataBoundSetter.class)) continue;
                Type[] parameterTypes = ((Method)accessibleObject).getGenericParameterTypes();
                if (!((Method)accessibleObject).getName().startsWith("set") || parameterTypes.length != 1) {
                    throw new IllegalStateException(accessibleObject + " cannot be a @DataBoundSetter");
                }
                ((Method)accessibleObject).setAccessible(true);
                Object[] args = DescribableHelper.buildArguments(c, arguments, parameterTypes, new String[]{Introspector.decapitalize(((Method)accessibleObject).getName().substring(3))}, false);
                if (args == null) continue;
                ((Method)accessibleObject).invoke(o, args);
            }
        }
    }

    private static void inspect(Map<String, Object> r, Object o, Class<?> clazz, String field) {
        AtomicReference<Type> type = new AtomicReference<Type>();
        Object value = DescribableHelper.inspect(o, clazz, field, type);
        try {
            String[] names = DescribableHelper.loadConstructorParamNames(clazz);
            int idx = Arrays.asList(names).indexOf(field);
            if (idx >= 0) {
                Type ctorType = DescribableHelper.findConstructor(clazz, names.length).getGenericParameterTypes()[idx];
                if (!type.get().equals(ctorType)) {
                    LOG.log(Level.WARNING, "For {0}.{1}, preferring constructor type {2} to differing getter type {3}", new Object[]{clazz.getName(), field, ctorType, type});
                    type.set(ctorType);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        r.put(field, DescribableHelper.uncoerce(value, type.get()));
    }

    private static Object uncoerce(Object o, Type type) {
        block11: {
            if (type instanceof Class && ((Class)type).isEnum() && o instanceof Enum) {
                return ((Enum)o).name();
            }
            if (type == URL.class && o instanceof URL) {
                return ((URL)o).toString();
            }
            if ((type == Character.class || type == Character.TYPE) && o instanceof Character) {
                return ((Character)o).toString();
            }
            if (o instanceof Object[]) {
                Object[] array;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object elt : array = (Object[])o) {
                    list.add(DescribableHelper.uncoerce(elt, array.getClass().getComponentType()));
                }
                return list;
            }
            if (o instanceof List && DescribableHelper.acceptsList(type)) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object elt : (List)o) {
                    list.add(DescribableHelper.uncoerce(elt, ((ParameterizedType)type).getActualTypeArguments()[0]));
                }
                return list;
            }
            if (o != null && !o.getClass().getName().startsWith("java.")) {
                try {
                    Map<String, Object> nested = DescribableHelper.uninstantiate(o);
                    if (type != o.getClass()) {
                        nested.put(CLAZZ, o.getClass().getSimpleName());
                    }
                    return nested;
                }
                catch (UnsupportedOperationException x) {
                    if (x.getCause() instanceof NoStaplerConstructorException) break block11;
                    LOG.log(Level.WARNING, "failed to uncoerce " + o, x);
                }
            }
        }
        return o;
    }

    private static Object inspect(Object o, Class<?> clazz, String field, AtomicReference<Type> type) {
        try {
            try {
                Field f = clazz.getField(field);
                type.set(f.getGenericType());
                return f.get(o);
            }
            catch (NoSuchFieldException f) {
                try {
                    Method m = clazz.getMethod("get" + Character.toUpperCase(field.charAt(0)) + field.substring(1), new Class[0]);
                    type.set(m.getGenericReturnType());
                    return m.invoke(o, new Object[0]);
                }
                catch (NoSuchMethodException m) {
                    try {
                        type.set(Boolean.TYPE);
                        return clazz.getMethod("is" + Character.toUpperCase(field.charAt(0)) + field.substring(1), new Class[0]).invoke(o, new Object[0]);
                    }
                    catch (NoSuchMethodException x) {
                        throw new UnsupportedOperationException("no public field \u2018" + field + "\u2019 (or getter method) found in " + clazz);
                    }
                }
            }
        }
        catch (UnsupportedOperationException x) {
            throw x;
        }
        catch (Exception x) {
            throw new UnsupportedOperationException(x);
        }
    }

    static Set<Class<?>> findSubtypes(Class<?> supertype) {
        HashSet clazzes = new HashSet();
        for (Descriptor descriptor : DescribableHelper.getDescriptorList()) {
            if (!supertype.isAssignableFrom(descriptor.clazz)) continue;
            clazzes.add(descriptor.clazz);
        }
        if (supertype == ParameterValue.class) {
            for (Class clazz : DescribableHelper.findSubtypes(ParameterDefinition.class)) {
                String name = clazz.getName();
                if (!name.endsWith("Definition")) continue;
                try {
                    Class<?> c = clazz.getClassLoader().loadClass(name.replaceFirst("Definition$", "Value"));
                    if (!supertype.isAssignableFrom(c)) continue;
                    clazzes.add(c);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return clazzes;
    }

    private static List<? extends Descriptor> getDescriptorList() {
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            return j.getExtensionList(Descriptor.class);
        }
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (IndexItem item : Index.load(Extension.class, Object.class)) {
            try {
                Object o = item.instance();
                if (!(o instanceof Descriptor)) continue;
                descriptors.add((Descriptor)o);
            }
            catch (InstantiationException instantiationException) {}
        }
        return descriptors;
    }

    private DescribableHelper() {
    }

    public static final class ErrorType
    extends ParameterType {
        private final Exception error;

        ErrorType(Exception error, Type type) {
            super(type);
            LOG.log(Level.FINE, null, error);
            this.error = error;
        }

        public Exception getError() {
            return this.error;
        }

        public String toString() {
            return this.error.toString();
        }
    }

    public static final class HeterogeneousObjectType
    extends ParameterType {
        private final Map<String, Schema> types;

        HeterogeneousObjectType(Class<?> supertype, Map<String, Schema> types) {
            super(supertype);
            this.types = types;
        }

        public Class<?> getType() {
            return (Class)this.getActualType();
        }

        public Map<String, Schema> getTypes() {
            return this.types;
        }

        public String toString() {
            return this.getType().getSimpleName() + this.types;
        }
    }

    public static final class HomogeneousObjectType
    extends ParameterType {
        private final Schema type;

        HomogeneousObjectType(Class<?> actualClass) {
            super(actualClass);
            this.type = DescribableHelper.schemaFor(actualClass);
        }

        public Class<?> getType() {
            return (Class)this.getActualType();
        }

        public Schema getSchemaType() {
            return this.type;
        }

        public String toString() {
            return this.type.getType().getSimpleName() + this.type;
        }
    }

    public static final class ArrayType
    extends ParameterType {
        private final ParameterType elementType;

        ArrayType(Class<?> actualClass) {
            this(actualClass, ArrayType.of(actualClass.getComponentType()));
        }

        ArrayType(Type actualClass, ParameterType elementType) {
            super(actualClass);
            this.elementType = elementType;
        }

        public ParameterType getElementType() {
            return this.elementType;
        }

        public String toString() {
            return this.elementType + "[]";
        }
    }

    public static final class EnumType
    extends ParameterType {
        private final String[] values;

        EnumType(Class<?> clazz, String[] values) {
            super(clazz);
            this.values = values;
        }

        public Class<?> getType() {
            return (Class)this.getActualType();
        }

        public String[] getValues() {
            return (String[])this.values.clone();
        }

        public String toString() {
            return ((Class)this.getActualType()).getSimpleName() + Arrays.toString(this.values);
        }
    }

    public static final class AtomicType
    extends ParameterType {
        AtomicType(Class<?> clazz) {
            super(clazz);
        }

        public Class<?> getType() {
            return (Class)this.getActualType();
        }

        public String toString() {
            return Primitives.unwrap((Class)((Class)this.getActualType())).getSimpleName();
        }
    }

    public static abstract class ParameterType {
        @Nonnull
        private final Type actualType;

        public Type getActualType() {
            return this.actualType;
        }

        ParameterType(Type actualType) {
            this.actualType = actualType;
        }

        static ParameterType of(Type type) {
            return ParameterType.of(type, new Stack<String>());
        }

        private static ParameterType of(Type type, @Nonnull Stack<String> tracker) {
            try {
                if (type instanceof Class) {
                    Class c = (Class)type;
                    if (c == String.class || Primitives.unwrap((Class)c).isPrimitive()) {
                        return new AtomicType(c);
                    }
                    if (Enum.class.isAssignableFrom(c)) {
                        ArrayList<String> constants = new ArrayList<String>();
                        for (Enum value : c.asSubclass(Enum.class).getEnumConstants()) {
                            constants.add(value.name());
                        }
                        return new EnumType(c, constants.toArray(new String[constants.size()]));
                    }
                    if (c == URL.class) {
                        return new AtomicType(String.class);
                    }
                    if (c.isArray()) {
                        return new ArrayType(c);
                    }
                    Set<Class<?>> subtypes = DescribableHelper.findSubtypes(c);
                    if (subtypes.isEmpty() && !Modifier.isAbstract(c.getModifiers()) || subtypes.equals(Collections.singleton(c))) {
                        return new HomogeneousObjectType(c);
                    }
                    HashMap subtypesBySimpleName = new HashMap();
                    for (Class<?> subtype : subtypes) {
                        String simpleName = subtype.getSimpleName();
                        ArrayList bySimpleName = (ArrayList)subtypesBySimpleName.get(simpleName);
                        if (bySimpleName == null) {
                            bySimpleName = new ArrayList();
                            subtypesBySimpleName.put(simpleName, bySimpleName);
                        }
                        bySimpleName.add(subtype);
                    }
                    TreeMap<String, Schema> types = new TreeMap<String, Schema>();
                    for (Map.Entry entry : subtypesBySimpleName.entrySet()) {
                        if (((List)entry.getValue()).size() == 1) {
                            try {
                                String key = (String)entry.getKey();
                                if (tracker.search(key) >= 0) continue;
                                tracker.push(key);
                                types.put(key, DescribableHelper.schemaFor((Class)((List)entry.getValue()).get(0), tracker));
                                tracker.pop();
                            }
                            catch (Exception x) {
                                LOG.log(Level.FINE, "skipping subtype", x);
                            }
                            continue;
                        }
                        for (Class subtype : (List)entry.getValue()) {
                            try {
                                String name = subtype.getName();
                                if (tracker.search(name) >= 0) continue;
                                tracker.push(name);
                                types.put(name, DescribableHelper.schemaFor(subtype, tracker));
                                tracker.pop();
                            }
                            catch (Exception x) {
                                LOG.log(Level.FINE, "skipping subtype", x);
                            }
                        }
                    }
                    return new HeterogeneousObjectType(c, types);
                }
                if (DescribableHelper.acceptsList(type)) {
                    return new ArrayType(type, ParameterType.of(((ParameterizedType)type).getActualTypeArguments()[0]));
                }
                throw new UnsupportedOperationException("do not know how to categorize attributes of type " + type);
            }
            catch (Exception x) {
                return new ErrorType(x, type);
            }
        }
    }

    public static final class Schema {
        private final Class<?> type;
        private final Map<String, ParameterType> parameters;
        private final List<String> mandatoryParameters;

        Schema(Class<?> clazz) {
            this(clazz, new Stack<String>());
        }

        Schema(Class<?> clazz, @Nonnull Stack<String> tracker) {
            this.type = clazz;
            this.mandatoryParameters = new ArrayList<String>();
            this.parameters = new TreeMap<String, ParameterType>();
            String[] names = DescribableHelper.loadConstructorParamNames(clazz);
            Type[] types = DescribableHelper.findConstructor(clazz, names.length).getGenericParameterTypes();
            for (int i = 0; i < names.length; ++i) {
                this.mandatoryParameters.add(names[i]);
                this.parameters.put(names[i], ParameterType.of(types[i], tracker));
            }
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                for (Field field : c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(DataBoundSetter.class)) continue;
                    field.setAccessible(true);
                    this.parameters.put(field.getName(), ParameterType.of(field.getGenericType(), tracker));
                }
                for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                    if (!accessibleObject.isAnnotationPresent(DataBoundSetter.class)) continue;
                    Type[] parameterTypes = ((Method)accessibleObject).getGenericParameterTypes();
                    if (!((Method)accessibleObject).getName().startsWith("set") || parameterTypes.length != 1) {
                        throw new IllegalStateException(accessibleObject + " cannot be a @DataBoundSetter");
                    }
                    ((Method)accessibleObject).setAccessible(true);
                    this.parameters.put(Introspector.decapitalize(((Method)accessibleObject).getName().substring(3)), ParameterType.of(((Method)accessibleObject).getGenericParameterTypes()[0], tracker));
                }
            }
        }

        public Class<?> getType() {
            return this.type;
        }

        public Map<String, ParameterType> parameters() {
            return this.parameters;
        }

        public List<String> mandatoryParameters() {
            return this.mandatoryParameters;
        }

        public String getDisplayName() {
            for (Descriptor d : DescribableHelper.getDescriptorList()) {
                if (d.clazz != this.type) continue;
                return d.getDisplayName();
            }
            return this.type.getSimpleName();
        }

        @CheckForNull
        public String getHelp(@CheckForNull String parameter) throws IOException {
            for (Klass c = Klass.java(this.type); c != null; c = c.getSuperClass()) {
                URL u = c.getResource(parameter == null ? "help.html" : "help-" + parameter + ".html");
                if (u == null) continue;
                return IOUtils.toString((URL)u, (String)"UTF-8");
            }
            return null;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("(");
            boolean first = true;
            TreeMap<String, ParameterType> params = new TreeMap<String, ParameterType>(this.parameters());
            for (String string : this.mandatoryParameters()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(string).append(": ").append(params.remove(string));
            }
            for (Map.Entry entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append('[').append((String)entry.getKey()).append(": ").append(entry.getValue()).append(']');
            }
            return b.append(')').toString();
        }
    }
}

