/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class MissingContextVariableException
extends Exception {
    @Nonnull
    private final Class<?> type;
    private static final long serialVersionUID = 1L;

    public MissingContextVariableException(@Nonnull Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder("Required context ").append(this.type).append(" is missing");
        boolean first = true;
        for (StepDescriptor p : this.getProviders()) {
            if (first) {
                b.append("\nPerhaps you forgot to surround the code with a step that provides this, such as: ");
                first = false;
            } else {
                b.append(", ");
            }
            b.append(p.getFunctionName());
        }
        return b.toString();
    }

    @Nonnull
    public List<StepDescriptor> getProviders() {
        ArrayList<StepDescriptor> r = new ArrayList<StepDescriptor>();
        for (StepDescriptor sd : StepDescriptor.all()) {
            if (!this.isIn(sd.getProvidedContext()) || this.isIn(sd.getRequiredContext())) continue;
            r.add(sd);
        }
        return r;
    }

    private boolean isIn(Set<? extends Class<?>> classes) {
        for (Class<?> t : classes) {
            if (!this.type.isAssignableFrom(t)) continue;
            return true;
        }
        return false;
    }
}

