/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.steps;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecutionIterator;

public abstract class StepExecution
implements Serializable {
    @Inject
    private StepContext context;
    private static final long serialVersionUID = 1L;

    protected StepExecution() {
    }

    protected StepExecution(StepContext context) {
        this.context = context;
    }

    @Nonnull
    public StepContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("you must either pass in a StepContext to the StepExecution constructor, or have the StepExecution be created automatically");
        }
        return this.context;
    }

    public abstract boolean start() throws Exception;

    public abstract void stop(@Nonnull Throwable var1) throws Exception;

    public void onResume() {
    }

    public String toString() {
        String supe = super.toString();
        String status = this.getStatus();
        return status != null ? supe + "(" + status + ")" : supe;
    }

    @CheckForNull
    public String getStatus() {
        return null;
    }

    public static ListenableFuture<?> applyAll(Function<StepExecution, Void> f) {
        ArrayList futures = new ArrayList();
        for (StepExecutionIterator i : StepExecutionIterator.all()) {
            futures.add(i.apply(f));
        }
        return Futures.allAsList(futures);
    }

    public static <T extends StepExecution> ListenableFuture<?> applyAll(final Class<T> type, final Function<T, Void> f) {
        return StepExecution.applyAll(new Function<StepExecution, Void>(){

            public Void apply(StepExecution e) {
                if (type.isInstance(e)) {
                    f.apply(type.cast(e));
                }
                return null;
            }
        });
    }
}

