/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.reactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jvnet.hudson.reactor.Executable;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.Task;
import org.jvnet.hudson.reactor.TaskBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskGraphBuilder
extends TaskBuilder {
    private final Set<Task> tasks = new HashSet<Task>();
    private final List<Milestone> requiresForNextTask = new ArrayList<Milestone>();
    private final List<Milestone> attainsForNextTask = new ArrayList<Milestone>();
    private boolean fatalForNextTask = true;
    private Handle last;

    @Override
    public Iterable<? extends Task> discoverTasks(Reactor reactor) throws IOException {
        return Collections.unmodifiableSet(this.tasks);
    }

    public Handle add(String displayName, Executable e) {
        TaskImpl t = new TaskImpl(displayName, e);
        this.tasks.add(t);
        t.requires(this.requiresForNextTask);
        t.attains(this.attainsForNextTask);
        t.fatal = this.fatalForNextTask;
        this.requiresForNextTask.clear();
        this.attainsForNextTask.clear();
        this.fatalForNextTask = true;
        this.last = t;
        return t;
    }

    public TaskGraphBuilder followedBy() {
        return this.requires(this.last);
    }

    public TaskGraphBuilder requires(Milestone ... milestones) {
        this.requiresForNextTask.addAll(Arrays.asList(milestones));
        return this;
    }

    public TaskGraphBuilder attains(Milestone ... milestones) {
        this.attainsForNextTask.addAll(Arrays.asList(milestones));
        return this;
    }

    public TaskGraphBuilder notFatal() {
        this.fatalForNextTask = false;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TaskImpl
    implements Task,
    Milestone,
    Handle {
        private final String displayName;
        private final Executable executable;
        private final Set<Milestone> requires = new HashSet<Milestone>();
        private final Set<Milestone> attains = new HashSet<Milestone>();
        private boolean fatal;

        private TaskImpl(String displayName, Executable executable) {
            this.displayName = displayName;
            this.executable = executable;
            this.attains.add(this);
        }

        public Collection<Milestone> requires() {
            return this.requires;
        }

        public Collection<Milestone> attains() {
            return this.attains;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public boolean failureIsFatal() {
            return this.fatal;
        }

        @Override
        public void run(Reactor reactor) throws Exception {
            this.executable.run(reactor);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public Handle requires(Milestone m) {
            if (m != null) {
                this.requires.add(m);
            }
            return this;
        }

        @Override
        public Handle requires(Milestone ... ms) {
            return this.requires(Arrays.asList(ms));
        }

        @Override
        public Handle requires(Collection<? extends Milestone> ms) {
            for (Milestone milestone : ms) {
                this.requires(milestone);
            }
            return this;
        }

        @Override
        public Handle attains(Milestone m) {
            this.attains.add(m);
            return this;
        }

        @Override
        public Handle attains(Collection<? extends Milestone> ms) {
            for (Milestone milestone : ms) {
                this.attains(milestone);
            }
            return this;
        }

        @Override
        public Task asTask() {
            return this;
        }

        @Override
        public Task notFatal() {
            this.fatal = false;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Handle
    extends Milestone {
        public Handle requires(Milestone var1);

        public Handle requires(Milestone ... var1);

        public Handle requires(Collection<? extends Milestone> var1);

        public Handle attains(Milestone var1);

        public Handle attains(Collection<? extends Milestone> var1);

        public Task asTask();

        public Task notFatal();
    }
}

