/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsManifestMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="hpl", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class HplMojo
extends AbstractJenkinsManifestMojo {
    @Deprecated
    @Parameter(property="hudsonHome")
    private File hudsonHome;
    @Parameter(property="jenkinsHome")
    private File jenkinsHome;

    @Deprecated
    public void setHudsonHome(File hudsonHome) {
        this.hudsonHome = null;
        this.jenkinsHome = hudsonHome;
    }

    public void setJenkinsHome(File jenkinsHome) {
        this.hudsonHome = null;
        this.jenkinsHome = jenkinsHome;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.getPackaging().equals("hpi")) {
            this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging>"));
            return;
        }
        if (this.jenkinsHome == null && this.hudsonHome != null) {
            this.getLog().warn((CharSequence)"Please use the `jenkinsHome` configuration parameter in place of the deprecated `hudsonHome` parameter");
        }
        File hplFile = this.computeHplFile();
        this.getLog().info((CharSequence)("Generating " + hplFile));
        PrintWriter printWriter = null;
        try {
            Manifest mf = new Manifest();
            Manifest.Section mainSection = mf.getMainSection();
            this.setAttributes(mainSection);
            ArrayList<String> paths = new ArrayList<String>();
            for (Resource r : this.project.getBuild().getResources()) {
                File dir = new File(r.getDirectory());
                if (!dir.isAbsolute()) {
                    dir = new File(this.project.getBasedir(), r.getDirectory());
                }
                if (!dir.exists()) continue;
                paths.add(dir.getPath());
            }
            paths.add(this.project.getBuild().getOutputDirectory());
            this.buildLibraries(paths);
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Libraries", StringUtils.join(paths, (String)",")));
            if (this.webappDirectory != null && this.webappDirectory.isDirectory()) {
                mainSection.addAttributeAndCheck(new Manifest.Attribute("Resource-Path", this.webappDirectory.getAbsolutePath()));
            } else {
                this.getLog().info((CharSequence)"webappDirectory does not exist, will use warSourceDirectory");
                mainSection.addAttributeAndCheck(new Manifest.Attribute("Resource-Path", this.warSourceDirectory.getAbsolutePath()));
            }
            printWriter = new PrintWriter(new FileWriter(hplFile));
            mf.write(printWriter);
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException("Error preparing the manifest: " + e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e2.getMessage(), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(printWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)printWriter);
    }

    private void buildLibraries(List<String> paths) throws IOException {
        Set<MavenArtifact> artifacts = this.getProjectArtfacts();
        HashSet<String> jenkinsPlugins = new HashSet<String>();
        for (MavenArtifact artifact : artifacts) {
            if (!artifact.isPluginBestEffort(this.getLog())) continue;
            jenkinsPlugins.add(artifact.getId());
        }
        block1: for (MavenArtifact artifact : artifacts) {
            if (jenkinsPlugins.contains(artifact.getId()) || artifact.getDependencyTrail().size() >= 1 && jenkinsPlugins.contains(artifact.getDependencyTrail().get(1))) continue;
            for (String trail : artifact.getDependencyTrail()) {
                if (!trail.contains(":hudson-core:") && !trail.contains(":jenkins-core:")) continue;
                continue block1;
            }
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact.artifact)) continue;
            paths.add(artifact.getFile().getPath());
        }
    }

    protected File computeHplFile() throws MojoExecutionException {
        if (this.jenkinsHome == null) {
            this.jenkinsHome = this.hudsonHome;
        }
        if (this.jenkinsHome == null) {
            throw new MojoExecutionException("Property jenkinsHome needs to be set to $JENKINS_HOME. Please use 'mvn -DjenkinsHome=...' or put <settings><profiles><profile><properties><property><jenkinsHome>...</...>");
        }
        File hplFile = new File(this.jenkinsHome, "plugins/" + this.project.getBuild().getFinalName() + ".hpl");
        return hplFile;
    }
}

