/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMarkerInterface;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public final class ModelASTNamedArgumentList
extends ModelASTArgumentList {
    private Map<ModelASTKey, ModelASTValue> arguments = new LinkedHashMap<ModelASTKey, ModelASTValue>();

    public ModelASTNamedArgumentList(Object sourceLocation) {
        super(sourceLocation);
    }

    @NonNull
    public JSONArray toJSON() {
        return ModelASTNamedArgumentList.toJSONArray(this.arguments);
    }

    public boolean containsKeyName(@NonNull String keyName) {
        for (ModelASTKey key : this.arguments.keySet()) {
            if (!keyName.equals(key.getKey())) continue;
            return true;
        }
        return false;
    }

    public ModelASTKey keyForName(@NonNull String keyName) {
        for (ModelASTKey key : this.arguments.keySet()) {
            if (!keyName.equals(key.getKey())) continue;
            return key;
        }
        return null;
    }

    public ModelASTValue valueForName(@NonNull String keyName) {
        if (this.containsKeyName(keyName)) {
            return this.arguments.get(this.keyForName(keyName));
        }
        return null;
    }

    @Override
    public void validate(@NonNull ModelValidator validator) {
        ModelASTNamedArgumentList.validate(validator, this.arguments, new ModelASTMarkerInterface[0]);
    }

    @Override
    @NonNull
    public String toGroovy() {
        return ModelASTNamedArgumentList.toGroovyArgList(this.arguments, ": ");
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        ModelASTNamedArgumentList.removeSourceLocationsFrom(this.arguments, new ModelASTMarkerInterface[0]);
    }

    public Map<ModelASTKey, ModelASTValue> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<ModelASTKey, ModelASTValue> arguments) {
        this.arguments = arguments;
    }

    @Override
    public Map<String, ?> argListToMap() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Map.Entry<ModelASTKey, ModelASTValue> entry : this.arguments.entrySet()) {
            m.put(entry.getKey().getKey(), entry.getValue().getValue());
        }
        return m;
    }

    @Override
    public String toString() {
        return "ModelASTNamedArgumentList{arguments=" + this.arguments + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTNamedArgumentList that = (ModelASTNamedArgumentList)o;
        return this.getArguments() != null ? this.getArguments().equals(that.getArguments()) : that.getArguments() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getArguments() != null ? this.getArguments().hashCode() : 0);
        return result;
    }
}

