/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.PasswordParameterDefinition;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.pipeline.modeldefinition.CommonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.cps.Snippetizer;
import org.kohsuke.stapler.DataBoundConstructor;

public class ParametersDirective
extends AbstractDirective<ParametersDirective> {
    private List<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>();

    @DataBoundConstructor
    public ParametersDirective(List<ParameterDefinition> parameters) {
        if (parameters != null) {
            this.parameters.addAll(parameters);
        }
    }

    @NonNull
    public List<ParameterDefinition> getParameters() {
        return this.parameters;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<ParametersDirective> {
        @Override
        @NonNull
        public String getName() {
            return "parameters";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Parameters";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            return ExtensionList.lookup(ParameterDefinition.ParameterDescriptor.class).stream().filter(d -> DirectiveDescriptor.symbolForDescriptor((Descriptor)d) != null).sorted(Comparator.comparing(d -> DirectiveDescriptor.symbolForDescriptor((Descriptor)d))).collect(Collectors.toList());
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull ParametersDirective directive) {
            StringBuilder result = new StringBuilder("parameters {\n");
            for (ParameterDefinition param : directive.parameters) {
                result.append(Snippetizer.object2Groovy((Object)this.customUninstantiate(param)));
                result.append("\n");
            }
            result.append("}\n");
            return result.toString();
        }

        public UninstantiatedDescribable customUninstantiate(ParameterDefinition param) {
            UninstantiatedDescribable step = UninstantiatedDescribable.from((Object)param);
            if (param instanceof PasswordParameterDefinition && DescribableModel.of(PasswordParameterDefinition.class).getParameter("defaultValue") == null) {
                Map newParamArgs = CommonUtils.copyMapReplacingEntry((Map)step.getArguments(), (String)"defaultValueAsSecret", (String)"defaultValue", Secret.class, Secret::getPlainText);
                return step.withArguments(newParamArgs);
            }
            return step;
        }
    }
}

