/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.generator;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.AbstractDirective;
import org.jenkinsci.plugins.pipeline.modeldefinition.generator.DirectiveDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.model.BuildCondition;
import org.jenkinsci.plugins.structs.SymbolLookup;
import org.kohsuke.stapler.DataBoundConstructor;

public class PostDirective
extends AbstractDirective<PostDirective> {
    private final List<String> conditions = new ArrayList<String>();

    @DataBoundConstructor
    public PostDirective(List<String> conditions) {
        if (conditions != null) {
            this.conditions.addAll(conditions);
        }
    }

    public List<String> getConditions() {
        return this.conditions;
    }

    @Extension
    public static class DescriptorImpl
    extends DirectiveDescriptor<PostDirective> {
        @Override
        @NonNull
        public String getName() {
            return "post";
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Post Stage or Build Conditions";
        }

        @Override
        @NonNull
        public List<Descriptor> getDescriptors() {
            return Collections.emptyList();
        }

        @NonNull
        public Set<Map.Entry<String, String>> getPossibleConditions() {
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            for (BuildCondition bc : BuildCondition.all()) {
                Set symbols = SymbolLookup.getSymbolValue((Object)bc);
                if (symbols.isEmpty()) continue;
                conditionMap.put((String)symbols.iterator().next(), bc.getDescription());
            }
            return conditionMap.entrySet();
        }

        @Override
        @NonNull
        public String toGroovy(@NonNull PostDirective directive) {
            StringBuilder result = new StringBuilder("post {\n");
            if (!directive.getConditions().isEmpty()) {
                for (String bc : directive.getConditions()) {
                    result.append(bc).append(" {\n");
                    result.append("// One or more steps need to be included within each condition's block.\n");
                    result.append("}\n");
                }
            } else {
                result.append("// No post conditions specified\n");
            }
            result.append("}\n");
            return result.toString();
        }
    }
}

