/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.properties;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.OptionalJobProperty;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKeyValueOrMethodCallPair;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMethodArg;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTOption;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.properties.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.DeclarativeValidatorContributor;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PreserveStashesJobProperty
extends OptionalJobProperty<WorkflowJob> {
    private static final Logger LOGGER = Logger.getLogger(PreserveStashesJobProperty.class.getName());
    public static final int MAX_SAVED_STASHES = 50;
    private int buildCount = 1;

    @DataBoundConstructor
    public PreserveStashesJobProperty() {
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    @DataBoundSetter
    public void setBuildCount(int buildCount) {
        if (buildCount > 50) {
            throw new IllegalArgumentException("buildCount must be between 1 and 50");
        }
        this.buildCount = buildCount;
    }

    @Extension
    public static class ValidatorImpl
    extends DeclarativeValidatorContributor {
        @CheckForNull
        public String validateElement(@NonNull ModelASTOption option, @CheckForNull FlowExecution execution) {
            if (option.getName() != null && option.getName().equals("preserveStashes")) {
                for (ModelASTMethodArg arg : option.getArgs()) {
                    Integer v;
                    ModelASTKeyValueOrMethodCallPair namedArg;
                    if (!(arg instanceof ModelASTKeyValueOrMethodCallPair) || !(namedArg = (ModelASTKeyValueOrMethodCallPair)arg).getKey().getKey().equals("buildCount") || !(namedArg.getValue() instanceof ModelASTValue) || !(((ModelASTValue)namedArg.getValue()).getValue() instanceof Integer) || (v = (Integer)((ModelASTValue)namedArg.getValue()).getValue()) >= 1 && v <= 50) continue;
                    return Messages.PreserveStashesJobProperty_ValidatorImpl_InvalidBuildCount(50);
                }
            }
            return null;
        }
    }

    @Extension
    public static final class StashClearingListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> r, TaskListener listener) {
            WorkflowJob j;
            PreserveStashesJobProperty prop;
            if (r instanceof WorkflowRun && (prop = (PreserveStashesJobProperty)(j = (WorkflowJob)((WorkflowRun)r).getParent()).getProperty(PreserveStashesJobProperty.class)) != null && prop.getBuildCount() > 0) {
                for (WorkflowRun build : j.getBuilds().completedOnly().limit(51)) {
                    try {
                        StashManager.maybeClearAll((Run)build);
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, "failed to clean up stashes from " + build, x);
                    }
                }
            }
        }
    }

    @Extension
    public static final class SaveStashes
    extends StashManager.StashBehavior {
        public boolean shouldClearAll(@NonNull Run<?, ?> build) {
            int bc;
            WorkflowRun r;
            WorkflowJob j;
            PreserveStashesJobProperty prop;
            if (build instanceof WorkflowRun && (prop = (PreserveStashesJobProperty)(j = (WorkflowJob)(r = (WorkflowRun)build).getParent()).getProperty(PreserveStashesJobProperty.class)) != null && (bc = prop.getBuildCount()) > 0) {
                for (WorkflowRun recentRun : j.getBuilds().completedOnly().limit(bc)) {
                    if (recentRun == null || recentRun.getNumber() != r.getNumber()) continue;
                    return false;
                }
            }
            return true;
        }
    }

    @Extension
    @Symbol(value={"preserveStashes"})
    public static class DescriptorImpl
    extends OptionalJobProperty.OptionalJobPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Preserve stashes from completed builds";
        }

        public FormValidation doCheckBuildCount(@QueryParameter int value) {
            if (value < 0) {
                return FormValidation.error((String)"Must be greater than or equal to 0");
            }
            if (value > 50) {
                return FormValidation.error((String)"Must be 50 or less");
            }
            return FormValidation.ok();
        }
    }
}

