/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.jvm.JvmMemberSignature;
import kotlin.metadata.jvm.JvmMethodSignature;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.kotlin.abi.tools.v2.AccessFlags;
import org.jetbrains.kotlin.abi.tools.v2.ClassVisibility;
import org.jetbrains.kotlin.abi.tools.v2.KotlinMetadataVisibilitiesKt;
import org.jetbrains.kotlin.abi.tools.v2.MemberBinarySignature;
import org.jetbrains.kotlin.abi.tools.v2.MemberVisibility;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\u0005H\u0002J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003JC\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0083\u0004J\n\u0010+\u001a\u00020,H\u00d6\u0081\u0004J\n\u0010-\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/MethodBinarySignature;", "Lorg/jetbrains/kotlin/abi/tools/v2/MemberBinarySignature;", "jvmMember", "Lkotlin/metadata/jvm/JvmMethodSignature;", "isPublishedApi", "", "access", "Lorg/jetbrains/kotlin/abi/tools/v2/AccessFlags;", "annotations", "", "Lorg/jetbrains/kotlin/abi/tools/org/objectweb/asm/tree/AnnotationNode;", "alternateDefaultSignature", "<init>", "(Lkotlin/metadata/jvm/JvmMethodSignature;ZLorg/jetbrains/kotlin/abi/tools/v2/AccessFlags;Ljava/util/List;Lkotlin/metadata/jvm/JvmMethodSignature;)V", "getJvmMember", "()Lkotlin/metadata/jvm/JvmMethodSignature;", "()Z", "getAccess", "()Lorg/jetbrains/kotlin/abi/tools/v2/AccessFlags;", "getAnnotations", "()Ljava/util/List;", "signature", "", "getSignature", "()Ljava/lang/String;", "isEffectivelyPublic", "classAccess", "classVisibility", "Lorg/jetbrains/kotlin/abi/tools/v2/ClassVisibility;", "findMemberVisibility", "Lorg/jetbrains/kotlin/abi/tools/v2/MemberVisibility;", "isAccessOrAnnotationsMethod", "isDummyDefaultConstructor", "isSuspendImplMethod", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataSignature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataSignature.kt\norg/jetbrains/kotlin/abi/tools/v2/MethodBinarySignature\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class MethodBinarySignature
implements MemberBinarySignature {
    @NotNull
    private final JvmMethodSignature jvmMember;
    private final boolean isPublishedApi;
    @NotNull
    private final AccessFlags access;
    @NotNull
    private final List<AnnotationNode> annotations;
    @Nullable
    private final JvmMethodSignature alternateDefaultSignature;

    public MethodBinarySignature(@NotNull JvmMethodSignature jvmMember, boolean isPublishedApi, @NotNull AccessFlags access, @NotNull List<? extends AnnotationNode> annotations, @Nullable JvmMethodSignature alternateDefaultSignature) {
        Intrinsics.checkNotNullParameter((Object)jvmMember, (String)"jvmMember");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        this.jvmMember = jvmMember;
        this.isPublishedApi = isPublishedApi;
        this.access = access;
        this.annotations = annotations;
        this.alternateDefaultSignature = alternateDefaultSignature;
    }

    @NotNull
    public JvmMethodSignature getJvmMember() {
        return this.jvmMember;
    }

    @Override
    public boolean isPublishedApi() {
        return this.isPublishedApi;
    }

    @Override
    @NotNull
    public AccessFlags getAccess() {
        return this.access;
    }

    @Override
    @NotNull
    public List<AnnotationNode> getAnnotations() {
        return this.annotations;
    }

    @Override
    @NotNull
    public String getSignature() {
        return this.getAccess().getModifierString() + " fun " + this.getName() + ' ' + this.getDesc();
    }

    @Override
    public boolean isEffectivelyPublic(@NotNull AccessFlags classAccess, @Nullable ClassVisibility classVisibility) {
        Intrinsics.checkNotNullParameter((Object)classAccess, (String)"classAccess");
        return MemberBinarySignature.super.isEffectivelyPublic(classAccess, classVisibility) && !this.isAccessOrAnnotationsMethod() && !this.isDummyDefaultConstructor() && !this.isSuspendImplMethod();
    }

    @Override
    @Nullable
    public MemberVisibility findMemberVisibility(@Nullable ClassVisibility classVisibility) {
        MemberVisibility memberVisibility = MemberBinarySignature.super.findMemberVisibility(classVisibility);
        if (memberVisibility == null) {
            ClassVisibility classVisibility2 = classVisibility;
            if (classVisibility2 != null) {
                ClassVisibility it = classVisibility2;
                boolean bl = false;
                JvmMethodSignature jvmMethodSignature = this.alternateDefaultSignature;
                if (jvmMethodSignature != null) {
                    JvmMemberSignature p0 = (JvmMemberSignature)jvmMethodSignature;
                    boolean bl2 = false;
                    memberVisibility = KotlinMetadataVisibilitiesKt.findMember(it, p0);
                } else {
                    memberVisibility = null;
                }
            } else {
                memberVisibility = null;
            }
        }
        return memberVisibility;
    }

    private final boolean isAccessOrAnnotationsMethod() {
        return this.getAccess().isSynthetic() && (StringsKt.startsWith$default((String)this.getName(), (String)"access$", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.getName(), (String)"$annotations", (boolean)false, (int)2, null));
    }

    private final boolean isDummyDefaultConstructor() {
        return this.getAccess().isSynthetic() && Intrinsics.areEqual((Object)this.getName(), (Object)"<init>") && Intrinsics.areEqual((Object)this.getDesc(), (Object)"(Lkotlin/jvm/internal/DefaultConstructorMarker;)V");
    }

    private final boolean isSuspendImplMethod() {
        return this.getAccess().isSynthetic() && StringsKt.endsWith$default((String)this.getName(), (String)"$suspendImpl", (boolean)false, (int)2, null);
    }

    @NotNull
    public final JvmMethodSignature component1() {
        return this.jvmMember;
    }

    public final boolean component2() {
        return this.isPublishedApi;
    }

    @NotNull
    public final AccessFlags component3() {
        return this.access;
    }

    @NotNull
    public final List<AnnotationNode> component4() {
        return this.annotations;
    }

    private final JvmMethodSignature component5() {
        return this.alternateDefaultSignature;
    }

    @NotNull
    public final MethodBinarySignature copy(@NotNull JvmMethodSignature jvmMember, boolean isPublishedApi, @NotNull AccessFlags access, @NotNull List<? extends AnnotationNode> annotations, @Nullable JvmMethodSignature alternateDefaultSignature) {
        Intrinsics.checkNotNullParameter((Object)jvmMember, (String)"jvmMember");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        return new MethodBinarySignature(jvmMember, isPublishedApi, access, annotations, alternateDefaultSignature);
    }

    public static /* synthetic */ MethodBinarySignature copy$default(MethodBinarySignature methodBinarySignature, JvmMethodSignature jvmMethodSignature, boolean bl, AccessFlags accessFlags, List list, JvmMethodSignature jvmMethodSignature2, int n, Object object) {
        if ((n & 1) != 0) {
            jvmMethodSignature = methodBinarySignature.jvmMember;
        }
        if ((n & 2) != 0) {
            bl = methodBinarySignature.isPublishedApi;
        }
        if ((n & 4) != 0) {
            accessFlags = methodBinarySignature.access;
        }
        if ((n & 8) != 0) {
            list = methodBinarySignature.annotations;
        }
        if ((n & 0x10) != 0) {
            jvmMethodSignature2 = methodBinarySignature.alternateDefaultSignature;
        }
        return methodBinarySignature.copy(jvmMethodSignature, bl, accessFlags, list, jvmMethodSignature2);
    }

    @NotNull
    public String toString() {
        return "MethodBinarySignature(jvmMember=" + this.jvmMember + ", isPublishedApi=" + this.isPublishedApi + ", access=" + this.access + ", annotations=" + this.annotations + ", alternateDefaultSignature=" + this.alternateDefaultSignature + ')';
    }

    public int hashCode() {
        int result = this.jvmMember.hashCode();
        result = result * 31 + Boolean.hashCode(this.isPublishedApi);
        result = result * 31 + this.access.hashCode();
        result = result * 31 + ((Object)this.annotations).hashCode();
        result = result * 31 + (this.alternateDefaultSignature == null ? 0 : this.alternateDefaultSignature.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodBinarySignature)) {
            return false;
        }
        MethodBinarySignature methodBinarySignature = (MethodBinarySignature)other;
        if (!Intrinsics.areEqual((Object)this.jvmMember, (Object)methodBinarySignature.jvmMember)) {
            return false;
        }
        if (this.isPublishedApi != methodBinarySignature.isPublishedApi) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.access, (Object)methodBinarySignature.access)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.annotations, methodBinarySignature.annotations)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.alternateDefaultSignature, (Object)methodBinarySignature.alternateDefaultSignature);
    }
}

