/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.impl.jvm;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.metadata.KmClass;
import kotlin.metadata.jvm.JvmFieldSignature;
import kotlin.metadata.jvm.JvmMethodSignature;
import kotlin.metadata.jvm.KotlinClassMetadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.impl.jvm.AccessFlags;
import org.jetbrains.kotlin.abi.tools.impl.jvm.AsmMetadataLoadingKt;
import org.jetbrains.kotlin.abi.tools.impl.jvm.FieldBinarySignature;
import org.jetbrains.kotlin.abi.tools.impl.jvm.MemberBinarySignature;
import org.jetbrains.kotlin.abi.tools.impl.jvm.MethodBinarySignature;
import org.jetbrains.kotlin.abi.tools.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.kotlin.abi.tools.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.kotlin.abi.tools.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.kotlin.abi.tools.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a$\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u001a\u0016\u0010\u0017\u001a\u00020\u0018*\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u001a\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u0004*\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"$\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0013j\b\u0012\u0004\u0012\u00020\u000f`\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"alternateDefaultSignature", "Lkotlin/metadata/jvm/JvmMethodSignature;", "Lorg/jetbrains/kotlin/abi/tools/org/objectweb/asm/tree/MethodNode;", "className", "", "toMethodBinarySignature", "Lorg/jetbrains/kotlin/abi/tools/impl/jvm/MethodBinarySignature;", "extraAnnotations", "", "Lorg/jetbrains/kotlin/abi/tools/org/objectweb/asm/tree/AnnotationNode;", "toFieldBinarySignature", "Lorg/jetbrains/kotlin/abi/tools/impl/jvm/FieldBinarySignature;", "Lorg/jetbrains/kotlin/abi/tools/org/objectweb/asm/tree/FieldNode;", "kind", "", "Lorg/jetbrains/kotlin/abi/tools/impl/jvm/MemberBinarySignature;", "getKind", "(Lorg/jetbrains/kotlin/abi/tools/impl/jvm/MemberBinarySignature;)I", "MEMBER_SORT_ORDER", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getMEMBER_SORT_ORDER", "()Ljava/util/Comparator;", "isCompanionField", "", "outerClassMetadata", "Lkotlin/metadata/jvm/KotlinClassMetadata;", "companionName", "Lorg/jetbrains/kotlin/abi/tools/org/objectweb/asm/tree/ClassNode;", "abi-tools"})
public final class KotlinMetadataSignatureKt {
    @NotNull
    private static final Comparator<MemberBinarySignature> MEMBER_SORT_ORDER;

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final JvmMethodSignature alternateDefaultSignature(@NotNull MethodNode $this$alternateDefaultSignature, @NotNull String className) {
        JvmMethodSignature jvmMethodSignature;
        Intrinsics.checkNotNullParameter((Object)$this$alternateDefaultSignature, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (($this$alternateDefaultSignature.access & 0x1000) == 0) {
            return null;
        }
        if (Intrinsics.areEqual((Object)$this$alternateDefaultSignature.name, (Object)"<init>")) {
            String string = $this$alternateDefaultSignature.desc;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"desc");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"ILkotlin/jvm/internal/DefaultConstructorMarker;", (boolean)false, (int)2, null)) {
                String string2 = $this$alternateDefaultSignature.name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                String string3 = $this$alternateDefaultSignature.desc;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
                jvmMethodSignature = new JvmMethodSignature(string2, StringsKt.replace$default((String)string3, (String)"ILkotlin/jvm/internal/DefaultConstructorMarker;", (String)"", (boolean)false, (int)4, null));
                return jvmMethodSignature;
            }
        }
        String string = $this$alternateDefaultSignature.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)"$default", (boolean)false, (int)2, null)) return null;
        String string4 = $this$alternateDefaultSignature.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"desc");
        if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)"ILjava/lang/Object;)", (boolean)false, (int)2, null)) return null;
        String string5 = $this$alternateDefaultSignature.name;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"name");
        String string6 = StringsKt.removeSuffix((String)string5, (CharSequence)"$default");
        String string7 = $this$alternateDefaultSignature.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"desc");
        jvmMethodSignature = new JvmMethodSignature(string6, StringsKt.replace$default((String)StringsKt.replace$default((String)string7, (String)"ILjava/lang/Object;)", (String)")", (boolean)false, (int)4, null), (String)("(L" + className + ';'), (String)"(", (boolean)false, (int)4, null));
        return jvmMethodSignature;
    }

    @NotNull
    public static final MethodBinarySignature toMethodBinarySignature(@NotNull MethodNode $this$toMethodBinarySignature, @NotNull List<? extends AnnotationNode> extraAnnotations, @Nullable JvmMethodSignature alternateDefaultSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$toMethodBinarySignature, (String)"<this>");
        Intrinsics.checkNotNullParameter(extraAnnotations, (String)"extraAnnotations");
        List list = $this$toMethodBinarySignature.visibleAnnotations;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        List list2 = $this$toMethodBinarySignature.invisibleAnnotations;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List allAnnotations = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list2), (Iterable)extraAnnotations);
        String string = $this$toMethodBinarySignature.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String string2 = $this$toMethodBinarySignature.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"desc");
        return new MethodBinarySignature(new JvmMethodSignature(string, string2), AsmMetadataLoadingKt.isPublishedApi(allAnnotations), new AccessFlags($this$toMethodBinarySignature.access), allAnnotations, alternateDefaultSignature);
    }

    @NotNull
    public static final FieldBinarySignature toFieldBinarySignature(@NotNull FieldNode $this$toFieldBinarySignature, @NotNull List<? extends AnnotationNode> extraAnnotations) {
        Intrinsics.checkNotNullParameter((Object)$this$toFieldBinarySignature, (String)"<this>");
        Intrinsics.checkNotNullParameter(extraAnnotations, (String)"extraAnnotations");
        List list = $this$toFieldBinarySignature.visibleAnnotations;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        List list2 = $this$toFieldBinarySignature.invisibleAnnotations;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List allAnnotations = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Iterable)list2), (Iterable)extraAnnotations);
        String string = $this$toFieldBinarySignature.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String string2 = $this$toFieldBinarySignature.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"desc");
        return new FieldBinarySignature(new JvmFieldSignature(string, string2), AsmMetadataLoadingKt.isPublishedApi(allAnnotations), new AccessFlags($this$toFieldBinarySignature.access), allAnnotations);
    }

    private static final int getKind(MemberBinarySignature $this$kind) {
        int n;
        MemberBinarySignature memberBinarySignature = $this$kind;
        if (memberBinarySignature instanceof FieldBinarySignature) {
            n = 1;
        } else if (memberBinarySignature instanceof MethodBinarySignature) {
            n = 2;
        } else {
            throw new IllegalStateException(("Unsupported " + $this$kind).toString());
        }
        return n;
    }

    @NotNull
    public static final Comparator<MemberBinarySignature> getMEMBER_SORT_ORDER() {
        return MEMBER_SORT_ORDER;
    }

    public static final boolean isCompanionField(@NotNull FieldNode $this$isCompanionField, @Nullable KotlinClassMetadata outerClassMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompanionField, (String)"<this>");
        AccessFlags access = new AccessFlags($this$isCompanionField.access);
        if (!access.isFinal() || !access.isStatic()) {
            return false;
        }
        KotlinClassMetadata kotlinClassMetadata = outerClassMetadata;
        if (kotlinClassMetadata == null) {
            return false;
        }
        KotlinClassMetadata metadata = kotlinClassMetadata;
        if (!(metadata instanceof KotlinClassMetadata.Class)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((KotlinClassMetadata.Class)metadata).getKmClass().getCompanionObject(), (Object)$this$isCompanionField.name);
    }

    @Nullable
    public static final String companionName(@NotNull ClassNode $this$companionName, @Nullable KotlinClassMetadata outerClassMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$companionName, (String)"<this>");
        if (!(outerClassMetadata instanceof KotlinClassMetadata.Class)) {
            return null;
        }
        KmClass outerKClass = ((KotlinClassMetadata.Class)outerClassMetadata).getKmClass();
        return $this$companionName.name + '$' + outerKClass.getCompanionObject();
    }

    private static final Comparable MEMBER_SORT_ORDER$lambda$0(MemberBinarySignature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Integer.valueOf(KotlinMetadataSignatureKt.getKind(it));
    }

    private static final Comparable MEMBER_SORT_ORDER$lambda$1(MemberBinarySignature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getName());
    }

    private static final Comparable MEMBER_SORT_ORDER$lambda$2(MemberBinarySignature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.getDesc());
    }

    static {
        Function1[] function1Array = new Function1[]{KotlinMetadataSignatureKt::MEMBER_SORT_ORDER$lambda$0, KotlinMetadataSignatureKt::MEMBER_SORT_ORDER$lambda$1, KotlinMetadataSignatureKt::MEMBER_SORT_ORDER$lambda$2};
        MEMBER_SORT_ORDER = ComparisonsKt.compareBy((Function1[])function1Array);
    }
}

