/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.impl.klib;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.AbiFilters;
import org.jetbrains.kotlin.abi.tools.KlibDump;
import org.jetbrains.kotlin.abi.tools.KlibTarget;
import org.jetbrains.kotlin.abi.tools.impl.klib.KlibAbiDumpMerger;
import org.jetbrains.kotlin.abi.tools.impl.klib.KlibDumpImplKt;
import org.jetbrains.kotlin.abi.tools.impl.klib.KlibReadingKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0001H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0001H\u0016J\u0016\u0010\u0015\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0001H\u0016J#\u0010\u0019\u001a\u0002H\u001a\"\f\b\u0000\u0010\u001a*\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u0002H\u001aH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0018\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\nH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/abi/tools/impl/klib/KlibDumpImpl;", "Lorg/jetbrains/kotlin/abi/tools/KlibDump;", "<init>", "()V", "merger", "Lorg/jetbrains/kotlin/abi/tools/impl/klib/KlibAbiDumpMerger;", "getMerger$abi_tools", "()Lorg/jetbrains/kotlin/abi/tools/impl/klib/KlibAbiDumpMerger;", "targets", "", "Lorg/jetbrains/kotlin/abi/tools/KlibTarget;", "getTargets", "()Ljava/util/Set;", "merge", "", "dumpFile", "Ljava/io/File;", "dump", "", "other", "replace", "retain", "", "remove", "copy", "print", "A", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "to", "(Ljava/lang/Appendable;)Ljava/lang/Appendable;", "renameSingleTarget", "target", "file", "inferAbiForUnsupportedTarget", "previousDump", "Companion", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nKlibDumpImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibDumpImpl.kt\norg/jetbrains/kotlin/abi/tools/impl/klib/KlibDumpImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1#2:246\n1915#3,2:247\n296#3,2:249\n*S KotlinDebug\n*F\n+ 1 KlibDumpImpl.kt\norg/jetbrains/kotlin/abi/tools/impl/klib/KlibDumpImpl\n*L\n82#1:247,2\n115#1:249,2\n*E\n"})
public final class KlibDumpImpl
implements KlibDump {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KlibAbiDumpMerger merger = new KlibAbiDumpMerger();

    @NotNull
    public final KlibAbiDumpMerger getMerger$abi_tools() {
        return this.merger;
    }

    @NotNull
    public Set<KlibTarget> getTargets() {
        return this.merger.getTargets$abi_tools();
    }

    public void merge(@NotNull File dumpFile) {
        Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
        if (!dumpFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + dumpFile.getAbsolutePath());
        }
        if (!dumpFile.isFile()) {
            boolean bl = false;
            String string = "Not a file: " + dumpFile.getAbsolutePath();
            throw new IllegalArgumentException(string.toString());
        }
        this.merger.merge$abi_tools(dumpFile);
    }

    public void merge(@NotNull CharSequence dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        this.merger.merge$abi_tools(StringsKt.lineSequence((CharSequence)dump).iterator());
    }

    public void merge(@NotNull KlibDump other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Set intersection = CollectionsKt.intersect((Iterable)this.getTargets(), (Iterable)other.getTargets());
        if (!intersection.isEmpty()) {
            boolean bl = false;
            String string = "Cannot merge dump as this and other dumps share some targets: " + intersection;
            throw new IllegalArgumentException(string.toString());
        }
        this.merger.merge(((KlibDumpImpl)other).merger);
    }

    public void replace(@NotNull KlibDump other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.remove(other.getTargets());
        this.merge(other);
    }

    public void retain(@NotNull Iterable<KlibTarget> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Set toRemove = CollectionsKt.subtract((Iterable)this.merger.getTargets$abi_tools(), (Iterable)CollectionsKt.toSet(targets));
        this.remove(toRemove);
    }

    public void remove(@NotNull Iterable<KlibTarget> targets) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Iterable<KlibTarget> $this$forEach$iv = targets;
        boolean $i$f$forEach = false;
        Iterator<KlibTarget> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            KlibTarget element$iv;
            KlibTarget it = element$iv = iterator.next();
            boolean bl = false;
            this.merger.remove(it);
        }
    }

    @NotNull
    public KlibDump copy() {
        KlibDumpImpl klibDumpImpl;
        KlibDumpImpl it = klibDumpImpl = new KlibDumpImpl();
        boolean bl = false;
        it.merge(this);
        return klibDumpImpl;
    }

    @NotNull
    public <A extends Appendable> A print(@NotNull A to) {
        Intrinsics.checkNotNullParameter(to, (String)"to");
        this.merger.dump(to);
        return to;
    }

    public void renameSingleTarget(@NotNull KlibTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(this.merger.getTargets$abi_tools().size() == 1)) {
            boolean bl = false;
            String string = "Can't use an explicit target name with a multi-target dump. new target: " + target + ", targets in the dump: " + this.getTargets();
            throw new IllegalStateException(string.toString());
        }
        this.merger.overrideTargets(SetsKt.setOf((Object)target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public File print(@NotNull File file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$print_u24lambda_u240 = file2 = file;
        boolean bl = false;
        Object object = $this$print_u24lambda_u240;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl2 = false;
            this.print((Appendable)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return file2;
    }

    @NotNull
    public KlibDump inferAbiForUnsupportedTarget(@NotNull KlibDump previousDump, @NotNull KlibTarget target) {
        KlibDump klibDump;
        Intrinsics.checkNotNullParameter((Object)previousDump, (String)"previousDump");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Collection matchingTargets = KlibDumpImplKt.access$findMatchingTargets(this.getTargets(), target);
        if (!matchingTargets.isEmpty()) {
            KlibDump klibDump2;
            KlibDump it = klibDump2 = this.copy();
            boolean bl = false;
            it.retain((Iterable)matchingTargets);
            KlibDump retained = klibDump2;
            klibDump = KlibDumpImplKt.inferAbi(target, CollectionsKt.listOf((Object)retained), previousDump);
        } else {
            Object v1;
            block7: {
                Iterable $this$firstOrNull$iv = previousDump.getTargets();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KlibTarget it = (KlibTarget)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getTargetName(), (Object)target.getTargetName())) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            KlibTarget targetFromReference = v1;
            if (targetFromReference != null) {
                KlibDump copy = previousDump.copy();
                copy.retain((Iterable)CollectionsKt.listOf((Object)targetFromReference));
                klibDump = copy;
            } else if (!((Collection)previousDump.getTargets()).isEmpty()) {
                klibDump = new KlibDumpImpl();
            } else {
                throw new IllegalStateException("The target " + target + " is not supported by the host compiler and there are no targets similar to " + target + " to infer a dump from it.");
            }
        }
        return klibDump;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\bJ\u001d\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/abi/tools/impl/klib/KlibDumpImpl$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/kotlin/abi/tools/KlibDump;", "dumpFile", "Ljava/io/File;", "from$abi_tools", "dump", "", "fromKlib", "klibFile", "filters", "Lorg/jetbrains/kotlin/abi/tools/AbiFilters;", "fromKlib$abi_tools", "abi-tools"})
    @SourceDebugExtension(value={"SMAP\nKlibDumpImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibDumpImpl.kt\norg/jetbrains/kotlin/abi/tools/impl/klib/KlibDumpImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n1#2:246\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KlibDump from$abi_tools(@NotNull File dumpFile) {
            KlibDumpImpl klibDumpImpl;
            Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
            if (!dumpFile.exists()) {
                throw new FileNotFoundException("File does not exist: " + dumpFile.getAbsolutePath());
            }
            if (!dumpFile.isFile()) {
                boolean $i$a$-require-KlibDumpImpl$Companion$from$22 = false;
                String $i$a$-require-KlibDumpImpl$Companion$from$22 = "Not a file: " + dumpFile.getAbsolutePath();
                throw new IllegalArgumentException($i$a$-require-KlibDumpImpl$Companion$from$22.toString());
            }
            KlibDumpImpl $this$from_u24lambda_u241 = klibDumpImpl = new KlibDumpImpl();
            boolean bl = false;
            $this$from_u24lambda_u241.merge(dumpFile);
            return klibDumpImpl;
        }

        @NotNull
        public final KlibDump from$abi_tools(@NotNull CharSequence dump) {
            KlibDumpImpl klibDumpImpl;
            Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
            KlibDumpImpl $this$from_u24lambda_u242 = klibDumpImpl = new KlibDumpImpl();
            boolean bl = false;
            $this$from_u24lambda_u242.merge(dump);
            return klibDumpImpl;
        }

        @NotNull
        public final KlibDump fromKlib$abi_tools(@NotNull File klibFile, @NotNull AbiFilters filters) {
            Intrinsics.checkNotNullParameter((Object)klibFile, (String)"klibFile");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Object object = new StringBuilder();
            StringBuilder $this$fromKlib_u24lambda_u240 = object;
            boolean bl = false;
            KlibReadingKt.extractAbiFromKlib($this$fromKlib_u24lambda_u240, klibFile, filters);
            String dump = ((StringBuilder)object).toString();
            Object $this$fromKlib_u24lambda_u241 = object = new KlibDumpImpl();
            boolean bl2 = false;
            char[] cArray = new char[]{'\n'};
            ((KlibDumpImpl)$this$fromKlib_u24lambda_u241).getMerger$abi_tools().merge$abi_tools(StringsKt.splitToSequence$default((CharSequence)dump, (char[])cArray, (boolean)false, (int)0, (int)6, null).iterator());
            return (KlibDump)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

