/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.IntExternalizer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004J\u0019\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0002H\u0086\u0002J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/FileToIdMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "file", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dumpValue", "", "value", "get", "(Ljava/io/File;)Ljava/lang/Integer;", "remove", "", "set", "id", "toMap", "", "kotlin-build-common"})
public final class FileToIdMap
extends BasicStringMap<Integer> {
    private final FileToPathConverter pathConverter;

    @Override
    @NotNull
    protected String dumpValue(int value) {
        return String.valueOf(value);
    }

    @Nullable
    public final Integer get(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return (Integer)this.getStorage().get(this.pathConverter.toPath(file));
    }

    public final void set(@NotNull File file, int id) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.getStorage().set(this.pathConverter.toPath(file), id);
    }

    public final void remove(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.getStorage().remove(this.pathConverter.toPath(file));
    }

    @NotNull
    public final Map<File, Integer> toMap() {
        HashMap result = new HashMap();
        for (String key : this.getStorage().getKeys()) {
            Integer n = (Integer)this.getStorage().get(key);
            if (n == null) {
                continue;
            }
            int value = n;
            ((Map)result).put(this.pathConverter.toFile(key), value);
        }
        return result;
    }

    public FileToIdMap(@NotNull File file, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)pathConverter, (String)"pathConverter");
        super(file, IntExternalizer.INSTANCE);
        this.pathConverter = pathConverter;
    }
}

