/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.internal.serialization.KSerializer;
import org.jetbrains.kotlin.buildtools.internal.serialization.SerializationException;
import org.jetbrains.kotlin.buildtools.internal.serialization.SerializationStrategy;
import org.jetbrains.kotlin.buildtools.internal.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.kotlin.buildtools.internal.serialization.descriptors.PolymorphicKind;
import org.jetbrains.kotlin.buildtools.internal.serialization.descriptors.SerialDescriptor;
import org.jetbrains.kotlin.buildtools.internal.serialization.descriptors.SerialKind;
import org.jetbrains.kotlin.buildtools.internal.serialization.descriptors.StructureKind;
import org.jetbrains.kotlin.buildtools.internal.serialization.encoding.CompositeEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.encoding.Encoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.internal.MapLikeSerializer;
import org.jetbrains.kotlin.buildtools.internal.serialization.modules.SerializersModule;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.ProtoBuf;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.ProtoIntegerType;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.HelpersKt;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.MapRepeatedEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.NestedRepeatedEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.ObjectEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.OneOfPolymorphicEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.PackedArrayEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.ProtobufTaggedEncoder;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.ProtobufWriter;
import org.jetbrains.kotlin.buildtools.internal.serialization.protobuf.internal.RepeatedEncoder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0014J\u001c\u0010\u001e\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001fH\u0014J\u001c\u0010 \u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020!H\u0014J\u001c\u0010\"\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0014J\u001c\u0010#\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020$H\u0014J\u001c\u0010%\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001bH\u0014J\u001c\u0010&\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020'H\u0014J\u001c\u0010(\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020)H\u0014J\u001c\u0010*\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020+H\u0014J$\u0010,\u001a\u00020\u00192\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0013H\u0014J\u0018\u0010/\u001a\u00060\u001bj\u0002`\u001c*\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J)\u00100\u001a\u00020\u0019\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u0006\u0010\u001d\u001a\u0002H1H\u0016\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u000206H\u0002J)\u00107\u001a\u00020\u0019\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\u0006\u0010\u001d\u001a\u0002H1H\u0002\u00a2\u0006\u0002\u00104R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtobufEncoder;", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtobufTaggedEncoder;", "proto", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/ProtoBuf;", "writer", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtobufWriter;", "descriptor", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "serializersModule", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/modules/SerializersModule;", "getSerializersModule$annotations", "()V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "shouldEncodeElementDefault", "", "index", "", "beginCollection", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/encoding/CompositeEncoder;", "collectionSize", "beginStructure", "encodeTaggedInt", "", "tag", "", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/protobuf/internal/ProtoDesc;", "value", "encodeTaggedByte", "", "encodeTaggedShort", "", "encodeTaggedBoolean", "encodeTaggedChar", "", "encodeTaggedLong", "encodeTaggedFloat", "", "encodeTaggedDouble", "", "encodeTaggedString", "", "encodeTaggedEnum", "enumDescriptor", "ordinal", "getTag", "encodeSerializableValue", "T", "serializer", "Lorg/jetbrains/kotlin/buildtools/internal/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "serializeByteArray", "", "serializeMap", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufEncoder\n+ 2 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n1#1,291:1\n52#2:292\n52#2:293\n52#2:294\n52#2:295\n52#2:296\n52#2:297\n52#2:298\n*S KotlinDebug\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufEncoder\n*L\n80#1:292\n93#1:293\n101#1:294\n109#1:295\n117#1:296\n133#1:297\n154#1:298\n*E\n"})
public class ProtobufEncoder
extends ProtobufTaggedEncoder {
    @JvmField
    @NotNull
    protected final ProtoBuf proto;
    @NotNull
    private final ProtobufWriter writer;
    @JvmField
    @NotNull
    protected final SerialDescriptor descriptor;

    public ProtobufEncoder(@NotNull ProtoBuf proto, @NotNull ProtobufWriter writer, @NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.proto = proto;
        this.writer = writer;
        this.descriptor = descriptor;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    public static /* synthetic */ void getSerializersModule$annotations() {
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.proto.getEncodeDefaults$kotlinx_serialization_protobuf();
    }

    @Override
    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            ProtobufEncoder protobufEncoder;
            long tag = this.getCurrentTagOrDefault();
            if (HelpersKt.isPacked(tag) && HelpersKt.isPackable(descriptor.getElementDescriptor(0))) {
                protobufEncoder = new PackedArrayEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor, null, 16, null);
            } else {
                if (tag == 19500L) {
                    this.writer.writeInt(collectionSize);
                }
                protobufEncoder = Intrinsics.areEqual((Object)this.descriptor.getKind(), (Object)StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual((Object)this.descriptor, (Object)descriptor) ? (ProtobufEncoder)new NestedRepeatedEncoder(this.proto, this.writer, tag, descriptor, null, 16, null) : (ProtobufEncoder)new RepeatedEncoder(this.proto, this.writer, tag, descriptor);
            }
            compositeEncoder = protobufEncoder;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeEncoder = new MapRepeatedEncoder(this.proto, this.getCurrentTag(), this.writer, descriptor);
        } else {
            throw new SerializationException("This serial kind is not supported as collection: " + descriptor);
        }
        return compositeEncoder;
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            compositeEncoder = HelpersKt.isPackable(descriptor.getElementDescriptor(0)) && HelpersKt.isPacked(this.getCurrentTagOrDefault()) ? (ProtobufEncoder)new PackedArrayEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor, null, 16, null) : (ProtobufEncoder)new RepeatedEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
            long tag = this.getCurrentTagOrDefault();
            compositeEncoder = tag == 19500L && Intrinsics.areEqual((Object)descriptor, (Object)this.descriptor) ? this : (HelpersKt.isOneOf(tag) ? (ProtobufEncoder)new OneOfPolymorphicEncoder(this.proto, this.writer, descriptor) : (ProtobufEncoder)new ObjectEncoder(this.proto, this.getCurrentTagOrDefault(), this.writer, null, descriptor, 8, null));
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            compositeEncoder = new MapRepeatedEncoder(this.proto, this.getCurrentTagOrDefault(), this.writer, descriptor);
        } else {
            throw new SerializationException("This serial kind is not supported as structure: " + descriptor);
        }
        return compositeEncoder;
    }

    @Override
    protected void encodeTaggedInt(long tag, int value) {
        if (tag == 19500L) {
            this.writer.writeInt(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeInt(value, (int)($this$protoId$iv & Integer.MAX_VALUE), HelpersKt.getIntegerType(tag));
        }
    }

    @Override
    protected void encodeTaggedByte(long tag, byte value) {
        this.encodeTaggedInt(tag, value);
    }

    @Override
    protected void encodeTaggedShort(long tag, short value) {
        this.encodeTaggedInt(tag, value);
    }

    @Override
    protected void encodeTaggedBoolean(long tag, boolean value) {
        this.encodeTaggedInt(tag, value ? 1 : 0);
    }

    @Override
    protected void encodeTaggedChar(long tag, char value) {
        this.encodeTaggedInt(tag, value);
    }

    @Override
    protected void encodeTaggedLong(long tag, long value) {
        if (tag == 19500L) {
            this.writer.writeLong(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeLong(value, (int)($this$protoId$iv & Integer.MAX_VALUE), HelpersKt.getIntegerType(tag));
        }
    }

    @Override
    protected void encodeTaggedFloat(long tag, float value) {
        if (tag == 19500L) {
            this.writer.writeFloat(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeFloat(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    @Override
    protected void encodeTaggedDouble(long tag, double value) {
        if (tag == 19500L) {
            this.writer.writeDouble(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeDouble(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    @Override
    protected void encodeTaggedString(long tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (tag == 19500L) {
            this.writer.writeString(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeString(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    @Override
    protected void encodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescriptor, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        int id = HelpersKt.extractProtoId(enumDescriptor, ordinal, true);
        if (tag == 19500L) {
            this.writer.writeInt(id);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeInt(id, (int)($this$protoId$iv & Integer.MAX_VALUE), ProtoIntegerType.DEFAULT);
        }
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$getTag, (String)"<this>");
        return HelpersKt.extractParameters($this$getTag, index);
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        if (serializer2 instanceof MapLikeSerializer) {
            this.serializeMap(serializer2, value);
        } else if (Intrinsics.areEqual((Object)serializer2.getDescriptor(), (Object)BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            this.serializeByteArray((byte[])value);
        } else {
            serializer2.serialize(this, value);
        }
    }

    private final void serializeByteArray(byte[] value) {
        long tag = this.popTagOrDefault();
        if (tag == 19500L) {
            this.writer.writeBytes(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeBytes(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    private final <T> void serializeMap(SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNull(serializer2, (String)"null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T of kotlinx.serialization.protobuf.internal.ProtobufEncoder.serializeMap, *>");
        MapLikeSerializer casted = (MapLikeSerializer)serializer2;
        KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer(casted.getKeySerializer(), casted.getValueSerializer());
        KSerializer kSerializer = BuiltinSerializersKt.SetSerializer(mapEntrySerial);
        Encoder encoder = this;
        Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        kSerializer.serialize(encoder, ((Map)value).entrySet());
    }
}

