/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.scripting.resolve;

import java.io.File;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ScriptCompilationConfiguration;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ScriptCompilationKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.ScriptIdeConfigurationKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.api.SourceCode;
import org.jetbrains.kotlin.buildtools.internal.scripting.jvm.JvmScriptCompilationKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.jvm.util.JvmClasspathUtilKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.buildtools.internal.scripting.util.PropertiesCollection;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010!\u001a\u00020\"H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/scripting/resolve/ScriptCompilationConfigurationWrapper;", "", "script", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/SourceCode;", "configuration", "Lorg/jetbrains/kotlin/buildtools/internal/scripting/api/ScriptCompilationConfiguration;", "<init>", "(Lkotlin/script/experimental/api/SourceCode;Lkotlin/script/experimental/api/ScriptCompilationConfiguration;)V", "getScript", "()Lkotlin/script/experimental/api/SourceCode;", "getConfiguration", "()Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "dependenciesClassPath", "", "Ljava/io/File;", "getDependenciesClassPath", "()Ljava/util/List;", "dependenciesClassPath$delegate", "Lkotlin/Lazy;", "dependenciesSources", "getDependenciesSources", "dependenciesSources$delegate", "javaHome", "getJavaHome", "()Ljava/io/File;", "defaultImports", "", "getDefaultImports", "importedScripts", "getImportedScripts", "equals", "", "other", "hashCode", "", "kotlin-scripting-compiler-impl"})
public final class ScriptCompilationConfigurationWrapper {
    @NotNull
    private final SourceCode script;
    @Nullable
    private final ScriptCompilationConfiguration configuration;
    @NotNull
    private final Lazy dependenciesClassPath$delegate;
    @NotNull
    private final Lazy dependenciesSources$delegate;

    public ScriptCompilationConfigurationWrapper(@NotNull SourceCode script, @Nullable ScriptCompilationConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.script = script;
        this.configuration = configuration;
        this.dependenciesClassPath$delegate = LazyKt.lazy(() -> ScriptCompilationConfigurationWrapper.dependenciesClassPath_delegate$lambda$0(this));
        this.dependenciesSources$delegate = LazyKt.lazy(() -> ScriptCompilationConfigurationWrapper.dependenciesSources_delegate$lambda$0(this));
    }

    @NotNull
    public final SourceCode getScript() {
        return this.script;
    }

    @Nullable
    public final ScriptCompilationConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final List<File> getDependenciesClassPath() {
        Lazy lazy = this.dependenciesClassPath$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<File> getDependenciesSources() {
        Lazy lazy = this.dependenciesSources$delegate;
        return (List)lazy.getValue();
    }

    @Nullable
    public final File getJavaHome() {
        ScriptCompilationConfiguration scriptCompilationConfiguration = this.configuration;
        return scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(JvmScriptCompilationKt.getJdkHome(JvmScriptCompilationKt.getJvm(ScriptCompilationConfiguration.Companion))) : null;
    }

    @NotNull
    public final List<String> getDefaultImports() {
        ScriptCompilationConfiguration scriptCompilationConfiguration = this.configuration;
        List list = scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptCompilationKt.getDefaultImports(ScriptCompilationConfiguration.Companion)) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<SourceCode> getImportedScripts() {
        List list;
        Object object = this.configuration;
        if (object == null || (object = ((PropertiesCollection)object).get(RefineCompilationConfigurationKt.getResolvedImportScripts(ScriptCompilationConfiguration.Companion))) == null) {
            ScriptCompilationConfiguration scriptCompilationConfiguration = this.configuration;
            object = list = scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptCompilationKt.getImportScripts(ScriptCompilationConfiguration.Companion)) : null;
        }
        if (object == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public boolean equals(@Nullable Object other) {
        ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = other instanceof ScriptCompilationConfigurationWrapper ? (ScriptCompilationConfigurationWrapper)other : null;
        return Intrinsics.areEqual((Object)this.script, (Object)(scriptCompilationConfigurationWrapper != null ? scriptCompilationConfigurationWrapper.script : null));
    }

    public int hashCode() {
        return this.script.hashCode();
    }

    private static final List dependenciesClassPath_delegate$lambda$0(ScriptCompilationConfigurationWrapper this$0) {
        ScriptCompilationConfiguration scriptCompilationConfiguration = this$0.configuration;
        return JvmClasspathUtilKt.toClassPathOrEmpty(scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptCompilationKt.getDependencies(ScriptCompilationConfiguration.Companion)) : null);
    }

    private static final List dependenciesSources_delegate$lambda$0(ScriptCompilationConfigurationWrapper this$0) {
        ScriptCompilationConfiguration scriptCompilationConfiguration = this$0.configuration;
        return JvmClasspathUtilKt.toClassPathOrEmpty(scriptCompilationConfiguration != null ? scriptCompilationConfiguration.get(ScriptIdeConfigurationKt.getDependenciesSources(ScriptIdeConfigurationKt.getIde(ScriptCompilationConfiguration.Companion))) : null);
    }
}

