/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm;

import java.util.LinkedHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.jvm.JvmIrSerializer;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmGlobalDeclarationTable;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIrSerializerSession;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/JvmIrSerializerImpl;", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrSerializer;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "makeSerializerSession", "Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession;", "serializeIrFile", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "serializeTopLevelIrClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.entrypoint"})
public final class JvmIrSerializerImpl
implements JvmIrSerializer {
    @NotNull
    private final CompilerConfiguration configuration;
    @NotNull
    private final DeclarationTable declarationTable;

    public JvmIrSerializerImpl(@NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.declarationTable = new DeclarationTable(new JvmGlobalDeclarationTable());
    }

    @Override
    @NotNull
    public byte[] serializeIrFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        byte[] byArray = this.makeSerializerSession().serializeJvmIrFile(irFile).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"makeSerializerSession().\u2026ile(irFile).toByteArray()");
        return byArray;
    }

    @Override
    @NotNull
    public byte[] serializeTopLevelIrClass(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        boolean bl = irClass2.getParent() instanceof IrFile;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        byte[] byArray = this.makeSerializerSession().serializeTopLevelClass(irClass2).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"makeSerializerSession().\u2026ss(irClass).toByteArray()");
        return byArray;
    }

    private final JvmIrSerializerSession makeSerializerSession() {
        IrMessageLogger irMessageLogger = this.configuration.get(IrMessageLogger.Companion.getIR_MESSAGE_LOGGER());
        IrMessageLogger irMessageLogger2 = irMessageLogger == null ? (IrMessageLogger)IrMessageLogger.None.INSTANCE : irMessageLogger;
        Intrinsics.checkNotNullExpressionValue((Object)irMessageLogger2, (String)"configuration.get(IrMess\u2026) ?: IrMessageLogger.None");
        return new JvmIrSerializerSession(irMessageLogger2, this.declarationTable, new LinkedHashMap(), false, false, 24, null);
    }
}

