/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.SyntaxTreeBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.ReferenceParser;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public class DeclarationParser {
    private static final TokenSet AFTER_END_DECLARATION_SET = TokenSet.create(JavaElementType.FIELD, JavaElementType.METHOD);
    private static final TokenSet BEFORE_LBRACE_ELEMENTS_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.IMPLEMENTS_KEYWORD, JavaTokenType.LPARENTH);
    private static final TokenSet APPEND_TO_METHOD_SET = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.COMMA, JavaTokenType.THROWS_KEYWORD);
    private static final TokenSet PARAM_LIST_STOPPERS = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.LBRACE, JavaTokenType.ARROW);
    private static final TokenSet TYPE_START = TokenSet.orSet(ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT, JavaTokenType.VAR_KEYWORD));
    private static final TokenSet RESOURCE_EXPRESSIONS = TokenSet.create(JavaElementType.REFERENCE_EXPRESSION, JavaElementType.THIS_EXPRESSION, JavaElementType.METHOD_CALL_EXPRESSION, JavaElementType.NEW_EXPRESSION);
    private final JavaParser myParser;

    public DeclarationParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            DeclarationParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    public void parseClassBodyWithBraces(PsiBuilder builder2, boolean isAnnotation, boolean isEnum) {
        assert (builder2.getTokenType() == JavaTokenType.LBRACE) : builder2.getTokenType();
        builder2.advanceLexer();
        PsiBuilder builderWrapper = JavaParserUtil.braceMatchingBuilder(builder2);
        if (isEnum) {
            this.parseEnumConstants(builderWrapper);
        }
        this.parseClassBodyDeclarations(builderWrapper, isAnnotation);
        JavaParserUtil.expectOrError(builder2, JavaTokenType.RBRACE, "expected.rbrace");
    }

    @Nullable
    private PsiBuilder.Marker parseClassFromKeyword(PsiBuilder builder2, PsiBuilder.Marker declaration2, boolean isAnnotation, Context context2) {
        boolean isEnum;
        IElementType keywordTokenType = builder2.getTokenType();
        boolean isRecord = DeclarationParser.isRecordToken(builder2, keywordTokenType);
        if (isRecord) {
            if (builder2.lookAhead(1) != JavaTokenType.IDENTIFIER) {
                declaration2.drop();
                return null;
            }
            IElementType afterIdent = builder2.lookAhead(2);
            if (context2 == Context.CODE_BLOCK && afterIdent != JavaTokenType.LPARENTH && afterIdent != JavaTokenType.LT) {
                PsiBuilderUtil.advance(builder2, 2);
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lt.or.lparen", new Object[0]));
                declaration2.drop();
                return null;
            }
            builder2.remapCurrentToken(JavaTokenType.RECORD_KEYWORD);
            keywordTokenType = JavaTokenType.RECORD_KEYWORD;
        }
        assert (ElementType.CLASS_KEYWORD_BIT_SET.contains(keywordTokenType)) : keywordTokenType;
        builder2.advanceLexer();
        boolean bl = isEnum = keywordTokenType == JavaTokenType.ENUM_KEYWORD;
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            declaration2.drop();
            return null;
        }
        ReferenceParser refParser = this.myParser.getReferenceParser();
        refParser.parseTypeParameters(builder2);
        if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
            this.parseElementList(builder2, ListType.RECORD_COMPONENTS);
        }
        refParser.parseReferenceList(builder2, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_LIST, JavaTokenType.COMMA);
        refParser.parseReferenceList(builder2, JavaTokenType.IMPLEMENTS_KEYWORD, JavaElementType.IMPLEMENTS_LIST, JavaTokenType.COMMA);
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER && "permits".equals(builder2.getTokenText())) {
            builder2.remapCurrentToken(JavaTokenType.PERMITS_KEYWORD);
        }
        if (builder2.getTokenType() == JavaTokenType.PERMITS_KEYWORD) {
            refParser.parseReferenceList(builder2, JavaTokenType.PERMITS_KEYWORD, JavaElementType.PERMITS_LIST, JavaTokenType.COMMA);
        }
        if (builder2.getTokenType() != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder2.mark();
            while (BEFORE_LBRACE_ELEMENTS_SET.contains(builder2.getTokenType())) {
                builder2.advanceLexer();
            }
            error.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        if (builder2.getTokenType() == JavaTokenType.LBRACE) {
            this.parseClassBodyWithBraces(builder2, isAnnotation, isEnum);
        }
        if (context2 == Context.FILE) {
            boolean declarationsAfterEnd = false;
            while (builder2.getTokenType() != null && builder2.getTokenType() != JavaTokenType.RBRACE) {
                PsiBuilder.Marker position = builder2.mark();
                PsiBuilder.Marker extra = this.parse(builder2, Context.CLASS);
                if (extra != null && AFTER_END_DECLARATION_SET.contains(JavaParserUtil.exprType(extra))) {
                    if (!declarationsAfterEnd) {
                        JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.class.or.interface", new Object[0]), extra);
                    }
                    declarationsAfterEnd = true;
                    position.drop();
                    continue;
                }
                position.rollbackTo();
                break;
            }
            if (declarationsAfterEnd) {
                JavaParserUtil.expectOrError(builder2, JavaTokenType.RBRACE, "expected.rbrace");
            }
        }
        JavaParserUtil.done(declaration2, JavaElementType.CLASS);
        return declaration2;
    }

    private void parseEnumConstants(PsiBuilder builder2) {
        boolean first = true;
        while (builder2.getTokenType() != null) {
            IElementType next;
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON)) {
                return;
            }
            if (builder2.getTokenType() == JavaTokenType.PRIVATE_KEYWORD || builder2.getTokenType() == JavaTokenType.PROTECTED_KEYWORD) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                return;
            }
            PsiBuilder.Marker enumConstant = this.parseEnumConstant(builder2);
            if (enumConstant == null && builder2.getTokenType() == JavaTokenType.COMMA && first && (next = builder2.lookAhead(1)) != JavaTokenType.SEMICOLON && next != JavaTokenType.RBRACE) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            first = false;
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.COMMA) || builder2.getTokenType() == null || builder2.getTokenType() == JavaTokenType.SEMICOLON) continue;
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.comma.or.semicolon", new Object[0]));
            return;
        }
    }

    @Nullable
    public PsiBuilder.Marker parseEnumConstant(PsiBuilder builder2) {
        PsiBuilder.Marker constant = builder2.mark();
        this.parseModifierList(builder2);
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
                this.myParser.getExpressionParser().parseArgumentList(builder2);
            } else {
                JavaParserUtil.emptyElement(builder2, JavaElementType.EXPRESSION_LIST);
            }
            if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                PsiBuilder.Marker constantInit = builder2.mark();
                this.parseClassBodyWithBraces(builder2, false, false);
                JavaParserUtil.done(constantInit, JavaElementType.ENUM_CONSTANT_INITIALIZER);
            }
            JavaParserUtil.done(constant, JavaElementType.ENUM_CONSTANT);
            return constant;
        }
        constant.rollbackTo();
        return null;
    }

    public void parseClassBodyDeclarations(PsiBuilder builder2, boolean isAnnotation) {
        IElementType tokenType;
        Context context2 = isAnnotation ? Context.ANNOTATION_INTERFACE : Context.CLASS;
        SyntaxTreeBuilder.Marker invalidElements = null;
        while ((tokenType = builder2.getTokenType()) != null && tokenType != JavaTokenType.RBRACE) {
            PsiBuilder.Marker ref;
            if (tokenType == JavaTokenType.SEMICOLON) {
                if (invalidElements != null) {
                    invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
                    invalidElements = null;
                }
                builder2.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration2 = this.parse(builder2, context2);
            if (declaration2 != null) {
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), declaration2);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder2.mark();
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, true, false, false)) != null) continue;
            builder2.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder2, Context context2) {
        IElementType tokenType;
        if (builder2 == null) {
            DeclarationParser.$$$reportNull$$$0(1);
        }
        if ((tokenType = builder2.getTokenType()) == null) {
            return null;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            if (context2 == Context.FILE || context2 == Context.CODE_BLOCK) {
                return null;
            }
        } else if (!(DeclarationParser.isRecordToken(builder2, tokenType) || DeclarationParser.isSealedToken(builder2, tokenType) || DeclarationParser.isNonSealedToken(builder2, tokenType))) {
            if (TYPE_START.contains(tokenType) && tokenType != JavaTokenType.AT) {
                if (context2 == Context.FILE) {
                    return null;
                }
            } else {
                if (tokenType instanceof ILazyParseableElementType) {
                    builder2.advanceLexer();
                    return null;
                }
                if (!(ElementType.MODIFIER_BIT_SET.contains(tokenType) || ElementType.CLASS_KEYWORD_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.AT || context2 != Context.CODE_BLOCK && tokenType == JavaTokenType.LT)) {
                    return null;
                }
            }
        }
        PsiBuilder.Marker declaration2 = builder2.mark();
        int declarationStart = builder2.getCurrentOffset();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder2);
        PsiBuilder.Marker modList = (PsiBuilder.Marker)modListInfo.first;
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.AT)) {
            if (builder2.getTokenType() == JavaTokenType.INTERFACE_KEYWORD) {
                PsiBuilder.Marker result2 = this.parseClassFromKeyword(builder2, declaration2, true, context2);
                return result2 != null ? result2 : modList;
            }
            declaration2.rollbackTo();
            return null;
        }
        if (ElementType.CLASS_KEYWORD_BIT_SET.contains(builder2.getTokenType()) || DeclarationParser.isRecordToken(builder2, builder2.getTokenType())) {
            PsiBuilder.Marker result3 = this.parseClassFromKeyword(builder2, declaration2, false, context2);
            return result3 != null ? result3 : modList;
        }
        PsiBuilder.Marker typeParams = null;
        if (builder2.getTokenType() == JavaTokenType.LT && context2 != Context.CODE_BLOCK) {
            typeParams = this.myParser.getReferenceParser().parseTypeParameters(builder2);
        }
        if (context2 == Context.FILE) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.class.or.interface", new Object[0]), typeParams);
            declaration2.drop();
            return modList;
        }
        if (builder2.getTokenType() == JavaTokenType.LBRACE) {
            if (context2 == Context.CODE_BLOCK) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier.or.type", new Object[0]), null);
                declaration2.drop();
                return modList;
            }
            PsiBuilder.Marker codeBlock = this.myParser.getStatementParser().parseCodeBlock(builder2);
            assert (codeBlock != null) : builder2.getOriginalText();
            if (typeParams != null) {
                PsiBuilder.Marker error = typeParams.precede();
                error.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), codeBlock);
            }
            JavaParserUtil.done(declaration2, JavaElementType.CLASS_INITIALIZER);
            return declaration2;
        }
        ReferenceParser.TypeInfo type2 = null;
        if (TYPE_START.contains(builder2.getTokenType())) {
            PsiBuilder.Marker pos = builder2.mark();
            int flags = 5;
            if (context2 == Context.CODE_BLOCK) {
                flags |= 0x80;
            }
            if ((type2 = this.myParser.getReferenceParser().parseTypeInfo(builder2, flags)) == null) {
                pos.rollbackTo();
            } else {
                if (builder2.getTokenType() == JavaTokenType.LPARENTH || builder2.getTokenType() == JavaTokenType.LBRACE) {
                    if (context2 == Context.CODE_BLOCK) {
                        declaration2.rollbackTo();
                        return null;
                    }
                    pos.rollbackTo();
                    if (typeParams == null) {
                        JavaParserUtil.emptyElement(builder2, JavaElementType.TYPE_PARAMETER_LIST);
                    }
                    this.parseAnnotations(builder2);
                    if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
                        PsiBuilder.Marker primitive = builder2.mark();
                        builder2.advanceLexer();
                        primitive.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    if (builder2.getTokenType() == JavaTokenType.LPARENTH) {
                        return this.parseMethodFromLeftParenth(builder2, declaration2, false, true);
                    }
                    if (builder2.getTokenType() == JavaTokenType.LBRACE) {
                        JavaParserUtil.emptyElement(builder2, JavaElementType.THROWS_LIST);
                        return this.parseMethodBody(builder2, declaration2, false);
                    }
                    declaration2.rollbackTo();
                    return null;
                }
                pos.drop();
            }
        }
        if (type2 == null) {
            PsiBuilder.Marker error = typeParams != null ? typeParams.precede() : builder2.mark();
            error.error(JavaPsiBundle.message("expected.identifier.or.type", new Object[0]));
            declaration2.drop();
            return modList;
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            if (context2 != Context.CODE_BLOCK || Boolean.FALSE.equals(modListInfo.second) || type2.isPrimitive && builder2.getTokenType() != JavaTokenType.DOT) {
                if (typeParams != null) {
                    typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type2.marker);
                }
                builder2.error(JavaPsiBundle.message("expected.identifier", new Object[0]));
                declaration2.drop();
                return modList;
            }
            declaration2.rollbackTo();
            return null;
        }
        if (builder2.getTokenType() == JavaTokenType.LPARENTH && (context2 == Context.CLASS || context2 == Context.ANNOTATION_INTERFACE)) {
            if (typeParams == null) {
                JavaParserUtil.emptyElement(type2.marker, JavaElementType.TYPE_PARAMETER_LIST);
            }
            return this.parseMethodFromLeftParenth(builder2, declaration2, context2 == Context.ANNOTATION_INTERFACE, false);
        }
        if (typeParams != null) {
            typeParams.precede().errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), type2.marker);
        }
        return this.parseFieldOrLocalVariable(builder2, declaration2, declarationStart, context2);
    }

    static boolean isRecordToken(PsiBuilder builder2, IElementType tokenType) {
        if (tokenType == JavaTokenType.IDENTIFIER && "record".equals(builder2.getTokenText()) && builder2.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            LanguageLevel level = JavaParserUtil.getLanguageLevel(builder2);
            return level.isAtLeast(LanguageLevel.JDK_14_PREVIEW) && (level == LanguageLevel.JDK_X || level.isPreview());
        }
        return false;
    }

    private static boolean isSealedToken(PsiBuilder builder2, IElementType tokenType) {
        return JavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_15_PREVIEW) && tokenType == JavaTokenType.IDENTIFIER && "sealed".equals(builder2.getTokenText());
    }

    private static boolean isNonSealedToken(PsiBuilder builder2, IElementType tokenType) {
        if (!JavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_15_PREVIEW) || tokenType != JavaTokenType.IDENTIFIER || !"non".equals(builder2.getTokenText()) || builder2.lookAhead(1) != JavaTokenType.MINUS || builder2.lookAhead(2) != JavaTokenType.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker maybeNonSealed = builder2.mark();
        PsiBuilderUtil.advance(builder2, 2);
        boolean isNonSealed = "sealed".equals(builder2.getTokenText());
        maybeNonSealed.rollbackTo();
        return isNonSealed;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder2) {
        Pair<PsiBuilder.Marker, Boolean> pair = this.parseModifierList(builder2, ElementType.MODIFIER_BIT_SET);
        if (pair == null) {
            DeclarationParser.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @NotNull
    public Pair<PsiBuilder.Marker, Boolean> parseModifierList(PsiBuilder builder2, TokenSet modifiers2) {
        IElementType tokenType;
        PsiBuilder.Marker modList = builder2.mark();
        boolean isEmpty2 = true;
        while ((tokenType = builder2.getTokenType()) != null) {
            if (DeclarationParser.isSealedToken(builder2, tokenType)) {
                builder2.remapCurrentToken(JavaTokenType.SEALED_KEYWORD);
                tokenType = JavaTokenType.SEALED_KEYWORD;
            }
            if (DeclarationParser.isNonSealedToken(builder2, tokenType)) {
                PsiBuilder.Marker nonSealed = builder2.mark();
                PsiBuilderUtil.advance(builder2, 3);
                nonSealed.collapse(JavaTokenType.NON_SEALED_KEYWORD);
                isEmpty2 = false;
                continue;
            }
            if (modifiers2.contains(tokenType)) {
                builder2.advanceLexer();
                isEmpty2 = false;
                continue;
            }
            if (tokenType != JavaTokenType.AT || ElementType.KEYWORD_BIT_SET.contains(builder2.lookAhead(1))) break;
            this.parseAnnotation(builder2);
            isEmpty2 = false;
        }
        JavaParserUtil.done(modList, JavaElementType.MODIFIER_LIST);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(modList, isEmpty2);
        if (pair == null) {
            DeclarationParser.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private PsiBuilder.Marker parseMethodFromLeftParenth(PsiBuilder builder2, PsiBuilder.Marker declaration2, boolean anno, boolean constructor2) {
        this.parseParameterList(builder2);
        this.eatBrackets(builder2, constructor2 ? "expected.semicolon" : null);
        this.myParser.getReferenceParser().parseReferenceList(builder2, JavaTokenType.THROWS_KEYWORD, JavaElementType.THROWS_LIST, JavaTokenType.COMMA);
        if (anno && PsiBuilderUtil.expect(builder2, JavaTokenType.DEFAULT_KEYWORD)) {
            this.parseAnnotationValue(builder2);
        }
        return this.parseMethodBody(builder2, declaration2, anno);
    }

    @NotNull
    private PsiBuilder.Marker parseMethodBody(PsiBuilder builder2, PsiBuilder.Marker declaration2, boolean anno) {
        IElementType tokenType = builder2.getTokenType();
        if (tokenType != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE) {
            PsiBuilder.Marker error = builder2.mark();
            CharSequence text2 = builder2.getOriginalText();
            block0: do {
                for (int i = builder2.getCurrentOffset() - 1; i >= 0; --i) {
                    char ch = text2.charAt(i);
                    if (ch == '\n') break block0;
                    if (ch != ' ' && ch != '\t') continue block0;
                }
            } while (PsiBuilderUtil.expect(builder2, APPEND_TO_METHOD_SET));
            error.error(JavaPsiBundle.message("expected.lbrace.or.semicolon", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON) && builder2.getTokenType() == JavaTokenType.LBRACE) {
            this.myParser.getStatementParser().parseCodeBlock(builder2);
        }
        JavaParserUtil.done(declaration2, anno ? JavaElementType.ANNOTATION_METHOD : JavaElementType.METHOD);
        PsiBuilder.Marker marker = declaration2;
        if (marker == null) {
            DeclarationParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    public void parseParameterList(PsiBuilder builder2) {
        this.parseElementList(builder2, ListType.METHOD);
    }

    public void parseResourceList(PsiBuilder builder2) {
        this.parseElementList(builder2, ListType.RESOURCE);
    }

    public void parseLambdaParameterList(PsiBuilder builder2, boolean typed) {
        this.parseElementList(builder2, typed ? ListType.LAMBDA_TYPED : ListType.LAMBDA_UNTYPED);
    }

    private void parseElementList(PsiBuilder builder2, ListType type2) {
        boolean lambda2 = type2 == ListType.LAMBDA_TYPED || type2 == ListType.LAMBDA_UNTYPED;
        boolean resources = type2 == ListType.RESOURCE;
        PsiBuilder.Marker elementList = builder2.mark();
        boolean leftParenth = PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH);
        assert (lambda2 || leftParenth) : builder2.getTokenType();
        IElementType delimiter = resources ? JavaTokenType.SEMICOLON : JavaTokenType.COMMA;
        String noDelimiterMsg = resources ? "expected.semicolon" : "expected.comma";
        String noElementMsg = resources ? "expected.resource" : "expected.parameter";
        SyntaxTreeBuilder.Marker invalidElements = null;
        String errorMessage2 = null;
        boolean delimiterExpected = false;
        boolean noElements = true;
        while (true) {
            PsiBuilder.Marker ref;
            IElementType tokenType;
            if ((tokenType = builder2.getTokenType()) == null || PARAM_LIST_STOPPERS.contains(tokenType)) {
                boolean noLastElement;
                boolean bl = noLastElement = !delimiterExpected && (!noElements && !resources || noElements && resources);
                if (noLastElement) {
                    String key = lambda2 ? "expected.parameter" : "expected.identifier.or.type";
                    JavaParserUtil.error(builder2, JavaPsiBundle.message(key, new Object[0]));
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage2);
                        invalidElements = null;
                    }
                    builder2.advanceLexer();
                    break;
                }
                if (noLastElement && !resources) break;
                if (invalidElements != null) {
                    invalidElements.error(errorMessage2);
                }
                invalidElements = null;
                if (!leftParenth) break;
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rparen", new Object[0]));
                break;
            }
            if (delimiterExpected) {
                if (builder2.getTokenType() == delimiter) {
                    delimiterExpected = false;
                    if (invalidElements != null) {
                        invalidElements.error(errorMessage2);
                        invalidElements = null;
                    }
                    builder2.advanceLexer();
                    continue;
                }
            } else {
                PsiBuilder.Marker listElement;
                PsiBuilder.Marker marker = type2 == ListType.RECORD_COMPONENTS ? this.parseParameterOrRecordComponent(builder2, true, false, false, false) : (resources ? this.parseResource(builder2) : (lambda2 ? this.parseLambdaParameter(builder2, type2 == ListType.LAMBDA_TYPED) : (listElement = this.parseParameter(builder2, true, false, false))));
                if (listElement != null) {
                    delimiterExpected = true;
                    if (invalidElements != null) {
                        invalidElements.errorBefore(errorMessage2, listElement);
                        invalidElements = null;
                    }
                    noElements = false;
                    continue;
                }
            }
            if (invalidElements == null) {
                if (builder2.getTokenType() == delimiter) {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message(noElementMsg, new Object[0]));
                    builder2.advanceLexer();
                    if (!noElements || !resources) continue;
                    noElements = false;
                    continue;
                }
                invalidElements = builder2.mark();
                errorMessage2 = JavaPsiBundle.message(delimiterExpected ? noDelimiterMsg : noElementMsg, new Object[0]);
            }
            if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, true, false, false)) != null || builder2.getTokenType() == null) continue;
            builder2.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.error(errorMessage2);
        }
        JavaParserUtil.done(elementList, type2.getNodeType());
    }

    @Nullable
    public PsiBuilder.Marker parseParameter(PsiBuilder builder2, boolean ellipsis, boolean disjunctiveType, boolean varType) {
        return this.parseParameterOrRecordComponent(builder2, ellipsis, disjunctiveType, varType, true);
    }

    @Nullable
    public PsiBuilder.Marker parseParameterOrRecordComponent(PsiBuilder builder2, boolean ellipsis, boolean disjunctiveType, boolean varType, boolean isParameter) {
        int typeFlags = 0;
        if (ellipsis) {
            typeFlags |= 2;
        }
        if (disjunctiveType) {
            typeFlags |= 0x10;
        }
        if (varType) {
            typeFlags |= 0x80;
        }
        return this.parseListElement(builder2, true, typeFlags, isParameter ? JavaElementType.PARAMETER : JavaElementType.RECORD_COMPONENT);
    }

    @Nullable
    public PsiBuilder.Marker parseResource(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
        if (expr != null && RESOURCE_EXPRESSIONS.contains(JavaParserUtil.exprType(expr)) && builder2.getTokenType() != JavaTokenType.IDENTIFIER) {
            marker.done(JavaElementType.RESOURCE_EXPRESSION);
            return marker;
        }
        marker.rollbackTo();
        return this.parseListElement(builder2, true, 128, JavaElementType.RESOURCE_VARIABLE);
    }

    @Nullable
    public PsiBuilder.Marker parseLambdaParameter(PsiBuilder builder2, boolean typed) {
        int flags = 2;
        if (JavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_11)) {
            flags |= 0x80;
        }
        return this.parseListElement(builder2, typed, flags, JavaElementType.PARAMETER);
    }

    @Nullable
    private PsiBuilder.Marker parseListElement(PsiBuilder builder2, boolean typed, int typeFlags, IElementType type2) {
        IElementType tokenType;
        PsiBuilder.Marker param = builder2.mark();
        Pair<PsiBuilder.Marker, Boolean> modListInfo = this.parseModifierList(builder2);
        ReferenceParser.TypeInfo typeInfo = null;
        if (typed) {
            int flags = 5 | typeFlags;
            typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder2, flags);
            if (typeInfo == null) {
                if (Boolean.TRUE.equals(modListInfo.second)) {
                    param.rollbackTo();
                    return null;
                }
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.type", new Object[0]));
                JavaParserUtil.emptyElement(builder2, JavaElementType.TYPE);
            }
        }
        if (typed && ((tokenType = builder2.getTokenType()) == JavaTokenType.THIS_KEYWORD || tokenType == JavaTokenType.IDENTIFIER && builder2.lookAhead(1) == JavaTokenType.DOT)) {
            PsiBuilder.Marker mark = builder2.mark();
            PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
            if (expr != null && JavaParserUtil.exprType(expr) == JavaElementType.THIS_EXPRESSION) {
                mark.drop();
                JavaParserUtil.done(param, JavaElementType.RECEIVER_PARAMETER);
                return param;
            }
            mark.rollbackTo();
        }
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            if (type2 == JavaElementType.PARAMETER || type2 == JavaElementType.RECORD_COMPONENT) {
                this.eatBrackets(builder2, typeInfo != null && typeInfo.isVarArg ? "expected.rparen" : null);
                JavaParserUtil.done(param, type2);
                return param;
            }
        } else {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            param.drop();
            return (PsiBuilder.Marker)modListInfo.first;
        }
        if (JavaParserUtil.expectOrError(builder2, JavaTokenType.EQ, "expected.eq") && this.myParser.getExpressionParser().parse(builder2) == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        JavaParserUtil.done(param, JavaElementType.RESOURCE_VARIABLE);
        return param;
    }

    @Nullable
    private PsiBuilder.Marker parseFieldOrLocalVariable(PsiBuilder builder2, PsiBuilder.Marker declaration2, int declarationStart, Context context2) {
        boolean shouldRollback;
        IElementType varType;
        if (context2 == Context.CLASS || context2 == Context.ANNOTATION_INTERFACE) {
            varType = JavaElementType.FIELD;
        } else if (context2 == Context.CODE_BLOCK) {
            varType = JavaElementType.LOCAL_VARIABLE;
        } else {
            declaration2.drop();
            assert (false) : "Unexpected context: " + (Object)((Object)context2);
            return null;
        }
        PsiBuilder.Marker variable2 = declaration2;
        boolean unclosed = false;
        boolean eatSemicolon = true;
        boolean openMarker = true;
        while (true) {
            shouldRollback = true;
            if (!this.eatBrackets(builder2, null)) {
                unclosed = true;
            }
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.EQ)) {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder2);
                if (expr != null) {
                    shouldRollback = false;
                } else {
                    JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.expression", new Object[0]));
                    unclosed = true;
                    break;
                }
            }
            if (builder2.getTokenType() != JavaTokenType.COMMA) break;
            JavaParserUtil.done(variable2, varType);
            builder2.advanceLexer();
            if (builder2.getTokenType() != JavaTokenType.IDENTIFIER) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                unclosed = true;
                eatSemicolon = false;
                openMarker = false;
                break;
            }
            variable2 = builder2.mark();
            builder2.advanceLexer();
        }
        if (builder2.getTokenType() == JavaTokenType.SEMICOLON && eatSemicolon) {
            builder2.advanceLexer();
        } else {
            if (!builder2.eof() && shouldRollback) {
                CharSequence text2 = builder2.getOriginalText();
                int spaceEnd = builder2.getCurrentOffset();
                int spaceStart = CharArrayUtil.shiftBackward(text2, spaceEnd - 1, "\n\r \t");
                int lineStart = CharArrayUtil.shiftBackwardUntil(text2, spaceEnd, "\n\r");
                if (declarationStart < lineStart && lineStart < spaceStart) {
                    int newBufferEnd = CharArrayUtil.shiftForward(text2, lineStart, "\n\r \t");
                    declaration2.rollbackTo();
                    return this.parse(JavaParserUtil.stoppingBuilder(builder2, newBufferEnd), context2);
                }
            }
            if (!unclosed) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.semicolon", new Object[0]));
            }
        }
        if (openMarker) {
            JavaParserUtil.done(variable2, varType);
        }
        return declaration2;
    }

    private boolean eatBrackets(PsiBuilder builder2, @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") @Nullable @PropertyKey(resourceBundle="messages.JavaPsiBundle") String errorKey) {
        boolean paired;
        IElementType tokenType = builder2.getTokenType();
        if (tokenType != JavaTokenType.LBRACKET && tokenType != JavaTokenType.AT) {
            return true;
        }
        PsiBuilder.Marker marker = builder2.mark();
        int count = 0;
        while (true) {
            this.parseAnnotations(builder2);
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LBRACKET)) break;
            ++count;
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RBRACKET)) break;
            ++count;
        }
        if (count == 0) {
            marker.rollbackTo();
            return true;
        }
        if (errorKey != null) {
            marker.error(JavaPsiBundle.message(errorKey, new Object[0]));
        } else {
            marker.drop();
        }
        boolean bl = paired = count % 2 == 0;
        if (!paired) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rbracket", new Object[0]));
        }
        return paired;
    }

    @Nullable
    public PsiBuilder.Marker parseAnnotations(PsiBuilder builder2) {
        PsiBuilder.Marker firstAnno = null;
        while (builder2.getTokenType() == JavaTokenType.AT) {
            PsiBuilder.Marker anno = this.parseAnnotation(builder2);
            if (firstAnno != null) continue;
            firstAnno = anno;
        }
        return firstAnno;
    }

    @NotNull
    public PsiBuilder.Marker parseAnnotation(PsiBuilder builder2) {
        assert (builder2.getTokenType() == JavaTokenType.AT) : builder2.getTokenType();
        PsiBuilder.Marker anno = builder2.mark();
        builder2.advanceLexer();
        PsiBuilder.Marker classRef = null;
        if (builder2.getTokenType() == JavaTokenType.IDENTIFIER) {
            classRef = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, false, false, false);
        }
        if (classRef == null) {
            JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.class.reference", new Object[0]));
        }
        this.parseAnnotationParameterList(builder2);
        JavaParserUtil.done(anno, JavaElementType.ANNOTATION);
        PsiBuilder.Marker marker = anno;
        if (marker == null) {
            DeclarationParser.$$$reportNull$$$0(5);
        }
        return marker;
    }

    private void parseAnnotationParameterList(PsiBuilder builder2) {
        PsiBuilder.Marker list2 = builder2.mark();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LPARENTH)) {
            JavaParserUtil.done(list2, JavaElementType.ANNOTATION_PARAMETER_LIST);
            return;
        }
        if (PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) {
            JavaParserUtil.done(list2, JavaElementType.ANNOTATION_PARAMETER_LIST);
            return;
        }
        boolean isFirstParamNamed = this.parseAnnotationParameter(builder2, true);
        boolean isFirstParamWarned = false;
        boolean afterBad = false;
        while (true) {
            IElementType tokenType;
            if ((tokenType = builder2.getTokenType()) == null) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.parameter", new Object[0]));
                break;
            }
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.RPARENTH)) break;
            if (tokenType == JavaTokenType.COMMA) {
                PsiBuilder.Marker errorStart = builder2.mark();
                PsiBuilder.Marker errorEnd = builder2.mark();
                builder2.advanceLexer();
                boolean hasParamName = this.parseAnnotationParameter(builder2, false);
                if (!isFirstParamNamed && hasParamName && !isFirstParamWarned) {
                    errorStart.errorBefore(JavaPsiBundle.message("annotation.name.is.missing", new Object[0]), errorEnd);
                    isFirstParamWarned = true;
                } else {
                    errorStart.drop();
                }
                errorEnd.drop();
                continue;
            }
            if (!afterBad) {
                JavaParserUtil.error(builder2, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
                builder2.advanceLexer();
                afterBad = true;
                continue;
            }
            afterBad = false;
            this.parseAnnotationParameter(builder2, false);
        }
        JavaParserUtil.done(list2, JavaElementType.ANNOTATION_PARAMETER_LIST);
    }

    private boolean parseAnnotationParameter(PsiBuilder builder2, boolean mayBeSimple) {
        PsiBuilder.Marker pair = builder2.mark();
        if (mayBeSimple) {
            this.parseAnnotationValue(builder2);
            if (builder2.getTokenType() != JavaTokenType.EQ) {
                JavaParserUtil.done(pair, JavaElementType.NAME_VALUE_PAIR);
                return false;
            }
            pair.rollbackTo();
            pair = builder2.mark();
        }
        boolean hasName = JavaParserUtil.expectOrError(builder2, JavaTokenType.IDENTIFIER, "expected.identifier");
        JavaParserUtil.expectOrError(builder2, JavaTokenType.EQ, "expected.eq");
        this.parseAnnotationValue(builder2);
        JavaParserUtil.done(pair, JavaElementType.NAME_VALUE_PAIR);
        return hasName;
    }

    public void parseAnnotationValue(PsiBuilder builder2) {
        PsiBuilder.Marker result2 = this.doParseAnnotationValue(builder2);
        if (result2 == null) {
            result2 = builder2.mark();
            result2.error(JavaPsiBundle.message("expected.value", new Object[0]));
        }
    }

    @Nullable
    private PsiBuilder.Marker doParseAnnotationValue(PsiBuilder builder2) {
        IElementType tokenType = builder2.getTokenType();
        PsiBuilder.Marker result2 = tokenType == JavaTokenType.AT ? this.parseAnnotation(builder2) : (tokenType == JavaTokenType.LBRACE ? this.myParser.getExpressionParser().parseArrayInitializer(builder2, JavaElementType.ANNOTATION_ARRAY_INITIALIZER, this::doParseAnnotationValue, "expected.value") : this.myParser.getExpressionParser().parseConditional(builder2));
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/DeclarationParser";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseModifierList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodBody";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ListType {
        METHOD,
        RESOURCE,
        LAMBDA_TYPED,
        LAMBDA_UNTYPED,
        RECORD_COMPONENTS;


        IElementType getNodeType() {
            if (this == RESOURCE) {
                return JavaElementType.RESOURCE_LIST;
            }
            if (this == RECORD_COMPONENTS) {
                return JavaElementType.RECORD_HEADER;
            }
            return JavaElementType.PARAMETER_LIST;
        }
    }

    public static enum Context {
        FILE,
        CLASS,
        CODE_BLOCK,
        ANNOTATION_INTERFACE;

    }
}

