/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.ObjectTree;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ThrowableInterner;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

final class ObjectNode {
    private final ObjectTree myTree;
    ObjectNode myParent;
    private final Disposable myObject;
    private List<ObjectNode> myChildren;
    private Throwable myTrace;

    ObjectNode(@NotNull ObjectTree tree, @Nullable ObjectNode parentNode, @NotNull Disposable object) {
        if (tree == null) {
            ObjectNode.$$$reportNull$$$0(0);
        }
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(1);
        }
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
        this.myTrace = parentNode == null && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    void addChild(@NotNull ObjectNode child) {
        List<ObjectNode> children;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(2);
        }
        if ((children = this.myChildren) == null) {
            this.myChildren = new SmartList<ObjectNode>(child);
        } else {
            children.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode child) {
        List<ObjectNode> children;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(3);
        }
        if ((children = this.myChildren) != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                ObjectNode node = children.get(i);
                if (!node.equals(child)) continue;
                children.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    ObjectNode getParent() {
        return this.myParent;
    }

    void getAndRemoveRecursively(@NotNull List<? super Disposable> result2) {
        if (result2 == null) {
            ObjectNode.$$$reportNull$$$0(4);
        }
        this.getAndRemoveChildrenRecursively(result2, null);
        this.myTree.removeObjectFromTree(this);
        if (this.myTree.rememberDisposedTrace(this.myObject) == null) {
            result2.add(this.myObject);
        }
        this.myChildren = null;
        this.myParent = null;
    }

    void getAndRemoveChildrenRecursively(@NotNull List<? super Disposable> result2, @Nullable Predicate<? super Disposable> predicate) {
        if (result2 == null) {
            ObjectNode.$$$reportNull$$$0(5);
        }
        if (this.myChildren != null) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                ObjectNode childNode = this.myChildren.get(i);
                if (predicate != null && !predicate.test(childNode.getObject())) continue;
                childNode.getAndRemoveRecursively(result2);
            }
        }
    }

    @NotNull
    Disposable getObject() {
        Disposable disposable = this.myObject;
        if (disposable == null) {
            ObjectNode.$$$reportNull$$$0(6);
        }
        return disposable;
    }

    @NonNls
    public String toString() {
        return "Node: " + this.myObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAndRemoveRecursively";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAndRemoveChildrenRecursively";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferencesKept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findChildEqualTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

