/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.kotlin.com.intellij.openapi.util.NullableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;

@ApiStatus.NonExtendable
public abstract class AtomicNullableLazyValue<T>
extends NullableLazyValue<T> {
    private volatile T myValue;
    private volatile boolean myComputed;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected AtomicNullableLazyValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T getValue() {
        boolean computed = this.myComputed;
        T value2 = this.myValue;
        if (computed) {
            return value2;
        }
        AtomicNullableLazyValue atomicNullableLazyValue = this;
        synchronized (atomicNullableLazyValue) {
            computed = this.myComputed;
            value2 = this.myValue;
            if (!computed) {
                RecursionGuard.StackStamp stamp = RecursionManager.markStack();
                value2 = this.compute();
                if (stamp.mayCacheNow()) {
                    this.myValue = value2;
                    this.myComputed = true;
                }
            }
        }
        return value2;
    }
}

