/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

package org.jetbrains.kotlin.fir.declarations

import org.jetbrains.kotlin.KtSourceElement
import org.jetbrains.kotlin.fir.FirElement
import org.jetbrains.kotlin.fir.FirModuleData
import org.jetbrains.kotlin.fir.contracts.FirContractDescription
import org.jetbrains.kotlin.fir.expressions.FirAnnotation
import org.jetbrains.kotlin.fir.expressions.FirBlock
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType
import org.jetbrains.kotlin.fir.types.FirTypeRef
import org.jetbrains.kotlin.fir.visitors.FirTransformer
import org.jetbrains.kotlin.fir.visitors.FirVisitor
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource

/**
 * Represents a property accessor declaration — either a getter or a setter — in FIR.
 * Exactly one of [isGetter] or [isSetter] is true for a given accessor.
 *
 * Notable properties:
 * - [symbol] — the symbol which serves as a pointer to this accessor.
 * - [propertySymbol] — the symbol of the property this accessor belongs to.
 * - [isGetter] — whether this accessor is a getter.
 * - [isSetter] — whether this accessor is a setter.
 * - [typeParameters] — type parameters declared for the accessor (normally empty, but so-called synthetic property accessors can have them).
 * - [valueParameters] — value parameters of the accessor (for a setter, normally contains a single parameter representing the value being set; empty for a getter).
 * - [dispatchReceiverType] — always null for property accessors. 
 * - [receiverParameter] — the extension receiver parameter if the containing property is an extension, otherwise null.
 * - [returnTypeRef] — the return type of the accessor (normally it's the property type for a getter, and [kotlin.Unit] for a setter).
 * - [contextParameters] — context parameters of the accessor, if any.
 * - [body] — the body of the accessor, if present, otherwise null.
 * - [contractDescription] — contract description for the accessor, if present (see [FirContractDescription] and its inheritors).
 * - [annotations] — annotations present on the accessor, if any.
 * - [isLocal] — the property accessor is considered local iff its owner property is local.
 *
 * Generated from: [org.jetbrains.kotlin.fir.tree.generator.FirTree.propertyAccessor]
 */
abstract class FirPropertyAccessor : FirFunction(), FirContractDescriptionOwner, FirTypeParametersOwner {
    abstract override val source: KtSourceElement?
    abstract override val moduleData: FirModuleData
    abstract override val origin: FirDeclarationOrigin
    abstract override val attributes: FirDeclarationAttributes
    abstract override val status: FirDeclarationStatus
    abstract override val isLocal: Boolean
    abstract override val returnTypeRef: FirTypeRef
    abstract override val receiverParameter: FirReceiverParameter?
    abstract override val deprecationsProvider: DeprecationsProvider
    abstract override val containerSource: DeserializedContainerSource?
    abstract override val dispatchReceiverType: ConeSimpleKotlinType?
    abstract override val contextParameters: List<FirValueParameter>
    abstract override val controlFlowGraphReference: FirControlFlowGraphReference?
    abstract override val valueParameters: List<FirValueParameter>
    abstract override val body: FirBlock?
    abstract override val contractDescription: FirContractDescription?
    abstract override val symbol: FirPropertyAccessorSymbol
    abstract val propertySymbol: FirPropertySymbol
    abstract val isGetter: Boolean
    abstract val isSetter: Boolean
    abstract override val annotations: List<FirAnnotation>
    abstract override val typeParameters: List<FirTypeParameter>

    override fun <R, D> accept(visitor: FirVisitor<R, D>, data: D): R =
        visitor.visitPropertyAccessor(this, data)

    @Suppress("UNCHECKED_CAST")
    override fun <E : FirElement, D> transform(transformer: FirTransformer<D>, data: D): E =
        transformer.transformPropertyAccessor(this, data) as E

    abstract override fun replaceStatus(newStatus: FirDeclarationStatus)

    abstract override fun replaceReturnTypeRef(newReturnTypeRef: FirTypeRef)

    abstract override fun replaceReceiverParameter(newReceiverParameter: FirReceiverParameter?)

    abstract override fun replaceDeprecationsProvider(newDeprecationsProvider: DeprecationsProvider)

    abstract override fun replaceContextParameters(newContextParameters: List<FirValueParameter>)

    abstract override fun replaceControlFlowGraphReference(newControlFlowGraphReference: FirControlFlowGraphReference?)

    abstract override fun replaceValueParameters(newValueParameters: List<FirValueParameter>)

    abstract override fun replaceBody(newBody: FirBlock?)

    abstract override fun replaceContractDescription(newContractDescription: FirContractDescription?)

    abstract override fun replaceAnnotations(newAnnotations: List<FirAnnotation>)

    abstract override fun <D> transformStatus(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformReturnTypeRef(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformReceiverParameter(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformContextParameters(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformValueParameters(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformBody(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformContractDescription(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformAnnotations(transformer: FirTransformer<D>, data: D): FirPropertyAccessor

    abstract override fun <D> transformTypeParameters(transformer: FirTransformer<D>, data: D): FirPropertyAccessor
}
