/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.fir.symbols.impl

import org.jetbrains.kotlin.fir.declarations.FirReplSnippet
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol

class FirReplSnippetSymbol(val snippetClassSymbol: FirRegularClassSymbol) : FirBasedSymbol<FirReplSnippet>() {
    override fun toString(): String = "${this::class.simpleName} ${snippetClassSymbol.name.asString()}"
}
