/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/ir/ir.tree/tree-generator/ReadMe.md.
// DO NOT MODIFY IT MANUALLY.

package org.jetbrains.kotlin.ir.visitors

import org.jetbrains.kotlin.ir.IrElement
import org.jetbrains.kotlin.ir.declarations.*
import org.jetbrains.kotlin.ir.expressions.*
import org.jetbrains.kotlin.ir.types.IrSimpleType
import org.jetbrains.kotlin.ir.types.IrType
import org.jetbrains.kotlin.ir.types.IrTypeProjection

/**
 * Auto-generated by [org.jetbrains.kotlin.ir.generator.print.TypeVisitorVoidPrinter]
 */
abstract class IrTypeVisitorVoid : IrTypeVisitor<Unit, Nothing?>() {
    /**
     * A customization point called by [visitTypeRecursively] on each field of [container] that contains
     * an [IrType], as well as on all the latter's type arguments (for [IrSimpleType]s).
     */
    abstract fun visitType(container: IrElement, type: IrType)

    final override fun visitType(container: IrElement, type: IrType, data: Nothing?) {
        visitType(container, type)
    }

    /**
     * Called on each field of [container] that contains an [IrType].
     * The default implementation calls [visitType] for [type] and each of its type arguments
     * (for [IrSimpleType]s).
     */
    open fun visitTypeRecursively(container: IrElement, type: IrType) {
        visitType(container, type)
        type.annotations.forEach { visitAnnotationUsage(it) }
        if (type is IrSimpleType) {
            type.arguments.forEach {
                if (it is IrTypeProjection) {
                    visitTypeRecursively(container, it.type)
                }
            }
        }
    }

    final override fun visitTypeRecursively(container: IrElement, type: IrType, data: Nothing?) {
        visitTypeRecursively(container, type)
    }

    open fun visitAnnotationUsage(annotationUsage: IrConstructorCall) {
        visitElement(annotationUsage)
        visitTypeRecursively(annotationUsage, annotationUsage.type)
    }

    final override fun visitAnnotationUsage(annotationUsage: IrConstructorCall, data: Nothing?) {
        visitAnnotationUsage(annotationUsage)
    }

    final override fun visitElement(element: IrElement, data: Nothing?) {
        visitElement(element)
    }

    open fun visitElement(element: IrElement) {
        element.acceptChildrenVoid(this)
    }

    final override fun visitDeclaration(declaration: IrDeclarationBase, data: Nothing?) {
        visitDeclaration(declaration)
    }

    open fun visitDeclaration(declaration: IrDeclarationBase) {
        declaration.annotations.forEach { visitAnnotationUsage(it) }
        visitElement(declaration)
    }

    final override fun visitValueParameter(declaration: IrValueParameter, data: Nothing?) {
        visitValueParameter(declaration)
    }

    open fun visitValueParameter(declaration: IrValueParameter) {
        declaration.varargElementType?.let { visitTypeRecursively(declaration, it) }
        visitTypeRecursively(declaration, declaration.type)
        visitDeclaration(declaration)
    }

    final override fun visitClass(declaration: IrClass, data: Nothing?) {
        visitClass(declaration)
    }

    open fun visitClass(declaration: IrClass) {
        declaration.valueClassRepresentation?.mapUnderlyingType {
            visitTypeRecursively(declaration, it)
            it
        }
        declaration.superTypes.forEach { visitTypeRecursively(declaration, it) }
        visitDeclaration(declaration)
    }

    final override fun visitAnonymousInitializer(declaration: IrAnonymousInitializer, data: Nothing?) {
        visitAnonymousInitializer(declaration)
    }

    open fun visitAnonymousInitializer(declaration: IrAnonymousInitializer) {
        visitDeclaration(declaration)
    }

    final override fun visitTypeParameter(declaration: IrTypeParameter, data: Nothing?) {
        visitTypeParameter(declaration)
    }

    open fun visitTypeParameter(declaration: IrTypeParameter) {
        declaration.superTypes.forEach { visitTypeRecursively(declaration, it) }
        visitDeclaration(declaration)
    }

    final override fun visitFunction(declaration: IrFunction, data: Nothing?) {
        visitFunction(declaration)
    }

    open fun visitFunction(declaration: IrFunction) {
        visitTypeRecursively(declaration, declaration.returnType)
        visitDeclaration(declaration)
    }

    final override fun visitConstructor(declaration: IrConstructor, data: Nothing?) {
        visitConstructor(declaration)
    }

    open fun visitConstructor(declaration: IrConstructor) {
        visitFunction(declaration)
    }

    final override fun visitEnumEntry(declaration: IrEnumEntry, data: Nothing?) {
        visitEnumEntry(declaration)
    }

    open fun visitEnumEntry(declaration: IrEnumEntry) {
        visitDeclaration(declaration)
    }

    final override fun visitField(declaration: IrField, data: Nothing?) {
        visitField(declaration)
    }

    open fun visitField(declaration: IrField) {
        visitTypeRecursively(declaration, declaration.type)
        visitDeclaration(declaration)
    }

    final override fun visitLocalDelegatedProperty(declaration: IrLocalDelegatedProperty, data: Nothing?) {
        visitLocalDelegatedProperty(declaration)
    }

    open fun visitLocalDelegatedProperty(declaration: IrLocalDelegatedProperty) {
        visitTypeRecursively(declaration, declaration.type)
        visitDeclaration(declaration)
    }

    final override fun visitModuleFragment(declaration: IrModuleFragment, data: Nothing?) {
        visitModuleFragment(declaration)
    }

    open fun visitModuleFragment(declaration: IrModuleFragment) {
        visitElement(declaration)
    }

    final override fun visitProperty(declaration: IrProperty, data: Nothing?) {
        visitProperty(declaration)
    }

    open fun visitProperty(declaration: IrProperty) {
        visitDeclaration(declaration)
    }

    final override fun visitScript(declaration: IrScript, data: Nothing?) {
        visitScript(declaration)
    }

    open fun visitScript(declaration: IrScript) {
        declaration.baseClass?.let { visitTypeRecursively(declaration, it) }
        visitDeclaration(declaration)
    }

    final override fun visitReplSnippet(declaration: IrReplSnippet, data: Nothing?) {
        visitReplSnippet(declaration)
    }

    open fun visitReplSnippet(declaration: IrReplSnippet) {
        visitDeclaration(declaration)
    }

    final override fun visitSimpleFunction(declaration: IrSimpleFunction, data: Nothing?) {
        visitSimpleFunction(declaration)
    }

    open fun visitSimpleFunction(declaration: IrSimpleFunction) {
        visitFunction(declaration)
    }

    final override fun visitTypeAlias(declaration: IrTypeAlias, data: Nothing?) {
        visitTypeAlias(declaration)
    }

    open fun visitTypeAlias(declaration: IrTypeAlias) {
        visitTypeRecursively(declaration, declaration.expandedType)
        visitDeclaration(declaration)
    }

    final override fun visitVariable(declaration: IrVariable, data: Nothing?) {
        visitVariable(declaration)
    }

    open fun visitVariable(declaration: IrVariable) {
        visitTypeRecursively(declaration, declaration.type)
        visitDeclaration(declaration)
    }

    final override fun visitPackageFragment(declaration: IrPackageFragment, data: Nothing?) {
        visitPackageFragment(declaration)
    }

    open fun visitPackageFragment(declaration: IrPackageFragment) {
        visitElement(declaration)
    }

    final override fun visitExternalPackageFragment(declaration: IrExternalPackageFragment, data: Nothing?) {
        visitExternalPackageFragment(declaration)
    }

    open fun visitExternalPackageFragment(declaration: IrExternalPackageFragment) {
        visitPackageFragment(declaration)
    }

    final override fun visitFile(declaration: IrFile, data: Nothing?) {
        visitFile(declaration)
    }

    open fun visitFile(declaration: IrFile) {
        declaration.annotations.forEach { visitAnnotationUsage(it) }
        visitPackageFragment(declaration)
    }

    final override fun visitExpression(expression: IrExpression, data: Nothing?) {
        visitExpression(expression)
    }

    open fun visitExpression(expression: IrExpression) {
        visitTypeRecursively(expression, expression.type)
        visitElement(expression)
    }

    final override fun visitBody(body: IrBody, data: Nothing?) {
        visitBody(body)
    }

    open fun visitBody(body: IrBody) {
        visitElement(body)
    }

    final override fun visitExpressionBody(body: IrExpressionBody, data: Nothing?) {
        visitExpressionBody(body)
    }

    open fun visitExpressionBody(body: IrExpressionBody) {
        visitBody(body)
    }

    final override fun visitBlockBody(body: IrBlockBody, data: Nothing?) {
        visitBlockBody(body)
    }

    open fun visitBlockBody(body: IrBlockBody) {
        visitBody(body)
    }

    final override fun visitDeclarationReference(expression: IrDeclarationReference, data: Nothing?) {
        visitDeclarationReference(expression)
    }

    open fun visitDeclarationReference(expression: IrDeclarationReference) {
        visitExpression(expression)
    }

    final override fun visitMemberAccess(expression: IrMemberAccessExpression<*>, data: Nothing?) {
        visitMemberAccess(expression)
    }

    open fun visitMemberAccess(expression: IrMemberAccessExpression<*>) {
        for (type in expression.typeArguments) {
            if (type != null) {
                visitTypeRecursively(expression, type)
            }
        }
        visitDeclarationReference(expression)
    }

    final override fun visitFunctionAccess(expression: IrFunctionAccessExpression, data: Nothing?) {
        visitFunctionAccess(expression)
    }

    open fun visitFunctionAccess(expression: IrFunctionAccessExpression) {
        visitMemberAccess(expression)
    }

    final override fun visitConstructorCall(expression: IrConstructorCall, data: Nothing?) {
        visitConstructorCall(expression)
    }

    open fun visitConstructorCall(expression: IrConstructorCall) {
        visitFunctionAccess(expression)
    }

    final override fun visitAnnotation(expression: IrAnnotation, data: Nothing?) {
        visitAnnotation(expression)
    }

    open fun visitAnnotation(expression: IrAnnotation) {
        visitConstructorCall(expression)
    }

    final override fun visitSingletonReference(expression: IrGetSingletonValue, data: Nothing?) {
        visitSingletonReference(expression)
    }

    open fun visitSingletonReference(expression: IrGetSingletonValue) {
        visitDeclarationReference(expression)
    }

    final override fun visitGetObjectValue(expression: IrGetObjectValue, data: Nothing?) {
        visitGetObjectValue(expression)
    }

    open fun visitGetObjectValue(expression: IrGetObjectValue) {
        visitSingletonReference(expression)
    }

    final override fun visitGetEnumValue(expression: IrGetEnumValue, data: Nothing?) {
        visitGetEnumValue(expression)
    }

    open fun visitGetEnumValue(expression: IrGetEnumValue) {
        visitSingletonReference(expression)
    }

    final override fun visitRawFunctionReference(expression: IrRawFunctionReference, data: Nothing?) {
        visitRawFunctionReference(expression)
    }

    open fun visitRawFunctionReference(expression: IrRawFunctionReference) {
        visitDeclarationReference(expression)
    }

    final override fun visitContainerExpression(expression: IrContainerExpression, data: Nothing?) {
        visitContainerExpression(expression)
    }

    open fun visitContainerExpression(expression: IrContainerExpression) {
        visitExpression(expression)
    }

    final override fun visitBlock(expression: IrBlock, data: Nothing?) {
        visitBlock(expression)
    }

    open fun visitBlock(expression: IrBlock) {
        visitContainerExpression(expression)
    }

    final override fun visitComposite(expression: IrComposite, data: Nothing?) {
        visitComposite(expression)
    }

    open fun visitComposite(expression: IrComposite) {
        visitContainerExpression(expression)
    }

    final override fun visitReturnableBlock(expression: IrReturnableBlock, data: Nothing?) {
        visitReturnableBlock(expression)
    }

    open fun visitReturnableBlock(expression: IrReturnableBlock) {
        visitBlock(expression)
    }

    final override fun visitInlinedFunctionBlock(inlinedBlock: IrInlinedFunctionBlock, data: Nothing?) {
        visitInlinedFunctionBlock(inlinedBlock)
    }

    open fun visitInlinedFunctionBlock(inlinedBlock: IrInlinedFunctionBlock) {
        visitBlock(inlinedBlock)
    }

    final override fun visitSyntheticBody(body: IrSyntheticBody, data: Nothing?) {
        visitSyntheticBody(body)
    }

    open fun visitSyntheticBody(body: IrSyntheticBody) {
        visitBody(body)
    }

    final override fun visitBreakContinue(jump: IrBreakContinue, data: Nothing?) {
        visitBreakContinue(jump)
    }

    open fun visitBreakContinue(jump: IrBreakContinue) {
        visitExpression(jump)
    }

    final override fun visitBreak(jump: IrBreak, data: Nothing?) {
        visitBreak(jump)
    }

    open fun visitBreak(jump: IrBreak) {
        visitBreakContinue(jump)
    }

    final override fun visitContinue(jump: IrContinue, data: Nothing?) {
        visitContinue(jump)
    }

    open fun visitContinue(jump: IrContinue) {
        visitBreakContinue(jump)
    }

    final override fun visitCall(expression: IrCall, data: Nothing?) {
        visitCall(expression)
    }

    open fun visitCall(expression: IrCall) {
        visitFunctionAccess(expression)
    }

    final override fun visitCallableReference(expression: IrCallableReference<*>, data: Nothing?) {
        visitCallableReference(expression)
    }

    open fun visitCallableReference(expression: IrCallableReference<*>) {
        visitMemberAccess(expression)
    }

    final override fun visitFunctionReference(expression: IrFunctionReference, data: Nothing?) {
        visitFunctionReference(expression)
    }

    open fun visitFunctionReference(expression: IrFunctionReference) {
        visitCallableReference(expression)
    }

    final override fun visitPropertyReference(expression: IrPropertyReference, data: Nothing?) {
        visitPropertyReference(expression)
    }

    open fun visitPropertyReference(expression: IrPropertyReference) {
        visitCallableReference(expression)
    }

    final override fun visitLocalDelegatedPropertyReference(expression: IrLocalDelegatedPropertyReference, data: Nothing?) {
        visitLocalDelegatedPropertyReference(expression)
    }

    open fun visitLocalDelegatedPropertyReference(expression: IrLocalDelegatedPropertyReference) {
        visitCallableReference(expression)
    }

    final override fun visitRichCallableReference(expression: IrRichCallableReference<*>, data: Nothing?) {
        visitRichCallableReference(expression)
    }

    open fun visitRichCallableReference(expression: IrRichCallableReference<*>) {
        visitExpression(expression)
    }

    final override fun visitRichFunctionReference(expression: IrRichFunctionReference, data: Nothing?) {
        visitRichFunctionReference(expression)
    }

    open fun visitRichFunctionReference(expression: IrRichFunctionReference) {
        visitRichCallableReference(expression)
    }

    final override fun visitRichPropertyReference(expression: IrRichPropertyReference, data: Nothing?) {
        visitRichPropertyReference(expression)
    }

    open fun visitRichPropertyReference(expression: IrRichPropertyReference) {
        visitRichCallableReference(expression)
    }

    final override fun visitClassReference(expression: IrClassReference, data: Nothing?) {
        visitClassReference(expression)
    }

    open fun visitClassReference(expression: IrClassReference) {
        visitTypeRecursively(expression, expression.classType)
        visitDeclarationReference(expression)
    }

    final override fun visitConst(expression: IrConst, data: Nothing?) {
        visitConst(expression)
    }

    open fun visitConst(expression: IrConst) {
        visitExpression(expression)
    }

    final override fun visitConstantValue(expression: IrConstantValue, data: Nothing?) {
        visitConstantValue(expression)
    }

    open fun visitConstantValue(expression: IrConstantValue) {
        visitExpression(expression)
    }

    final override fun visitConstantPrimitive(expression: IrConstantPrimitive, data: Nothing?) {
        visitConstantPrimitive(expression)
    }

    open fun visitConstantPrimitive(expression: IrConstantPrimitive) {
        visitConstantValue(expression)
    }

    final override fun visitConstantObject(expression: IrConstantObject, data: Nothing?) {
        visitConstantObject(expression)
    }

    open fun visitConstantObject(expression: IrConstantObject) {
        expression.typeArguments.forEach { visitTypeRecursively(expression, it) }
        visitConstantValue(expression)
    }

    final override fun visitConstantArray(expression: IrConstantArray, data: Nothing?) {
        visitConstantArray(expression)
    }

    open fun visitConstantArray(expression: IrConstantArray) {
        visitConstantValue(expression)
    }

    final override fun visitDelegatingConstructorCall(expression: IrDelegatingConstructorCall, data: Nothing?) {
        visitDelegatingConstructorCall(expression)
    }

    open fun visitDelegatingConstructorCall(expression: IrDelegatingConstructorCall) {
        visitFunctionAccess(expression)
    }

    final override fun visitDynamicExpression(expression: IrDynamicExpression, data: Nothing?) {
        visitDynamicExpression(expression)
    }

    open fun visitDynamicExpression(expression: IrDynamicExpression) {
        visitExpression(expression)
    }

    final override fun visitDynamicOperatorExpression(expression: IrDynamicOperatorExpression, data: Nothing?) {
        visitDynamicOperatorExpression(expression)
    }

    open fun visitDynamicOperatorExpression(expression: IrDynamicOperatorExpression) {
        visitDynamicExpression(expression)
    }

    final override fun visitDynamicMemberExpression(expression: IrDynamicMemberExpression, data: Nothing?) {
        visitDynamicMemberExpression(expression)
    }

    open fun visitDynamicMemberExpression(expression: IrDynamicMemberExpression) {
        visitDynamicExpression(expression)
    }

    final override fun visitEnumConstructorCall(expression: IrEnumConstructorCall, data: Nothing?) {
        visitEnumConstructorCall(expression)
    }

    open fun visitEnumConstructorCall(expression: IrEnumConstructorCall) {
        visitFunctionAccess(expression)
    }

    final override fun visitErrorExpression(expression: IrErrorExpression, data: Nothing?) {
        visitErrorExpression(expression)
    }

    open fun visitErrorExpression(expression: IrErrorExpression) {
        visitExpression(expression)
    }

    final override fun visitErrorCallExpression(expression: IrErrorCallExpression, data: Nothing?) {
        visitErrorCallExpression(expression)
    }

    open fun visitErrorCallExpression(expression: IrErrorCallExpression) {
        visitErrorExpression(expression)
    }

    final override fun visitFieldAccess(expression: IrFieldAccessExpression, data: Nothing?) {
        visitFieldAccess(expression)
    }

    open fun visitFieldAccess(expression: IrFieldAccessExpression) {
        visitDeclarationReference(expression)
    }

    final override fun visitGetField(expression: IrGetField, data: Nothing?) {
        visitGetField(expression)
    }

    open fun visitGetField(expression: IrGetField) {
        visitFieldAccess(expression)
    }

    final override fun visitSetField(expression: IrSetField, data: Nothing?) {
        visitSetField(expression)
    }

    open fun visitSetField(expression: IrSetField) {
        visitFieldAccess(expression)
    }

    final override fun visitFunctionExpression(expression: IrFunctionExpression, data: Nothing?) {
        visitFunctionExpression(expression)
    }

    open fun visitFunctionExpression(expression: IrFunctionExpression) {
        visitExpression(expression)
    }

    final override fun visitGetClass(expression: IrGetClass, data: Nothing?) {
        visitGetClass(expression)
    }

    open fun visitGetClass(expression: IrGetClass) {
        visitExpression(expression)
    }

    final override fun visitInstanceInitializerCall(expression: IrInstanceInitializerCall, data: Nothing?) {
        visitInstanceInitializerCall(expression)
    }

    open fun visitInstanceInitializerCall(expression: IrInstanceInitializerCall) {
        visitExpression(expression)
    }

    final override fun visitLoop(loop: IrLoop, data: Nothing?) {
        visitLoop(loop)
    }

    open fun visitLoop(loop: IrLoop) {
        visitExpression(loop)
    }

    final override fun visitWhileLoop(loop: IrWhileLoop, data: Nothing?) {
        visitWhileLoop(loop)
    }

    open fun visitWhileLoop(loop: IrWhileLoop) {
        visitLoop(loop)
    }

    final override fun visitDoWhileLoop(loop: IrDoWhileLoop, data: Nothing?) {
        visitDoWhileLoop(loop)
    }

    open fun visitDoWhileLoop(loop: IrDoWhileLoop) {
        visitLoop(loop)
    }

    final override fun visitReturn(expression: IrReturn, data: Nothing?) {
        visitReturn(expression)
    }

    open fun visitReturn(expression: IrReturn) {
        visitExpression(expression)
    }

    final override fun visitStringConcatenation(expression: IrStringConcatenation, data: Nothing?) {
        visitStringConcatenation(expression)
    }

    open fun visitStringConcatenation(expression: IrStringConcatenation) {
        visitExpression(expression)
    }

    final override fun visitSuspensionPoint(expression: IrSuspensionPoint, data: Nothing?) {
        visitSuspensionPoint(expression)
    }

    open fun visitSuspensionPoint(expression: IrSuspensionPoint) {
        visitExpression(expression)
    }

    final override fun visitSuspendableExpression(expression: IrSuspendableExpression, data: Nothing?) {
        visitSuspendableExpression(expression)
    }

    open fun visitSuspendableExpression(expression: IrSuspendableExpression) {
        visitExpression(expression)
    }

    final override fun visitThrow(expression: IrThrow, data: Nothing?) {
        visitThrow(expression)
    }

    open fun visitThrow(expression: IrThrow) {
        visitExpression(expression)
    }

    final override fun visitTry(aTry: IrTry, data: Nothing?) {
        visitTry(aTry)
    }

    open fun visitTry(aTry: IrTry) {
        visitExpression(aTry)
    }

    final override fun visitCatch(aCatch: IrCatch, data: Nothing?) {
        visitCatch(aCatch)
    }

    open fun visitCatch(aCatch: IrCatch) {
        visitElement(aCatch)
    }

    final override fun visitTypeOperator(expression: IrTypeOperatorCall, data: Nothing?) {
        visitTypeOperator(expression)
    }

    open fun visitTypeOperator(expression: IrTypeOperatorCall) {
        visitTypeRecursively(expression, expression.typeOperand)
        visitExpression(expression)
    }

    final override fun visitValueAccess(expression: IrValueAccessExpression, data: Nothing?) {
        visitValueAccess(expression)
    }

    open fun visitValueAccess(expression: IrValueAccessExpression) {
        visitDeclarationReference(expression)
    }

    final override fun visitGetValue(expression: IrGetValue, data: Nothing?) {
        visitGetValue(expression)
    }

    open fun visitGetValue(expression: IrGetValue) {
        visitValueAccess(expression)
    }

    final override fun visitSetValue(expression: IrSetValue, data: Nothing?) {
        visitSetValue(expression)
    }

    open fun visitSetValue(expression: IrSetValue) {
        visitValueAccess(expression)
    }

    final override fun visitVararg(expression: IrVararg, data: Nothing?) {
        visitVararg(expression)
    }

    open fun visitVararg(expression: IrVararg) {
        visitTypeRecursively(expression, expression.varargElementType)
        visitExpression(expression)
    }

    final override fun visitSpreadElement(spread: IrSpreadElement, data: Nothing?) {
        visitSpreadElement(spread)
    }

    open fun visitSpreadElement(spread: IrSpreadElement) {
        visitElement(spread)
    }

    final override fun visitWhen(expression: IrWhen, data: Nothing?) {
        visitWhen(expression)
    }

    open fun visitWhen(expression: IrWhen) {
        visitExpression(expression)
    }

    final override fun visitBranch(branch: IrBranch, data: Nothing?) {
        visitBranch(branch)
    }

    open fun visitBranch(branch: IrBranch) {
        visitElement(branch)
    }

    final override fun visitElseBranch(branch: IrElseBranch, data: Nothing?) {
        visitElseBranch(branch)
    }

    open fun visitElseBranch(branch: IrElseBranch) {
        visitBranch(branch)
    }
}
