/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.TailSuspendCalls;
import org.jetbrains.kotlin.backend.common.TailSuspendCallsCollectorKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"collectTailSuspendCalls", "Lorg/jetbrains/kotlin/backend/common/TailSuspendCalls;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nTailSuspendCallsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TailSuspendCallsCollector.kt\norg/jetbrains/kotlin/backend/common/TailSuspendCallsCollectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class TailSuspendCallsCollectorKt {
    @NotNull
    public static final TailSuspendCalls collectTailSuspendCalls(@NotNull CommonBackendContext context2, @NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        if (!irFunction.isSuspend()) {
            boolean $i$a$-require-TailSuspendCallsCollectorKt$collectTailSuspendCalls$22 = false;
            String $i$a$-require-TailSuspendCallsCollectorKt$collectTailSuspendCalls$22 = "A suspend function expected: " + RenderIrElementKt.render$default(irFunction, null, 1, null);
            throw new IllegalArgumentException($i$a$-require-TailSuspendCallsCollectorKt$collectTailSuspendCalls$22.toString());
        }
        IrBody irBody = irFunction.getBody();
        if (irBody == null) {
            return new TailSuspendCalls(SetsKt.emptySet(), false);
        }
        IrBody body = irBody;
        boolean isUnitReturn = IrTypePredicatesKt.isUnit(irFunction.getReturnType());
        Ref.BooleanRef hasNotTailSuspendCall = new Ref.BooleanRef();
        Set tailSuspendCalls = new LinkedHashSet();
        Set tailReturnableBlocks = new LinkedHashSet();
        IrVisitor<Unit, VisitorState> visitor2 = new IrVisitor<Unit, VisitorState>(irFunction, (Set<IrReturnableBlockSymbol>)tailReturnableBlocks, isUnitReturn, (Set<IrCall>)tailSuspendCalls, hasNotTailSuspendCall, context2){
            final /* synthetic */ IrSimpleFunction $irFunction;
            final /* synthetic */ Set<IrReturnableBlockSymbol> $tailReturnableBlocks;
            final /* synthetic */ boolean $isUnitReturn;
            final /* synthetic */ Set<IrCall> $tailSuspendCalls;
            final /* synthetic */ Ref.BooleanRef $hasNotTailSuspendCall;
            final /* synthetic */ CommonBackendContext $context;
            {
                this.$irFunction = $irFunction;
                this.$tailReturnableBlocks = $tailReturnableBlocks;
                this.$isUnitReturn = $isUnitReturn;
                this.$tailSuspendCalls = $tailSuspendCalls;
                this.$hasNotTailSuspendCall = $hasNotTailSuspendCall;
                this.$context = $context;
            }

            public void visitElement(IrElement element, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\t"}, d2={"org/jetbrains/kotlin/backend/common/TailSuspendCallsCollectorKt$collectTailSuspendCalls$VisitorState", "", "insideTryBlock", "", "isTailExpression", "<init>", "(ZZ)V", "getInsideTryBlock", "()Z", "ir.backend.common"})
                public final class VisitorState {
                    private final boolean insideTryBlock;
                    private final boolean isTailExpression;

                    public VisitorState(boolean insideTryBlock, boolean isTailExpression) {
                        this.insideTryBlock = insideTryBlock;
                        this.isTailExpression = isTailExpression;
                    }

                    public final boolean getInsideTryBlock() {
                        return this.insideTryBlock;
                    }

                    public final boolean isTailExpression() {
                        return this.isTailExpression;
                    }
                }
                element.acceptChildren(this, new VisitorState(data.getInsideTryBlock(), false));
            }

            public void visitTry(IrTry aTry, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                aTry.getTryResult().accept(this, new VisitorState(true, false));
                Iterable $this$forEach$iv = aTry.getCatches();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrCatch it = (IrCatch)element$iv;
                    boolean bl = false;
                    it.getResult().accept(this, data);
                }
                if (!(aTry.getFinallyExpression() == null)) {
                    boolean bl = false;
                    String string = "All finally clauses should've been lowered out";
                    throw new IllegalArgumentException(string.toString());
                }
            }

            private final boolean isTailReturn(IrReturn expression2) {
                return Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$irFunction.getSymbol()) || CollectionsKt.contains((Iterable)this.$tailReturnableBlocks, (Object)expression2.getReturnTargetSymbol());
            }

            private final boolean canBeOptimized(IrTypeOperatorCall $this$canBeOptimized) {
                return $this$canBeOptimized.getOperator() == IrTypeOperator.IMPLICIT_CAST || $this$canBeOptimized.getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
            }

            public void visitReturn(IrReturn expression2, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                IrExpression returnValue = expression2.getValue();
                IrExpression actualExpressionValue = returnValue instanceof IrTypeOperatorCall && this.isTailReturn(expression2) && this.canBeOptimized((IrTypeOperatorCall)returnValue) ? ((IrTypeOperatorCall)returnValue).getArgument() : returnValue;
                actualExpressionValue.accept(this, new VisitorState(data.getInsideTryBlock(), this.isTailReturn(expression2)));
            }

            public void visitExpressionBody(IrExpressionBody body, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                body.acceptChildren(this, data);
            }

            public void visitBlockBody(IrBlockBody body, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitStatementContainer(body, data);
            }

            public void visitContainerExpression(IrContainerExpression expression2, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (expression2 instanceof IrReturnableBlock && data.isTailExpression()) {
                    this.$tailReturnableBlocks.add(((IrReturnableBlock)expression2).getSymbol());
                }
                this.visitStatementContainer(expression2, data);
            }

            /*
             * Unable to fully structure code
             */
            private final void visitStatementContainer(IrStatementContainer expression, VisitorState data) {
                var3_3 = expression.getStatements();
                var4_4 = this.$isUnitReturn;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    block5: {
                        block4: {
                            if ((var9_9 = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            var10_10 = (IrStatement)item$iv;
                            index = var9_9;
                            $i$a$-forEachIndexed-TailSuspendCallsCollectorKt$collectTailSuspendCalls$visitor$1$visitStatementContainer$1 = false;
                            if (index != CollectionsKt.getLastIndex(expression.getStatements())) break block4;
                            v0 = data.isTailExpression();
                            break block5;
                        }
                        if (!var4_4) ** GOTO lbl-1000
                        it = expression.getStatements().get(index + 1);
                        $i$a$-let-TailSuspendCallsCollectorKt$collectTailSuspendCalls$visitor$1$visitStatementContainer$1$isTailStatement$1 = false;
                        v1 = it instanceof IrReturn && this.isTailReturn((IrReturn)it) && this.isUnitRead(((IrReturn)it).getValue());
                        if (v1) {
                            v0 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = false;
                        }
                    }
                    isTailStatement = v0;
                    irStatement.accept(this, new VisitorState(data.getInsideTryBlock(), isTailStatement));
                }
            }

            public void visitWhen(IrWhen expression2, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Iterable $this$forEach$iv = expression2.getBranches();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    IrBranch it = (IrBranch)element$iv;
                    boolean bl = false;
                    it.getCondition().accept(this, new VisitorState(data.getInsideTryBlock(), false));
                    it.getResult().accept(this, data);
                }
            }

            public void visitCall(IrCall expression2, VisitorState data) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (IrUtilsKt.isSuspend(expression2)) {
                    if (!data.getInsideTryBlock() && data.isTailExpression()) {
                        this.$tailSuspendCalls.add(expression2);
                    } else {
                        this.$hasNotTailSuspendCall.element = true;
                    }
                }
                boolean isTailExpression = data.isTailExpression() && this.isReturnIfSuspendedCall(expression2);
                expression2.acceptChildren(this, new VisitorState(data.getInsideTryBlock(), isTailExpression));
            }

            private final boolean isUnitRead(IrExpression $this$isUnitRead) {
                if ($this$isUnitRead instanceof IrTypeOperatorCall) {
                    return this.isUnitRead(((IrTypeOperatorCall)$this$isUnitRead).getArgument());
                }
                return $this$isUnitRead instanceof IrGetObjectValue && Intrinsics.areEqual((Object)((IrGetObjectValue)$this$isUnitRead).getSymbol(), (Object)this.$context.getIrBuiltIns().getUnitClass());
            }

            private final boolean isReturnIfSuspendedCall(IrCall $this$isReturnIfSuspendedCall) {
                return Intrinsics.areEqual((Object)$this$isReturnIfSuspendedCall.getSymbol(), (Object)this.$context.getSymbols().getReturnIfSuspended());
            }
        };
        body.accept((IrVisitor)visitor2, new VisitorState(false, true));
        return new TailSuspendCalls(tailSuspendCalls, hasNotTailSuspendCall.element);
    }
}

