/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhasePrerequisites;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.JvmVersionOverloadsLowering;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.org.objectweb.asm.commons.Method;

@PhasePrerequisites(value={JvmVersionOverloadsLowering.class})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateWrappers", "target", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "hasConflictingOverloads", "", "wrapper", "generateWrapper", "numDefaultParametersToExpect", "", "generateWrapperHeader", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "oldFunction", "generateNewParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmOverloadsAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n812#2,12:169\n777#2:181\n873#2,2:182\n1915#2,2:184\n1834#2,4:186\n1807#2,3:190\n1661#2,3:200\n1642#2,10:212\n1915#2:222\n1916#2:224\n1652#2:225\n1276#3,2:193\n418#4,5:195\n423#4:203\n315#5,4:204\n269#5,4:208\n1#6:223\n*S KotlinDebug\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n*L\n39#1:169,12\n39#1:181\n39#1:182,2\n43#1:184,2\n49#1:186,4\n50#1:190,3\n85#1:200,3\n151#1:212,10\n151#1:222\n151#1:224\n151#1:225\n63#1:193,2\n85#1:195,5\n85#1:203\n116#1:204,4\n125#1:208,4\n151#1:223\n*E\n"})
public final class JvmOverloadsAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmOverloadsAnnotationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)it, JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_FQ_NAME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = functions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            this.generateWrappers(it, irClass);
        }
    }

    private final void generateWrappers(IrFunction target, IrClass irClass) {
        boolean bl;
        block7: {
            IrValueParameter it;
            int n;
            Iterable $this$count$iv = target.getParameters();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (IrValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDefaultValue() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int numDefaultParameters = n;
            Iterable $this$any$iv = target.getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)it, StandardClassIds.Annotations.INSTANCE.getIntroducedAt())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasIntroducedAt = bl;
        for (int i = numDefaultParameters - 1; -1 < i; --i) {
            IrFunction wrapper = this.generateWrapper(target, i);
            if (hasIntroducedAt && this.hasConflictingOverloads(irClass, wrapper)) continue;
            IrDeclarationsKt.addMember(irClass, wrapper);
        }
    }

    private final boolean hasConflictingOverloads(IrClass $this$hasConflictingOverloads, IrFunction wrapper) {
        boolean bl;
        block1: {
            Method signature = this.context.getDefaultMethodSignatureMapper().mapAsmMethod(wrapper);
            Sequence<IrSimpleFunction> $this$any$iv = IrUtilsKt.getFunctions($this$hasConflictingOverloads);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)this.context.getDefaultMethodSignatureMapper().mapAsmMethod(it), (Object)signature)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapper(IrFunction target, int numDefaultParametersToExpect) {
        IrBody irBody;
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunction wrapperIrFunction = this.generateWrapperHeader(this.context.getIrFactory(), target, numDefaultParametersToExpect);
        IrFunction irFunction = target;
        if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression = BuildersKt.fromSymbolOwner$default(IrDelegatingConstructorCallImpl.Companion, -1, -1, this.context.getIrBuiltIns().getUnitType(), ((IrConstructor)target).getSymbol(), 0, 16, null);
        } else if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression = BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, target.getReturnType(), ((IrSimpleFunction)target).getSymbol(), null, null, 48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunctionAccessExpression call = irFunctionAccessExpression;
        for (IrTypeParameter arg : IrUtilsKt.getAllTypeParameters(wrapperIrFunction)) {
            call.getTypeArguments().set(arg.getIndex(), IrTypesKt.getDefaultType(arg));
        }
        Ref.IntRef parametersCopied = new Ref.IntRef();
        int defaultParametersCopied = 0;
        Object object = call.getArguments();
        Collection other$iv = target.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrGetValueImpl irGetValueImpl;
            void valueParameter2;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (valueParameter2.getDefaultValue() == null) {
                irGetValueImpl = JvmOverloadsAnnotationLowering.generateWrapper$lambda$0$irGetParameter(wrapperIrFunction, parametersCopied);
            } else if (defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                irGetValueImpl = JvmOverloadsAnnotationLowering.generateWrapper$lambda$0$irGetParameter(wrapperIrFunction, parametersCopied);
            } else {
                irGetValueImpl = null;
            }
            collection.add((IrExpression)irGetValueImpl);
        }
        object = target;
        if (object instanceof IrConstructor) {
            irBody = IrFactoryHelpersKt.createBlockBody(this.context.getIrFactory(), -1, -1, CollectionsKt.listOf((Object)call));
        } else if (object instanceof IrSimpleFunction) {
            irBody = this.context.getIrFactory().createExpressionBody(-1, -1, call);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        wrapperIrFunction.setBody(irBody);
        return wrapperIrFunction;
    }

    private final IrFunction generateWrapperHeader(IrFactory $this$generateWrapperHeader, IrFunction oldFunction, int numDefaultParametersToExpect) {
        IrFunction irFunction;
        IrFunction irFunction2 = oldFunction;
        if (irFunction2 instanceof IrConstructor) {
            IrFactory $this$buildConstructor$iv = $this$generateWrapperHeader;
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u240 = $this$buildConstructor_u24lambda_u241$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$generateWrapperHeader_u24lambda_u240, oldFunction);
            $this$generateWrapperHeader_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u240.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u240.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u240.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u240.setInline(oldFunction.isInline());
            irFunction = DeclarationBuildersKt.buildConstructor($this$buildConstructor$iv, $this$buildConstructor_u24lambda_u241$iv);
        } else if (irFunction2 instanceof IrSimpleFunction) {
            IrFactory $this$buildFun$iv = $this$generateWrapperHeader;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u241 = $this$buildFun_u24lambda_u240$iv;
            boolean bl3 = false;
            IrElementBuilderKt.setSourceRange($this$generateWrapperHeader_u24lambda_u241, oldFunction);
            $this$generateWrapperHeader_u24lambda_u241.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u241.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u241.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u241.setModality(this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.GenerateJvmOverloadsAsFinal) ? Modality.FINAL : ((IrSimpleFunction)oldFunction).getModality());
            $this$generateWrapperHeader_u24lambda_u241.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u241.setInline(oldFunction.isInline());
            $this$generateWrapperHeader_u24lambda_u241.setSuspend(((IrSimpleFunction)oldFunction).isSuspend());
            irFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunction res2 = irFunction;
        res2.setParent(oldFunction.getParent());
        IrUtilsKt.copyAnnotationsFrom(res2, oldFunction);
        IrUtilsKt.copyTypeParametersFrom$default(res2, oldFunction, null, null, 6, null);
        res2.setParameters(CollectionsKt.plus((Collection)res2.getParameters(), (Iterable)this.generateNewParameters(res2, oldFunction, numDefaultParametersToExpect)));
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrValueParameter> generateNewParameters(IrFunction $this$generateNewParameters, IrFunction oldFunction, int numDefaultParametersToExpect) {
        void $this$mapNotNullTo$iv$iv;
        int defaultParametersCopied = 0;
        Iterable $this$mapNotNull$iv = oldFunction.getParameters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrValueParameter irValueParameter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrValueParameter oldParameter = (IrValueParameter)element$iv$iv;
            boolean bl2 = false;
            if (oldParameter.getDefaultValue() == null) {
                irValueParameter = IrUtilsKt.copyTo$default(oldParameter, $this$generateNewParameters, null, 0, 0, null, null, null, null, null, false, false, false, null, null, 16382, null);
            } else if (defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                irValueParameter = IrUtilsKt.copyTo$default(oldParameter, $this$generateNewParameters, null, 0, 0, null, null, null, null, null, oldParameter.isCrossinline(), oldParameter.isNoinline(), false, null, null, 14590, null);
            } else {
                irValueParameter = null;
            }
            if (irValueParameter == null) continue;
            IrValueParameter it$iv$iv = irValueParameter;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final IrGetValueImpl generateWrapper$lambda$0$irGetParameter(IrFunction wrapperIrFunction, Ref.IntRef parametersCopied) {
        int n = parametersCopied.element;
        parametersCopied.element = n + 1;
        return BuildersKt.IrGetValueImpl$default(-1, -1, wrapperIrFunction.getParameters().get(n).getSymbol(), null, 8, null);
    }
}

