/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DescriptorByIdSignatureFinderImpl;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.FileDeserializationState;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.konan.serialization.CacheDeserializationStrategy;
import org.jetbrains.kotlin.backend.konan.serialization.KonanManglerDesc;
import org.jetbrains.kotlin.backend.konan.serialization.SerializedFileReference;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IdSignatureRendererKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0019J\u000e\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0015J\u000f\u0010\"\u001a\u0004\u0018\u00010/*\u00020\u0015H\u0082\u0010J\u000e\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001aJ\u0011\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0015H\u0096\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR'\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001a0$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u001e\u001a\u0004\b%\u0010&R'\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020 0$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u001e\u001a\u0004\b*\u0010&R\u0015\u0010,\u001a\u00020 *\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/backend/konan/serialization/KonanPartialModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "kotlinIrLinker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "strategyResolver", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "cacheDeserializationStrategy", "Lorg/jetbrains/kotlin/backend/konan/serialization/CacheDeserializationStrategy;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/KotlinLibrary;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/backend/konan/serialization/CacheDeserializationStrategy;)V", "getKlib", "()Lorg/jetbrains/kotlin/library/KotlinLibrary;", "descriptorSignatures", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "getIdSignature", "descriptor", "files", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getFiles", "()Ljava/util/List;", "files$delegate", "Lkotlin/Lazy;", "getDeserializationStates", "Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "getFileDeserializationState", "fileSignature", "idSignatureToFile", "", "getIdSignatureToFile", "()Ljava/util/Map;", "idSignatureToFile$delegate", "fileReferenceToFileDeserializationState", "Lorg/jetbrains/kotlin/backend/konan/serialization/SerializedFileReference;", "getFileReferenceToFileDeserializationState", "fileReferenceToFileDeserializationState$delegate", "deserializationState", "getDeserializationState", "(Lorg/jetbrains/kotlin/backend/konan/serialization/SerializedFileReference;)Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "getFileNameOf", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getKlibFileIndexOf", "", "irFile", "descriptorByIdSignatureFinder", "Lorg/jetbrains/kotlin/backend/common/serialization/DescriptorByIdSignatureFinderImpl;", "contains", "", "idSig", "ir.serialization.native"})
@SourceDebugExtension(value={"SMAP\nKonanPartialModuleDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KonanPartialModuleDeserializer.kt\norg/jetbrains/kotlin/backend/konan/serialization/KonanPartialModuleDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n231#2,2:92\n1586#2:94\n1661#2,3:95\n1915#2:98\n1915#2,2:99\n1916#2:101\n1220#2,2:102\n1249#2,4:104\n*S KotlinDebug\n*F\n+ 1 KonanPartialModuleDeserializer.kt\norg/jetbrains/kotlin/backend/konan/serialization/KonanPartialModuleDeserializer\n*L\n80#1:92,2\n37#1:94\n37#1:95,3\n47#1:98\n48#1:99,2\n47#1:101\n56#1:102,2\n56#1:104,4\n*E\n"})
public final class KonanPartialModuleDeserializer
extends BasicIrModuleDeserializer {
    @NotNull
    private final KotlinLibrary klib;
    @NotNull
    private final CacheDeserializationStrategy cacheDeserializationStrategy;
    @NotNull
    private final Map<DeclarationDescriptor, IdSignature> descriptorSignatures;
    @NotNull
    private final Lazy files$delegate;
    @NotNull
    private final Lazy idSignatureToFile$delegate;
    @NotNull
    private final Lazy fileReferenceToFileDeserializationState$delegate;
    @NotNull
    private final DescriptorByIdSignatureFinderImpl descriptorByIdSignatureFinder;

    public KonanPartialModuleDeserializer(@NotNull KotlinIrLinker kotlinIrLinker, @NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary klib, @NotNull Function1<? super String, ? extends DeserializationStrategy> strategyResolver, @NotNull CacheDeserializationStrategy cacheDeserializationStrategy) {
        Intrinsics.checkNotNullParameter((Object)kotlinIrLinker, (String)"kotlinIrLinker");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        Intrinsics.checkNotNullParameter(strategyResolver, (String)"strategyResolver");
        Intrinsics.checkNotNullParameter((Object)cacheDeserializationStrategy, (String)"cacheDeserializationStrategy");
        Function1 function1 = arg_0 -> KonanPartialModuleDeserializer._init_$lambda$0(cacheDeserializationStrategy, strategyResolver, arg_0);
        KotlinAbiVersion kotlinAbiVersion = klib.getVersions().getAbiVersion();
        if (kotlinAbiVersion == null) {
            kotlinAbiVersion = KotlinAbiVersion.Companion.getCURRENT();
        }
        super(kotlinIrLinker, moduleDescriptor, function1, kotlinAbiVersion, false, 16, null);
        this.klib = klib;
        this.cacheDeserializationStrategy = cacheDeserializationStrategy;
        this.descriptorSignatures = new LinkedHashMap();
        this.files$delegate = LazyKt.lazy(() -> KonanPartialModuleDeserializer.files_delegate$lambda$0(this));
        this.idSignatureToFile$delegate = LazyKt.lazy(() -> KonanPartialModuleDeserializer.idSignatureToFile_delegate$lambda$0(this));
        this.fileReferenceToFileDeserializationState$delegate = LazyKt.lazy(() -> KonanPartialModuleDeserializer.fileReferenceToFileDeserializationState_delegate$lambda$0(this));
        this.descriptorByIdSignatureFinder = new DescriptorByIdSignatureFinderImpl(moduleDescriptor, KonanManglerDesc.INSTANCE, DescriptorByIdSignatureFinderImpl.LookupMode.MODULE_ONLY);
    }

    @Override
    @NotNull
    public KotlinLibrary getKlib() {
        return this.klib;
    }

    @Nullable
    public final IdSignature getIdSignature(@NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.descriptorSignatures.get(descriptor);
    }

    @NotNull
    public final List<IrFile> getFiles() {
        Lazy lazy = this.files$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final List<FileDeserializationState> getDeserializationStates() {
        return CollectionsKt.toList((Iterable)this.getFileDeserializationStates());
    }

    @NotNull
    public final FileDeserializationState getFileDeserializationState(@NotNull IdSignature fileSignature) {
        Intrinsics.checkNotNullParameter((Object)fileSignature, (String)"fileSignature");
        FileDeserializationState fileDeserializationState = this.getModuleReversedFileIndex().get(fileSignature);
        if (fileDeserializationState == null) {
            throw new IllegalStateException(("No file deserializer for " + IdSignatureRendererKt.render$default(fileSignature, null, 1, null)).toString());
        }
        return fileDeserializationState;
    }

    private final Map<IdSignature, IrFile> getIdSignatureToFile() {
        Lazy lazy = this.idSignatureToFile$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<SerializedFileReference, FileDeserializationState> getFileReferenceToFileDeserializationState() {
        Lazy lazy = this.fileReferenceToFileDeserializationState$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final FileDeserializationState getDeserializationState(@NotNull SerializedFileReference $this$deserializationState) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializationState, (String)"<this>");
        FileDeserializationState fileDeserializationState = this.getFileReferenceToFileDeserializationState().get($this$deserializationState);
        if (fileDeserializationState == null) {
            throw new IllegalStateException(("Unknown file " + $this$deserializationState).toString());
        }
        return fileDeserializationState;
    }

    private final IdSignature.FileSignature fileSignature(IdSignature $this$fileSignature) {
        IdSignature.FileSignature fileSignature;
        block2: {
            KonanPartialModuleDeserializer konanPartialModuleDeserializer = this;
            while (true) {
                IdSignature idSignature;
                if ((idSignature = $this$fileSignature) instanceof IdSignature.FileSignature) {
                    fileSignature = (IdSignature.FileSignature)$this$fileSignature;
                    break block2;
                }
                if (!(idSignature instanceof IdSignature.CompositeSignature)) break;
                KonanPartialModuleDeserializer konanPartialModuleDeserializer2 = konanPartialModuleDeserializer;
                IdSignature idSignature2 = ((IdSignature.CompositeSignature)$this$fileSignature).getContainer();
                konanPartialModuleDeserializer = konanPartialModuleDeserializer2;
                $this$fileSignature = idSignature2;
            }
            fileSignature = null;
        }
        return fileSignature;
    }

    @NotNull
    public final String getFileNameOf(@NotNull IrDeclaration declaration) {
        IdSignature idSig;
        IdSignature topLevelIdSig;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IdSignature idSignature = KonanPartialModuleDeserializer.getFileNameOf$getSignature(declaration, this);
        if (idSignature == null) {
            IrDeclarationParent irDeclarationParent = declaration.getParent();
            IrDeclaration irDeclaration = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
            idSignature = irDeclaration != null ? KonanPartialModuleDeserializer.getFileNameOf$getSignature(irDeclaration, this) : null;
            if (idSignature == null) {
                throw new IllegalStateException(("Can't find signature of " + RenderIrElementKt.render$default(declaration, null, 1, null)).toString());
            }
        }
        if ((object = this.fileSignature(topLevelIdSig = (idSig = idSignature).topLevelSignature())) == null || (object = ((IdSignature.FileSignature)object).getFileName()) == null) {
            IrFile irFile = this.getIdSignatureToFile().get(topLevelIdSig);
            if (irFile != null) {
                object = IrDeclarationsKt.getPath(irFile);
            } else {
                throw new IllegalStateException(("No file for " + idSig).toString());
            }
        }
        return object;
    }

    public final int getKlibFileIndexOf(@NotNull IrFile irFile) {
        Object element$iv2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
            Iterable $this$first$iv = this.getFileDeserializationStates();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                FileDeserializationState it = (FileDeserializationState)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)irFile)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((FileDeserializationState)element$iv2).getFileIndex();
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        return super.contains(idSig) || !Intrinsics.areEqual((Object)this.cacheDeserializationStrategy, (Object)CacheDeserializationStrategy.WholeModule.INSTANCE) && idSig.isPubliclyVisible() && this.descriptorByIdSignatureFinder.findDescriptorBySignature(idSig) != null;
    }

    private static final DeserializationStrategy _init_$lambda$0(CacheDeserializationStrategy $cacheDeserializationStrategy, Function1 $strategyResolver, String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return $cacheDeserializationStrategy.contains(fileName) ? (DeserializationStrategy)((Object)$strategyResolver.invoke((Object)fileName)) : DeserializationStrategy.ON_DEMAND;
    }

    /*
     * WARNING - void declaration
     */
    private static final List files_delegate$lambda$0(KonanPartialModuleDeserializer this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this$0.getFileDeserializationStates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileDeserializationState fileDeserializationState = (FileDeserializationState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFile());
        }
        return (List)destination$iv$iv;
    }

    private static final Map idSignatureToFile_delegate$lambda$0(KonanPartialModuleDeserializer this$0) {
        Map map;
        Map $this$idSignatureToFile_delegate_u24lambda_u240_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = this$0.getFileDeserializationStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileDeserializationState fileDeserializationState = (FileDeserializationState)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = fileDeserializationState.getFileDeserializer().getReversedSignatureIndex().keySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IdSignature idSig = (IdSignature)element$iv2;
                boolean bl3 = false;
                $this$idSignatureToFile_delegate_u24lambda_u240_u240.put(idSig, fileDeserializationState.getFile());
            }
        }
        return MapsKt.build((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map fileReferenceToFileDeserializationState_delegate$lambda$0(KonanPartialModuleDeserializer this$0) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this$0.getFileDeserializationStates();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            FileDeserializationState fileDeserializationState = (FileDeserializationState)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(new SerializedFileReference(it.getFile().getPackageFqName().asString(), IrDeclarationsKt.getPath(it.getFile())), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private static final IdSignature getFileNameOf$getSignature(IrDeclaration $this$getFileNameOf_u24getSignature, KonanPartialModuleDeserializer this$0) {
        IdSignature idSignature = $this$getFileNameOf_u24getSignature.getSymbol().getSignature();
        if (idSignature == null) {
            idSignature = this$0.descriptorSignatures.get($this$getFileNameOf_u24getSignature.getDescriptor());
        }
        return idSignature;
    }
}

