/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.Hash128Bits;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeDeclaratorByFingerprint;
import org.jetbrains.kotlin.wasm.ir.TypesKt;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmArrayRef;
import org.jetbrains.kotlin.wasm.ir.WasmEqRef;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmFuncRef;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI31Ref;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullExternrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructRef;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmV128;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a:\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a:\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00022\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0002\u001a6\u0010\u001e\u001a\u00020\u001f2\u0010\u0010 \u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eH\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014*\u0016\u0010\u0000\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006%"}, d2={"RecursiveTypeGroup", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "structHash", "Lorg/jetbrains/kotlin/backend/common/serialization/Hash128Bits;", "functionHash", "arrayHash", "typeFingerprint", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "currentHash", "visited", "", "resolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType$Type;", "wasmDeclarationFingerprint", "declaration", "indexes", "", "[Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "encodeIndex", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructFieldDeclaration;", "index", "Lkotlin/ULong;", "encodeIndex-VKZWuLQ", "(J)Ljava/util/List;", "wasmTypeDeclarationOrderKey", "", "canonicalSort", "", "group", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/RecursiveTypeGroup;", "stableSort", "", "definedDeclarations", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nRecursiveTypesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecursiveTypesUtils.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/RecursiveTypesUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1849#2,3:198\n1849#2,3:201\n1849#2,3:204\n1021#2,2:208\n1#3:207\n*S KotlinDebug\n*F\n+ 1 RecursiveTypesUtils.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/RecursiveTypesUtilsKt\n*L\n90#1:198,3\n99#1:201,3\n102#1:204,3\n175#1:208,2\n*E\n"})
public final class RecursiveTypesUtilsKt {
    @NotNull
    private static final Hash128Bits structHash = new Hash128Bits(1L, 1L, null);
    @NotNull
    private static final Hash128Bits functionHash = new Hash128Bits(2L, 2L, null);
    @NotNull
    private static final Hash128Bits arrayHash = new Hash128Bits(3L, 3L, null);
    @NotNull
    private static final WasmType[] indexes;

    private static final Hash128Bits typeFingerprint(WasmType type, Hash128Bits currentHash, Set<WasmTypeDeclaration> visited2, Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> resolver) {
        Hash128Bits hash128Bits;
        WasmHeapType wasmHeapType;
        Object object = type;
        if (object instanceof WasmRefType) {
            wasmHeapType = TypesKt.getHeapType(type);
        } else if (object instanceof WasmRefNullType) {
            wasmHeapType = TypesKt.getHeapType(type);
        } else {
            return currentHash.combineWith(new Hash128Bits(ULong.constructor-impl((long)type.getCode()), 0L, 2, null));
        }
        WasmHeapType heapType = wasmHeapType;
        object = heapType;
        if (object instanceof WasmHeapType.Type) {
            hash128Bits = RecursiveTypesUtilsKt.wasmDeclarationFingerprint((WasmTypeDeclaration)resolver.invoke((Object)heapType), currentHash, visited2, resolver);
        } else if (object instanceof WasmHeapType.Simple) {
            hash128Bits = currentHash.combineWith(new Hash128Bits(ULong.constructor-impl((long)((WasmHeapType.Simple)heapType).getCode()), 0L, 2, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return hash128Bits;
    }

    /*
     * WARNING - void declaration
     */
    private static final Hash128Bits wasmDeclarationFingerprint(WasmTypeDeclaration declaration, Hash128Bits currentHash, Set<WasmTypeDeclaration> visited2, Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> resolver) {
        Object object;
        block12: {
            WasmTypeDeclaration wasmTypeDeclaration;
            block10: {
                Hash128Bits fields2;
                block11: {
                    void $this$fold$iv;
                    if (!visited2.add(declaration)) {
                        return currentHash;
                    }
                    wasmTypeDeclaration = declaration;
                    if (!(wasmTypeDeclaration instanceof WasmStructDeclaration)) break block10;
                    Hash128Bits structHash = currentHash.combineWith(RecursiveTypesUtilsKt.structHash);
                    Iterable iterable = ((WasmStructDeclaration)declaration).getFields();
                    Hash128Bits initial$iv = structHash;
                    boolean $i$f$fold = false;
                    Hash128Bits accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void field;
                        WasmStructFieldDeclaration wasmStructFieldDeclaration = (WasmStructFieldDeclaration)element$iv;
                        Hash128Bits acc = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = RecursiveTypesUtilsKt.typeFingerprint(field.getType(), acc, visited2, resolver);
                    }
                    fields2 = accumulator$iv;
                    object = ((WasmStructDeclaration)declaration).getSuperType();
                    if (object == null) break block11;
                    Object it = object;
                    boolean bl = false;
                    Hash128Bits hash128Bits = RecursiveTypesUtilsKt.wasmDeclarationFingerprint((WasmTypeDeclaration)resolver.invoke(it), fields2, visited2, resolver);
                    object = hash128Bits;
                    if (hash128Bits != null) break block12;
                }
                object = fields2;
                break block12;
            }
            if (wasmTypeDeclaration instanceof WasmFunctionType) {
                WasmType parameter;
                Hash128Bits acc;
                Hash128Bits functionHash = currentHash.combineWith(RecursiveTypesUtilsKt.functionHash);
                Iterable $this$fold$iv = ((WasmFunctionType)declaration).getParameterTypes();
                Hash128Bits initial$iv = functionHash;
                boolean $i$f$fold = false;
                Hash128Bits accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    WasmType field = (WasmType)element$iv;
                    acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = RecursiveTypesUtilsKt.typeFingerprint(parameter, acc, visited2, resolver);
                }
                Hash128Bits parametersHash = accumulator$iv;
                $this$fold$iv = ((WasmFunctionType)declaration).getResultTypes();
                initial$iv = parametersHash;
                $i$f$fold = false;
                accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    parameter = (WasmType)element$iv;
                    acc = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = RecursiveTypesUtilsKt.typeFingerprint(parameter, acc, visited2, resolver);
                }
                object = accumulator$iv;
            } else if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
                Hash128Bits arrayHash = currentHash.combineWith(RecursiveTypesUtilsKt.arrayHash);
                object = RecursiveTypesUtilsKt.typeFingerprint(((WasmArrayDeclaration)declaration).getField().getType(), arrayHash, visited2, resolver);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @NotNull
    public static final List<WasmStructFieldDeclaration> encodeIndex-VKZWuLQ(long index) {
        long current = index;
        List result2 = new ArrayList();
        int indexesSize = UInt.constructor-impl((int)indexes.length);
        boolean wasI31 = false;
        while (current != 0L) {
            WasmType fieldType = indexes[(int)Long.remainderUnsigned(current, ULong.constructor-impl((long)((long)indexesSize & 0xFFFFFFFFL)))];
            result2.add(new WasmStructFieldDeclaration("", fieldType, false));
            wasI31 = wasI31 || Intrinsics.areEqual((Object)fieldType, (Object)WasmI31Ref.INSTANCE);
            current = Long.divideUnsigned(current, ULong.constructor-impl((long)((long)indexesSize & 0xFFFFFFFFL)));
        }
        if (!wasI31) {
            result2.add(new WasmStructFieldDeclaration("", WasmI31Ref.INSTANCE, false));
        }
        return result2;
    }

    private static final int wasmTypeDeclarationOrderKey(WasmTypeDeclaration declaration, Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> resolver) {
        int n;
        WasmTypeDeclaration wasmTypeDeclaration = declaration;
        if (wasmTypeDeclaration instanceof WasmArrayDeclaration) {
            n = 0;
        } else if (wasmTypeDeclaration instanceof WasmFunctionType) {
            n = 0;
        } else if (wasmTypeDeclaration instanceof WasmStructDeclaration) {
            WasmHeapType.Type type = ((WasmStructDeclaration)declaration).getSuperType();
            if (type != null) {
                WasmHeapType.Type it = type;
                boolean bl = false;
                n = RecursiveTypesUtilsKt.wasmTypeDeclarationOrderKey((WasmTypeDeclaration)resolver.invoke((Object)it), resolver) + 1;
            } else {
                n = 0;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public static final void canonicalSort(@NotNull List<WasmTypeDeclaration> group, boolean stableSort, @NotNull Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> definedDeclarations) {
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(definedDeclarations, (String)"definedDeclarations");
        if (group.size() == 1) {
            return;
        }
        if (stableSort) {
            CollectionsKt.sortWith(group, (Comparator)new WasmTypeDeclaratorByFingerprint(definedDeclarations));
        }
        Function1 sortMethod = arg_0 -> RecursiveTypesUtilsKt.canonicalSort$lambda$0(definedDeclarations, arg_0);
        List<WasmTypeDeclaration> $this$sortBy$iv = group;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(sortMethod){
                final /* synthetic */ Function1 $selector;
                {
                    this.$selector = $selector;
                }

                public final int compare(T a, T b) {
                    Function1 function1 = this.$selector;
                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                }
            });
        }
    }

    private static final int canonicalSort$lambda$0(Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration> $definedDeclarations, WasmTypeDeclaration declaration) {
        return RecursiveTypesUtilsKt.wasmTypeDeclarationOrderKey(declaration, $definedDeclarations);
    }

    public static final /* synthetic */ Hash128Bits access$wasmDeclarationFingerprint(WasmTypeDeclaration declaration, Hash128Bits currentHash, Set visited2, Function1 resolver) {
        return RecursiveTypesUtilsKt.wasmDeclarationFingerprint(declaration, currentHash, visited2, (Function1<? super WasmHeapType.Type, ? extends WasmTypeDeclaration>)resolver);
    }

    static {
        WasmType[] wasmTypeArray = new WasmType[]{WasmI32.INSTANCE, WasmI64.INSTANCE, WasmF32.INSTANCE, WasmF64.INSTANCE, WasmV128.INSTANCE, WasmI8.INSTANCE, WasmI16.INSTANCE, WasmFuncRef.INSTANCE, WasmExternRef.INSTANCE, WasmAnyRef.INSTANCE, WasmEqRef.INSTANCE, WasmRefNullrefType.INSTANCE, WasmRefNullExternrefType.INSTANCE, WasmI31Ref.INSTANCE, WasmStructRef.INSTANCE, WasmArrayRef.INSTANCE};
        indexes = wasmTypeArray;
    }
}

