/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.LanguageSettingsParserKt;
import org.jetbrains.kotlin.cli.common.arguments.ManualLanguageFeatureSetting;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.config.LanguageFeature;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ \u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/cli/common/arguments/LanguageSettingsParser;", "", "<init>", "()V", "wholePrefix", "", "parseInternalArgument", "Lorg/jetbrains/kotlin/cli/common/arguments/ManualLanguageFeatureSetting;", "arg", "errors", "Lorg/jetbrains/kotlin/cli/common/arguments/ArgumentParseErrors;", "parseLanguageFeature", "tail", "wholeArgument", "reportAndReturnNull", "", "message", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "cli-common"})
public final class LanguageSettingsParser {
    @NotNull
    public static final LanguageSettingsParser INSTANCE = new LanguageSettingsParser();
    @NotNull
    private static final String wholePrefix = "-XXLanguage";

    private LanguageSettingsParser() {
    }

    @Nullable
    public final ManualLanguageFeatureSetting parseInternalArgument(@NotNull String arg, @NotNull ArgumentParseErrors errors) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        if (!StringsKt.startsWith$default((String)arg, (String)wholePrefix, (boolean)false, (int)2, null)) {
            return null;
        }
        String tail = StringsKt.removePrefix((String)arg, (CharSequence)wholePrefix);
        Character c = StringsKt.getOrNull((CharSequence)tail, (int)0);
        char c2 = ':';
        if (c == null || c.charValue() != c2) {
            return (ManualLanguageFeatureSetting)((Object)LanguageSettingsParser.reportAndReturnNull$default(this, errors, "Incorrect internal argument syntax, missing colon: " + arg, null, 2, null));
        }
        String string = tail.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return this.parseLanguageFeature(string, arg, errors);
    }

    @Nullable
    public final ManualLanguageFeatureSetting parseLanguageFeature(@NotNull String tail, @NotNull String wholeArgument, @NotNull ArgumentParseErrors errors) {
        LanguageFeature.State state;
        Character modificator;
        Character c;
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        Intrinsics.checkNotNullParameter((Object)wholeArgument, (String)"wholeArgument");
        Intrinsics.checkNotNullParameter((Object)errors, (String)"errors");
        Character c2 = c = (modificator = StringsKt.getOrNull((CharSequence)tail, (int)0));
        char c3 = '+';
        if (c2 != null && c2.charValue() == c3) {
            state = LanguageFeature.State.ENABLED;
        } else {
            Character c4 = c;
            c3 = '-';
            if (c4 != null && c4.charValue() == c3) {
                state = LanguageFeature.State.DISABLED;
            } else {
                return (ManualLanguageFeatureSetting)((Object)LanguageSettingsParser.reportAndReturnNull$default(this, errors, "Incorrect internal argument syntax, missing modificator: " + wholeArgument, null, 2, null));
            }
        }
        LanguageFeature.State languageFeatureState = state;
        String string = tail.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String languageFeatureName = string;
        if (((CharSequence)languageFeatureName).length() == 0) {
            return (ManualLanguageFeatureSetting)((Object)LanguageSettingsParser.reportAndReturnNull$default(this, errors, "Empty language feature name for internal argument '" + wholeArgument + '\'', null, 2, null));
        }
        LanguageFeature languageFeature = LanguageFeature.Companion.fromString(languageFeatureName);
        if (languageFeature == null) {
            return (ManualLanguageFeatureSetting)((Object)LanguageSettingsParser.reportAndReturnNull$default(this, errors, "Unknown language feature '" + languageFeatureName + "' in passed internal argument '" + wholeArgument + '\'', null, 2, null));
        }
        LanguageFeature languageFeature2 = languageFeature;
        if (languageFeature2.getTestOnly() && !LanguageSettingsParserKt.access$getAreTestOnlyLanguageFeaturesAllowed()) {
            this.reportAndReturnNull(errors, "Language feature '" + languageFeatureName + "' is test-only and cannot be enabled from command line", CompilerMessageSeverity.ERROR);
        }
        return new ManualLanguageFeatureSetting(languageFeature2, languageFeatureState, wholeArgument);
    }

    private final Void reportAndReturnNull(ArgumentParseErrors $this$reportAndReturnNull, String message2, CompilerMessageSeverity severity) {
        ((Collection)$this$reportAndReturnNull.getInternalArgumentsParsingProblems()).add(TuplesKt.to((Object)((Object)severity), (Object)message2));
        return null;
    }

    static /* synthetic */ Void reportAndReturnNull$default(LanguageSettingsParser languageSettingsParser, ArgumentParseErrors argumentParseErrors, String string, CompilerMessageSeverity compilerMessageSeverity, int n, Object object) {
        if ((n & 2) != 0) {
            compilerMessageSeverity = CompilerMessageSeverity.STRONG_WARNING;
        }
        return languageSettingsParser.reportAndReturnNull(argumentParseErrors, string, compilerMessageSeverity);
    }
}

