/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.metadata;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.K2MetadataCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.K2MetadataConfigurationKeys;
import org.jetbrains.kotlin.cli.pipeline.ArgumentsPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.ConfigurationUpdater;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.HmppCliModuleStructure;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatformUnspecifiedTarget;
import org.jetbrains.kotlin.platform.wasm.WasmPlatformWithTarget;
import org.jetbrains.kotlin.platform.wasm.WasmTarget;
import org.jetbrains.kotlin.util.PerformanceManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002J6\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017J\u001e\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataConfigurationUpdater;", "Lorg/jetbrains/kotlin/cli/pipeline/ConfigurationUpdater;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2MetadataCompilerArguments;", "<init>", "()V", "platformMap", "", "", "Lorg/jetbrains/kotlin/platform/SimplePlatform;", "fillConfiguration", "", "input", "Lorg/jetbrains/kotlin/cli/pipeline/ArgumentsPipelineArtifact;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "arguments", "computeTargetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "platformsFromArg", "", "onUnknownPlatform", "Lkotlin/Function1;", "onEmptyPlatforms", "Lkotlin/Function0;", "collector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "cli"})
@SourceDebugExtension(value={"SMAP\nMetadataConfigurationPipelinePhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataConfigurationPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataConfigurationUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,141:1\n1586#2:142\n1661#2,3:143\n18#3:146\n*S KotlinDebug\n*F\n+ 1 MetadataConfigurationPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/metadata/MetadataConfigurationUpdater\n*L\n78#1:142\n78#1:143,3\n95#1:146\n*E\n"})
public final class MetadataConfigurationUpdater
extends ConfigurationUpdater<K2MetadataCompilerArguments> {
    @NotNull
    public static final MetadataConfigurationUpdater INSTANCE = new MetadataConfigurationUpdater();
    @NotNull
    private static final Map<String, SimplePlatform> platformMap;

    private MetadataConfigurationUpdater() {
    }

    @Override
    public void fillConfiguration(@NotNull ArgumentsPipelineArtifact<K2MetadataCompilerArguments> input, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.fillConfiguration(configuration, input.getArguments());
    }

    /*
     * WARNING - void declaration
     */
    public final void fillConfiguration(@NotNull CompilerConfiguration configuration, @NotNull K2MetadataCompilerArguments arguments) {
        PerformanceManager $i$f$map2;
        String string;
        HmppCliModuleStructure hmppCliModuleStructure;
        Object commonSources;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        MessageCollector messageCollector = configuration.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)messageCollector, (String)"getNotNull(...)");
        MessageCollector collector = messageCollector;
        Object object = arguments.getCommonSources();
        if (object == null || (object = ArraysKt.toSet((Object[])object)) == null) {
            object = commonSources = SetsKt.emptySet();
        }
        if ((hmppCliModuleStructure = configuration.get(CommonConfigurationKeys.HMPP_MODULE_STRUCTURE)) != null) {
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "HMPP module structure should not be passed during metadata compilation. Please remove `-Xfragments` and related flags", null, 4, null);
            return;
        }
        for (String arg : arguments.getFreeArgs()) {
            ContentRootsKt.addKotlinSourceRoot(configuration, arg, commonSources.contains(arg), null);
        }
        if (arguments.getClasspath() != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string2 = arguments.getClasspath();
            Intrinsics.checkNotNull((Object)string2);
            Object object2 = new char[1];
            object2[0] = File.pathSeparatorChar;
            object2 = StringsKt.split$default((CharSequence)string2, (char[])object2, (boolean)false, (int)0, (int)6, null);
            CompilerConfiguration compilerConfiguration = configuration;
            boolean $i$f$map2 = false;
            void var8_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new File((String)p0));
            }
            JvmContentRootsKt.addJvmClasspathRoots(compilerConfiguration, (List)destination$iv$iv);
        }
        if ((string = arguments.getModuleName()) == null) {
            string = "main";
        }
        String moduleName2 = string;
        configuration.put(CommonConfigurationKeys.MODULE_NAME, moduleName2);
        configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments.getAllowKotlinPackage());
        configuration.put(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME, arguments.getRenderInternalDiagnosticNames());
        Object[] objectArray = arguments.getFriendPaths();
        configuration.putIfNotNull(K2MetadataConfigurationKeys.INSTANCE.getFRIEND_PATHS(), objectArray != null ? ArraysKt.toList((Object[])objectArray) : null);
        Object[] objectArray2 = arguments.getRefinesPaths();
        configuration.putIfNotNull(K2MetadataConfigurationKeys.INSTANCE.getREFINES_PATHS(), objectArray2 != null ? ArraysKt.toList((Object[])objectArray2) : null);
        PerformanceManager performanceManager = CommonConfigurationKeysKt.getPerfManager(configuration);
        Intrinsics.checkNotNull((Object)performanceManager);
        PerformanceManager $this$fillConfiguration_u24lambda_u240 = $i$f$map2 = performanceManager;
        boolean bl = false;
        $this$fillConfiguration_u24lambda_u240.setOutputKind(arguments.getMetadataKlib() ? "KLib" : "metadata");
        $this$fillConfiguration_u24lambda_u240.setTargetDescription(moduleName2);
        Object[] $this$orEmpty$iv = arguments.getTargetPlatform();
        boolean $i$f$orEmpty = false;
        Object[] objectArray3 = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray3 = new String[]{};
        }
        CommonConfigurationKeysKt.setTargetPlatform(configuration, this.computeTargetPlatform(ArraysKt.toList((Object[])objectArray3), collector));
        String destination = arguments.getDestination();
        if (destination != null) {
            if (StringsKt.endsWith$default((String)destination, (String)".jar", (boolean)false, (int)2, null)) {
                MessageCollector.report$default(collector, CompilerMessageSeverity.STRONG_WARNING, ".jar destination is not yet supported, results will be written to the directory with the given name", null, 4, null);
            }
            configuration.put(CLIConfigurationKeys.METADATA_DESTINATION_DIRECTORY, new File(destination));
        } else {
            MessageCollector.report$default(collector, CompilerMessageSeverity.ERROR, "Specify destination via -d", null, 4, null);
        }
    }

    @NotNull
    public final TargetPlatform computeTargetPlatform(@NotNull List<String> platformsFromArg, @NotNull Function1<? super String, Unit> onUnknownPlatform, @NotNull Function0<Unit> onEmptyPlatforms) {
        Set set;
        Intrinsics.checkNotNullParameter(platformsFromArg, (String)"platformsFromArg");
        Intrinsics.checkNotNullParameter(onUnknownPlatform, (String)"onUnknownPlatform");
        Intrinsics.checkNotNullParameter(onEmptyPlatforms, (String)"onEmptyPlatforms");
        Set $this$computeTargetPlatform_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (String platformArg : platformsFromArg) {
            SimplePlatform simplePlatform;
            if (platformMap.get(platformArg) == null) {
                Set $this$computeTargetPlatform_u24lambda_u240_u240 = $this$computeTargetPlatform_u24lambda_u240;
                boolean bl2 = false;
                onUnknownPlatform.invoke((Object)platformArg);
                continue;
            }
            $this$computeTargetPlatform_u24lambda_u240.add(simplePlatform);
        }
        Set platforms = SetsKt.build((Set)set);
        if (platforms.isEmpty()) {
            onEmptyPlatforms.invoke();
            return CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
        }
        return new TargetPlatform(platforms);
    }

    private final TargetPlatform computeTargetPlatform(List<String> platformsFromArg, MessageCollector collector) {
        return this.computeTargetPlatform(platformsFromArg, (Function1<? super String, Unit>)((Function1)arg_0 -> MetadataConfigurationUpdater.computeTargetPlatform$lambda$1(collector, arg_0)), (Function0<Unit>)((Function0)() -> MetadataConfigurationUpdater.computeTargetPlatform$lambda$2(collector)));
    }

    private static final Unit computeTargetPlatform$lambda$1(MessageCollector $collector, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MessageCollector.report$default($collector, CompilerMessageSeverity.ERROR, "Unknown target platform: " + it + ". Possible values are: " + platformMap.keySet(), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit computeTargetPlatform$lambda$2(MessageCollector $collector) {
        MessageCollector.report$default($collector, CompilerMessageSeverity.WARNING, "No target platform specified, using default", null, 4, null);
        return Unit.INSTANCE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"JVM", (Object)JvmPlatforms.INSTANCE.getUNSPECIFIED_SIMPLE_JVM_PLATFORM()), TuplesKt.to((Object)"JS", (Object)JsPlatforms.DefaultSimpleJsPlatform.INSTANCE), TuplesKt.to((Object)"WasmJs", (Object)new WasmPlatformWithTarget(WasmTarget.JS)), TuplesKt.to((Object)"WasmWasi", (Object)new WasmPlatformWithTarget(WasmTarget.WASI)), TuplesKt.to((Object)"Native", (Object)NativePlatformUnspecifiedTarget.INSTANCE)};
        platformMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

