/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapperBase;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public abstract class StackValue {
    @NotNull
    public final Type type;
    @Nullable
    public final KotlinTypeMarker kotlinType;

    protected StackValue(@NotNull Type type, @Nullable KotlinTypeMarker kotlinType) {
        if (type == null) {
            StackValue.$$$reportNull$$$0(0);
        }
        this.type = type;
        this.kotlinType = kotlinType;
    }

    public abstract void put(@NotNull Type var1, @Nullable KotlinTypeMarker var2, @NotNull InstructionAdapter var3, @NotNull KotlinTypeMapperBase var4);

    public void store(@NotNull Type type, @Nullable KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (type == null) {
            StackValue.$$$reportNull$$$0(1);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(2);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException("Cannot store to value " + this);
    }

    public static StackValue createDefaultValue(@NotNull Type type) {
        if (type == null) {
            StackValue.$$$reportNull$$$0(4);
        }
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return new Constant(null, type);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new Constant(0, type);
            }
            case 1: {
                return new Constant(false, type);
            }
            case 7: {
                return new Constant(0L, type);
            }
            case 6: {
                return new Constant(Float.valueOf(0.0f), type);
            }
            case 8: {
                return new Constant(0.0, type);
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + type));
    }

    private static void box(Type type, Type toType, InstructionAdapter v) {
        Type boxedType;
        if (type == Type.INT_TYPE) {
            if (toType.getInternalName().equals("java/lang/Byte")) {
                type = Type.BYTE_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Short")) {
                type = Type.SHORT_TYPE;
            } else if (toType.getInternalName().equals("java/lang/Long")) {
                type = Type.LONG_TYPE;
            }
            v.cast(Type.INT_TYPE, type);
        }
        if ((boxedType = AsmUtil.boxType(type)) == type) {
            return;
        }
        v.invokestatic(boxedType.getInternalName(), "valueOf", Type.getMethodDescriptor(boxedType, type), false);
        StackValue.coerce(boxedType, toType, v);
    }

    private static void unbox(Type methodOwner, Type type, InstructionAdapter v) {
        assert (AsmUtil.isPrimitive(type)) : "Unboxing should be performed to primitive type, but " + type.getClassName();
        v.invokevirtual(methodOwner.getInternalName(), type.getClassName() + "Value", "()" + type.getDescriptor(), false);
    }

    private static void boxInlineClass(@NotNull KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(5);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(6);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(7);
        }
        Type boxed = typeMapper2.mapTypeCommon(kotlinType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(kotlinType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.boxInlineClass(unboxed, boxed, isNullable, v);
    }

    public static void boxInlineClass(@NotNull Type unboxed, @NotNull Type boxed, boolean isNullable, @NotNull InstructionAdapter v) {
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(8);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(9);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(10);
        }
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeBoxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeBoxMethod(v, boxed, unboxed);
        }
    }

    private static void invokeBoxMethod(@NotNull InstructionAdapter v, @NotNull Type boxedType, @NotNull Type underlyingType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(11);
        }
        if (boxedType == null) {
            StackValue.$$$reportNull$$$0(12);
        }
        if (underlyingType == null) {
            StackValue.$$$reportNull$$$0(13);
        }
        v.invokestatic(boxedType.getInternalName(), KotlinTypeMapper.BOX_JVM_METHOD_NAME, Type.getMethodDescriptor(boxedType, underlyingType), false);
    }

    public static void unboxInlineClass(@NotNull Type type, @NotNull KotlinTypeMarker targetInlineClassType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (type == null) {
            StackValue.$$$reportNull$$$0(14);
        }
        if (targetInlineClassType == null) {
            StackValue.$$$reportNull$$$0(15);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(16);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(17);
        }
        Type boxed = typeMapper2.mapTypeCommon(targetInlineClassType, TypeMappingMode.CLASS_DECLARATION);
        Type unboxed = KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(targetInlineClassType, typeMapper2);
        boolean isNullable = typeMapper2.getTypeSystem().isNullableType(targetInlineClassType) && !AsmUtil.isPrimitive(unboxed);
        StackValue.unboxInlineClass(type, boxed, unboxed, isNullable, v);
    }

    public static void unboxInlineClass(@NotNull Type type, @NotNull Type boxed, @NotNull Type unboxed, boolean isNullable, @NotNull InstructionAdapter v) {
        if (type == null) {
            StackValue.$$$reportNull$$$0(18);
        }
        if (boxed == null) {
            StackValue.$$$reportNull$$$0(19);
        }
        if (unboxed == null) {
            StackValue.$$$reportNull$$$0(20);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(21);
        }
        StackValue.coerce(type, boxed, v);
        if (isNullable) {
            StackValue.boxOrUnboxWithNullCheck(v, vv -> StackValue.invokeUnboxMethod(vv, boxed, unboxed));
        } else {
            StackValue.invokeUnboxMethod(v, boxed, unboxed);
        }
    }

    private static void invokeUnboxMethod(@NotNull InstructionAdapter v, @NotNull Type owner, @NotNull Type resultType) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(22);
        }
        if (owner == null) {
            StackValue.$$$reportNull$$$0(23);
        }
        if (resultType == null) {
            StackValue.$$$reportNull$$$0(24);
        }
        v.invokevirtual(owner.getInternalName(), KotlinTypeMapper.UNBOX_JVM_METHOD_NAME, "()" + resultType.getDescriptor(), false);
    }

    private static void boxOrUnboxWithNullCheck(@NotNull InstructionAdapter v, @NotNull Consumer<InstructionAdapter> body) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(25);
        }
        if (body == null) {
            StackValue.$$$reportNull$$$0(26);
        }
        Label lNull = new Label();
        Label lDone = new Label();
        v.dup();
        v.ifnull(lNull);
        body.accept(v);
        v.goTo(lDone);
        v.mark(lNull);
        v.pop();
        v.aconst(null);
        v.mark(lDone);
    }

    public static void coerce(@NotNull Type fromType, @Nullable KotlinTypeMarker fromKotlinType, @NotNull Type toType, @Nullable KotlinTypeMarker toKotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(27);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(28);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(29);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(30);
        }
        if (StackValue.coerceInlineClasses(fromType, fromKotlinType, toType, toKotlinType, v, typeMapper2)) {
            return;
        }
        StackValue.coerce(fromType, toType, v);
    }

    public static boolean requiresInlineClassBoxingOrUnboxing(@NotNull Type fromType, @Nullable KotlinTypeMarker fromKotlinType, @NotNull Type toType, @Nullable KotlinTypeMarker toKotlinType, @NotNull KotlinTypeMapperBase typeMapper2) {
        boolean isToTypeUnboxed;
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(31);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(32);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(33);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        TypeSystemCommonBackendContext typeSystem = typeMapper2.getTypeSystem();
        boolean isFromTypeInlineClass = typeSystem.isInlineClass(typeSystem.typeConstructor(fromKotlinType));
        boolean isToTypeInlineClass = typeSystem.isInlineClass(typeSystem.typeConstructor(toKotlinType));
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        boolean isFromTypeUnboxed = isFromTypeInlineClass && StackValue.isUnboxedInlineClass(fromKotlinType, fromType, typeMapper2);
        boolean bl = isToTypeUnboxed = isToTypeInlineClass && StackValue.isUnboxedInlineClass(toKotlinType, toType, typeMapper2);
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            return isFromTypeUnboxed != isToTypeUnboxed;
        }
        return isFromTypeInlineClass && isFromTypeUnboxed || isToTypeInlineClass && isToTypeUnboxed;
    }

    private static boolean coerceInlineClasses(@NotNull Type fromType, @Nullable KotlinTypeMarker fromKotlinType, @NotNull Type toType, @Nullable KotlinTypeMarker toKotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(34);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(35);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(36);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(37);
        }
        if (fromKotlinType == null || toKotlinType == null) {
            return false;
        }
        TypeSystemCommonBackendContext typeSystem = typeMapper2.getTypeSystem();
        boolean isFromTypeInlineClass = typeSystem.isInlineClass(typeSystem.typeConstructor(fromKotlinType));
        boolean isToTypeInlineClass = typeSystem.isInlineClass(typeSystem.typeConstructor(toKotlinType));
        if (!isFromTypeInlineClass && !isToTypeInlineClass) {
            return false;
        }
        if (fromKotlinType.equals(toKotlinType) && fromType.equals(toType)) {
            return true;
        }
        if (isFromTypeInlineClass && isToTypeInlineClass) {
            boolean isFromTypeUnboxed = StackValue.isUnboxedInlineClass(fromKotlinType, fromType, typeMapper2);
            boolean isToTypeUnboxed = StackValue.isUnboxedInlineClass(toKotlinType, toType, typeMapper2);
            if (isFromTypeUnboxed && !isToTypeUnboxed) {
                StackValue.boxInlineClass(fromKotlinType, v, typeMapper2);
                return true;
            }
            if (!isFromTypeUnboxed && isToTypeUnboxed) {
                StackValue.unboxInlineClass(fromType, toKotlinType, v, typeMapper2);
                return true;
            }
        } else if (isFromTypeInlineClass) {
            if (StackValue.isUnboxedInlineClass(fromKotlinType, fromType, typeMapper2)) {
                StackValue.boxInlineClass(fromKotlinType, v, typeMapper2);
                return true;
            }
        } else if (StackValue.isUnboxedInlineClass(toKotlinType, toType, typeMapper2)) {
            StackValue.unboxInlineClass(fromType, toKotlinType, v, typeMapper2);
            return true;
        }
        return false;
    }

    private static boolean isUnboxedInlineClass(@NotNull KotlinTypeMarker kotlinType, @NotNull Type actualType, @NotNull KotlinTypeMapperBase typeMapper2) {
        if (kotlinType == null) {
            StackValue.$$$reportNull$$$0(38);
        }
        if (actualType == null) {
            StackValue.$$$reportNull$$$0(39);
        }
        if (typeMapper2 == null) {
            StackValue.$$$reportNull$$$0(40);
        }
        return KotlinTypeMapper.mapUnderlyingTypeOfInlineClassType(kotlinType, typeMapper2).equals(actualType);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(41);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(42);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(43);
        }
        StackValue.coerce(fromType, toType, v, false);
    }

    public static void coerce(@NotNull Type fromType, @NotNull Type toType, @NotNull InstructionAdapter v, boolean forceSelfCast) {
        if (fromType == null) {
            StackValue.$$$reportNull$$$0(44);
        }
        if (toType == null) {
            StackValue.$$$reportNull$$$0(45);
        }
        if (v == null) {
            StackValue.$$$reportNull$$$0(46);
        }
        if (toType.equals(fromType) && !forceSelfCast) {
            return;
        }
        if (toType.getSort() == 0) {
            AsmUtil.pop(v, fromType);
        } else if (fromType.getSort() == 0) {
            if (toType.equals(AsmTypes.UNIT_TYPE) || toType.equals(AsmTypes.OBJECT_TYPE)) {
                StackValue.putUnitInstance(v);
            } else {
                AsmUtil.pushDefaultValueOnStack(toType, v);
            }
        } else if (toType.equals(AsmTypes.UNIT_TYPE)) {
            if (fromType.equals(AsmTypes.getType(Object.class))) {
                v.checkcast(AsmTypes.UNIT_TYPE);
            } else if (!fromType.equals(AsmTypes.getType(Void.class))) {
                AsmUtil.pop(v, fromType);
                StackValue.putUnitInstance(v);
            }
        } else if (toType.getSort() == 9) {
            if (fromType.getSort() != 9) {
                v.checkcast(toType);
            } else if (toType.getDimensions() != fromType.getDimensions()) {
                v.checkcast(toType);
            } else if (!toType.getElementType().equals(AsmTypes.OBJECT_TYPE)) {
                v.checkcast(toType);
            }
        } else if (toType.getSort() == 10) {
            if (fromType.getSort() == 10 || fromType.getSort() == 9) {
                if (!toType.equals(AsmTypes.OBJECT_TYPE)) {
                    v.checkcast(toType);
                }
            } else {
                StackValue.box(fromType, toType, v);
            }
        } else if (fromType.getSort() == 10 || fromType.getSort() == 9) {
            Type unboxedType = AsmUtil.unboxPrimitiveTypeOrNull(fromType);
            if (unboxedType != null) {
                StackValue.unbox(fromType, unboxedType, v);
                StackValue.coerce(unboxedType, toType, v);
            } else if (toType.getSort() == 1) {
                StackValue.coerce(fromType, AsmTypes.BOOLEAN_WRAPPER_TYPE, v);
                StackValue.unbox(AsmTypes.BOOLEAN_WRAPPER_TYPE, Type.BOOLEAN_TYPE, v);
            } else if (toType.getSort() == 2) {
                if (fromType.equals(AsmTypes.NUMBER_TYPE)) {
                    StackValue.unbox(AsmTypes.NUMBER_TYPE, Type.INT_TYPE, v);
                    v.visitInsn(146);
                } else {
                    StackValue.coerce(fromType, AsmTypes.CHARACTER_WRAPPER_TYPE, v);
                    StackValue.unbox(AsmTypes.CHARACTER_WRAPPER_TYPE, Type.CHAR_TYPE, v);
                }
            } else {
                StackValue.coerce(fromType, AsmTypes.NUMBER_TYPE, v);
                StackValue.unbox(AsmTypes.NUMBER_TYPE, toType, v);
            }
        } else {
            v.cast(fromType, toType);
        }
    }

    private static void putUnitInstance(@NotNull InstructionAdapter v) {
        if (v == null) {
            StackValue.$$$reportNull$$$0(47);
        }
        v.visitFieldInsn(178, AsmTypes.UNIT_TYPE.getInternalName(), "INSTANCE", AsmTypes.UNIT_TYPE.getDescriptor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 11: 
            case 16: 
            case 21: 
            case 22: 
            case 25: 
            case 29: 
            case 36: 
            case 43: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: 
            case 7: 
            case 17: 
            case 30: 
            case 33: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 5: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinType";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unboxed";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxed";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "boxedType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInlineClassType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 27: 
            case 31: 
            case 34: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 28: 
            case 32: 
            case 35: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "store";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultValue";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "boxInlineClass";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeBoxMethod";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "unboxInlineClass";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeUnboxMethod";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "boxOrUnboxWithNullCheck";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "coerce";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "requiresInlineClassBoxingOrUnboxing";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "coerceInlineClasses";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnboxedInlineClass";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "putUnitInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Field
    extends StackValue {
        public final Type owner;
        public final String name;
        @NotNull
        public final StackValue receiver;

        public Field(@NotNull Type type, @NotNull Type owner, @NotNull String name2, @NotNull StackValue receiver) {
            if (type == null) {
                Field.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Field.$$$reportNull$$$0(1);
            }
            if (name2 == null) {
                Field.$$$reportNull$$$0(2);
            }
            if (receiver == null) {
                Field.$$$reportNull$$$0(3);
            }
            super(type, null);
            this.owner = owner;
            this.name = name2;
            this.receiver = receiver;
        }

        @Override
        public void put(@NotNull Type type, @Nullable KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
            if (type == null) {
                Field.$$$reportNull$$$0(4);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(5);
            }
            if (typeMapper2 == null) {
                Field.$$$reportNull$$$0(6);
            }
            this.receiver.put(this.receiver.type, this.receiver.kotlinType, v, typeMapper2);
            v.visitFieldInsn(180, this.owner.getInternalName(), this.name, this.type.getDescriptor());
            Field.coerce(this.type, this.kotlinType, type, kotlinType, v, typeMapper2);
        }

        @Override
        public void store(@NotNull Type topOfStackType, @Nullable KotlinTypeMarker topOfStackKotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
            if (topOfStackType == null) {
                Field.$$$reportNull$$$0(7);
            }
            if (v == null) {
                Field.$$$reportNull$$$0(8);
            }
            if (typeMapper2 == null) {
                Field.$$$reportNull$$$0(9);
            }
            this.receiver.put(this.receiver.type, this.receiver.kotlinType, v, typeMapper2);
            Field.coerce(topOfStackType, topOfStackKotlinType, this.type, this.kotlinType, v, typeMapper2);
            v.visitFieldInsn(181, this.owner.getInternalName(), this.name, this.type.getDescriptor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeMapper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Field";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Constant
    extends StackValue {
        @Nullable
        public final Object value;

        public Constant(@Nullable Object value2, Type type) {
            super(type, null);
            this.value = value2;
        }

        @Override
        public void put(@NotNull Type type, @Nullable KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
            if (type == null) {
                Constant.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Constant.$$$reportNull$$$0(1);
            }
            if (typeMapper2 == null) {
                Constant.$$$reportNull$$$0(2);
            }
            if (this.value instanceof Integer || this.value instanceof Byte || this.value instanceof Short) {
                v.iconst(((Number)this.value).intValue());
            } else if (this.value instanceof Character) {
                v.iconst(((Character)this.value).charValue());
            } else if (this.value instanceof Long) {
                v.lconst((Long)this.value);
            } else if (this.value instanceof Float) {
                v.fconst(((Float)this.value).floatValue());
            } else if (this.value instanceof Double) {
                v.dconst((Double)this.value);
            } else {
                v.aconst(this.value);
            }
            if (this.value != null || AsmUtil.isPrimitive(type)) {
                Constant.coerce(this.type, this.kotlinType, type, kotlinType, v, typeMapper2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeMapper";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$Constant";
            objectArray[2] = "put";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class OnStack
    extends StackValue {
        public OnStack(Type type, KotlinTypeMarker kotlinType) {
            super(type, kotlinType);
            if (type == Type.VOID_TYPE) {
                throw new IllegalArgumentException("Cannot create OnStack with void type");
            }
        }

        @Override
        public void put(@NotNull Type type, @Nullable KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
            if (type == null) {
                OnStack.$$$reportNull$$$0(0);
            }
            if (v == null) {
                OnStack.$$$reportNull$$$0(1);
            }
            if (typeMapper2 == null) {
                OnStack.$$$reportNull$$$0(2);
            }
            OnStack.coerce(this.type, this.kotlinType, type, kotlinType, v, typeMapper2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "v";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeMapper";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/StackValue$OnStack";
            objectArray[2] = "put";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Local
    extends StackValue {
        public final int index;

        public Local(int index, Type type, KotlinTypeMarker kotlinType) {
            super(type, kotlinType);
            if (index < 0) {
                throw new IllegalStateException("local variable index must be non-negative");
            }
            this.index = index;
        }

        @Override
        public void put(@NotNull Type type, @Nullable KotlinTypeMarker kotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
            if (type == null) {
                Local.$$$reportNull$$$0(0);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(1);
            }
            if (typeMapper2 == null) {
                Local.$$$reportNull$$$0(2);
            }
            v.load(this.index, this.type);
            Local.coerce(this.type, this.kotlinType, type, kotlinType, v, typeMapper2);
        }

        @Override
        public void store(@NotNull Type topOfStackType, @Nullable KotlinTypeMarker topOfStackKotlinType, @NotNull InstructionAdapter v, @NotNull KotlinTypeMapperBase typeMapper2) {
            if (topOfStackType == null) {
                Local.$$$reportNull$$$0(3);
            }
            if (v == null) {
                Local.$$$reportNull$$$0(4);
            }
            if (typeMapper2 == null) {
                Local.$$$reportNull$$$0(5);
            }
            Local.coerce(topOfStackType, topOfStackKotlinType, this.type, this.kotlinType, v, typeMapper2);
            v.store(this.index, this.type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeMapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStackType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/StackValue$Local";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "store";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

