/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij;

import java.lang.reflect.Field;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.BundleBaseKt;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0007J:\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J6\u0010\u0019\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u001aJK\u0010\u001b\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00072\r\u0010\u001c\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00102\u0016\u0010\u0016\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0017\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J\u001d\u0010\u001f\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0007J)\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u00102\r\u0010#\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0010H\u0007J\u001e\u0010&\u001a\u00020\r2\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010(H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/com/intellij/BundleBase;", "", "<init>", "()V", "MNEMONIC", "", "MNEMONIC_STRING", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/NlsSafe;", "SHOW_LOCALIZED_MESSAGES", "", "L10N_MARKER", "assertOnMissedKeys", "", "doAssert", "partialMessage", "Lorg/jetbrains/annotations/Nls;", "bundle", "Ljava/util/ResourceBundle;", "key", "unassignedParams", "", "params", "", "(Ljava/util/ResourceBundle;Ljava/lang/String;I[Ljava/lang/Object;)Ljava/lang/String;", "message", "(Ljava/util/ResourceBundle;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "messageOrDefault", "defaultValue", "(Ljava/util/ResourceBundle;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getDefaultMessage", "appendLocalizationSuffix", "result", "suffixToAppend", "format", "value", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "replaceMnemonicAmpersand", "setTranslationConsumer", "consumer", "Ljava/util/function/BiConsumer;", "intellij.platform.util"})
public final class BundleBase {
    @NotNull
    public static final BundleBase INSTANCE = new BundleBase();
    @JvmField
    @ApiStatus.Internal
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");

    private BundleBase() {
    }

    @JvmStatic
    @NotNull
    public static final String getDefaultMessage(@NotNull ResourceBundle bundle, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Field field = ResourceBundle.class.getDeclaredField("parent");
            field.setAccessible(true);
            Object parentBundle = field.get(bundle);
            if (parentBundle instanceof ResourceBundle) {
                String string = ((ResourceBundle)parentBundle).getString(key);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                return string;
            }
        }
        catch (IllegalAccessException e) {
            BundleBaseKt.access$getLOG().warn("Cannot fetch default message with 'idea.l10n.english' enabled, by key '" + key + '\'');
        }
        return "undefined";
    }

    @ApiStatus.Internal
    @NotNull
    public final String appendLocalizationSuffix(@NotNull String result2, @NotNull String suffixToAppend) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)suffixToAppend, (String)"suffixToAppend");
        for (String suffix : BundleBaseKt.access$getSUFFIXES$p()) {
            if (!StringsKt.endsWith$default((String)result2, (String)suffix, (boolean)false, (int)2, null)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string = result2.substring(0, result2.length() - suffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return stringBuilder.append(string).append("\ud83d\udd05").append(suffix).toString();
        }
        return result2 + suffixToAppend;
    }

    @JvmStatic
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String replaceMnemonicAmpersand(@Nullable String value2) {
        if (value2 == null || !StringsKt.contains$default((CharSequence)value2, (char)'&', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)value2, (char)'\u001b', (boolean)false, (int)2, null)) {
            return value2;
        }
        StringBuilder builder2 = new StringBuilder();
        boolean macMnemonic = StringsKt.contains$default((CharSequence)value2, (CharSequence)"&&", (boolean)false, (int)2, null);
        boolean mnemonicAdded = false;
        block4: for (int i = 0; i < value2.length(); ++i) {
            char c = value2.charAt(i);
            switch (c) {
                case '\\': {
                    Comparable<StringBuilder> comparable;
                    if (i < value2.length() - 1 && value2.charAt(i + 1) == '&') {
                        builder2.append('&');
                        comparable = i++;
                        continue block4;
                    }
                    comparable = builder2.append(c);
                    continue block4;
                }
                case '&': {
                    if (i < value2.length() - 1 && value2.charAt(i + 1) == '&') {
                        if (SystemInfoRt.isMac && !mnemonicAdded) {
                            mnemonicAdded = true;
                            builder2.append('\u001b');
                        }
                        ++i;
                    } else if (!(SystemInfoRt.isMac && macMnemonic || mnemonicAdded)) {
                        mnemonicAdded = true;
                        builder2.append('\u001b');
                    }
                    Comparable<StringBuilder> comparable = Unit.INSTANCE;
                    continue block4;
                }
                default: {
                    Comparable<StringBuilder> comparable = builder2.append(c);
                }
            }
        }
        return builder2.toString();
    }
}

