/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCoreKt;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\u00042\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0007\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0007\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u00a8\u0006\u0011"}, d2={"tryReadPluginIdsFromFile", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId;", "path", "Ljava/nio/file/Path;", "log", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "readPluginIdsFromFile", "getPluginDistDirByClass", "aClass", "Ljava/lang/Class;", "pluginRequiresUltimatePluginButItsDisabled", "", "plugin", "pluginMap", "", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nPluginManagerCore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManagerCore.kt\ncom/intellij/ide/plugins/PluginManagerCoreKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1114:1\n1#2:1115\n*E\n"})
public final class PluginManagerCoreKt {
    @ApiStatus.Internal
    @NotNull
    public static final synchronized Set<PluginId> tryReadPluginIdsFromFile(@NotNull Path path, @NotNull Logger log2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        try {
            return PluginManagerCoreKt.readPluginIdsFromFile(path);
        }
        catch (IOException e) {
            log2.warn("Unable to read plugin id list from: " + path, e);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized Set<PluginId> readPluginIdsFromFile(Path path) {
        Object object;
        try {
            Set set;
            object = Files.lines(path);
            Throwable throwable = null;
            try {
                Stream lines = (Stream)object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)lines);
                set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)lines), (Function1)readPluginIdsFromFile.1.1.INSTANCE), PluginManagerCoreKt::readPluginIdsFromFile$lambda$2$lambda$0), PluginManagerCoreKt::readPluginIdsFromFile$lambda$2$lambda$1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = set;
        }
        catch (NoSuchFileException noSuchFileException) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    private static final boolean readPluginIdsFromFile$lambda$2$lambda$0(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return !(((CharSequence)line).length() == 0);
    }

    private static final PluginId readPluginIdsFromFile$lambda$2$lambda$1(String idString) {
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        return PluginId.getId(idString);
    }
}

