/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public final class PsiBuilderUtil {
    public static void advance(PsiBuilder builder2, int count) {
        for (int i = 0; i < count && !builder2.eof(); ++i) {
            builder2.getTokenType();
            builder2.advanceLexer();
        }
    }

    public static boolean expect(PsiBuilder builder2, IElementType expectedType) {
        if (builder2.getTokenType() == expectedType) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean expect(PsiBuilder builder2, TokenSet expectedTypes) {
        if (expectedTypes.contains(builder2.getTokenType())) {
            builder2.advanceLexer();
            return true;
        }
        return false;
    }

    public static void drop(PsiBuilder.Marker ... markers) {
        for (PsiBuilder.Marker marker : markers) {
            if (marker == null) continue;
            marker.drop();
        }
    }

    public static void rollbackTo(@Nullable PsiBuilder.Marker marker) {
        if (marker != null) {
            marker.rollbackTo();
        }
    }

    @Nullable
    public static PsiBuilder.Marker parseBlockLazy(@NotNull PsiBuilder builder2, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace, @NotNull IElementType codeBlock) {
        if (builder2 == null) {
            PsiBuilderUtil.$$$reportNull$$$0(0);
        }
        if (leftBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(1);
        }
        if (rightBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(2);
        }
        if (codeBlock == null) {
            PsiBuilderUtil.$$$reportNull$$$0(3);
        }
        if (builder2.getTokenType() != leftBrace) {
            return null;
        }
        PsiBuilder.Marker marker = builder2.mark();
        builder2.advanceLexer();
        int braceCount = 1;
        while (braceCount > 0 && !builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == leftBrace) {
                ++braceCount;
            } else if (tokenType == rightBrace) {
                --braceCount;
            }
            builder2.advanceLexer();
        }
        marker.collapse(codeBlock);
        if (braceCount > 0) {
            marker.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return marker;
    }

    public static boolean hasProperBraceBalance(@NotNull CharSequence text, @NotNull Lexer lexer, @NotNull IElementType leftBrace, @NotNull IElementType rightBrace) {
        if (text == null) {
            PsiBuilderUtil.$$$reportNull$$$0(4);
        }
        if (lexer == null) {
            PsiBuilderUtil.$$$reportNull$$$0(5);
        }
        if (leftBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(6);
        }
        if (rightBrace == null) {
            PsiBuilderUtil.$$$reportNull$$$0(7);
        }
        lexer.start(text);
        if (lexer.getTokenType() != leftBrace) {
            return false;
        }
        lexer.advance();
        int balance = 1;
        while (true) {
            ProgressManager.checkCanceled();
            IElementType type = lexer.getTokenType();
            if (type == null) {
                return balance == 0;
            }
            if (balance == 0) {
                return false;
            }
            if (type == leftBrace) {
                ++balance;
            } else if (type == rightBrace) {
                --balance;
            }
            lexer.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBrace";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/PsiBuilderUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBlockLazy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasProperBraceBalance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

