/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParserUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AbstractBasicJavaDocElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public final class BasicJavaDocParser {
    private static final TokenSet TAG_VALUES_SET = TokenSet.create(JavaDocTokenType.DOC_TAG_VALUE_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_COMMA, JavaDocTokenType.DOC_TAG_VALUE_DOT, JavaDocTokenType.DOC_TAG_VALUE_LPAREN, JavaDocTokenType.DOC_TAG_VALUE_RPAREN, JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN, JavaDocTokenType.DOC_TAG_VALUE_LT, JavaDocTokenType.DOC_TAG_VALUE_GT, JavaDocTokenType.DOC_TAG_VALUE_COLON, JavaDocTokenType.DOC_TAG_VALUE_QUOTE);
    private static final TokenSet INLINE_TAG_BORDERS_SET = TokenSet.create(JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END);
    private static final TokenSet SKIP_TOKENS = TokenSet.create(JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS);
    private static final Set<String> REFERENCE_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("@throws", "@exception", "@provides", "@uses")));
    private static final Key<Integer> BRACE_SCOPE_KEY = Key.create("Javadoc.Parser.Brace.Scope");

    private BasicJavaDocParser() {
    }

    public static void parseJavadocReference(@NotNull PsiBuilder builder2, @NotNull BasicJavaParser parser) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(1);
        }
        parser.getReferenceParser().parseJavaCodeReference(builder2, true, true, false, false);
        BasicJavaDocParser.swallowTokens(builder2);
    }

    public static void parseJavadocType(@NotNull PsiBuilder builder2, @NotNull BasicJavaParser parser) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            BasicJavaDocParser.$$$reportNull$$$0(3);
        }
        parser.getReferenceParser().parseType(builder2, 7);
        BasicJavaDocParser.swallowTokens(builder2);
    }

    private static void swallowTokens(PsiBuilder builder2) {
        while (!builder2.eof()) {
            builder2.advanceLexer();
        }
    }

    public static void parseDocCommentText(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(4);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(5);
        }
        builder2.enforceCommentTokens(SKIP_TOKENS);
        while (!builder2.eof()) {
            IElementType tokenType = BasicJavaDocParser.getTokenType(builder2);
            if (tokenType == JavaDocTokenType.DOC_TAG_NAME) {
                BasicJavaDocParser.parseTag(builder2, javaDocElementTypeContainer);
                continue;
            }
            BasicJavaDocParser.parseDataItem(builder2, null, false, javaDocElementTypeContainer);
        }
    }

    private static void parseTag(PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(6);
        }
        String tagName = builder2.getTokenText();
        PsiBuilder.Marker tag = builder2.mark();
        builder2.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder2)) != null && tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_END) {
            BasicJavaDocParser.parseDataItem(builder2, tagName, false, javaDocElementTypeContainer);
        }
        tag.done(javaDocElementTypeContainer.DOC_TAG);
    }

    private static void parseDataItem(PsiBuilder builder2, @Nullable String tagName, boolean isInline, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(7);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_INLINE_TAG_START) {
            int braceScope = BasicJavaDocParser.getBraceScope(builder2);
            if (braceScope > 0) {
                BasicJavaDocParser.setBraceScope(builder2, braceScope + 1);
                builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder2.advanceLexer();
                return;
            }
            PsiBuilder.Marker tag = builder2.mark();
            builder2.advanceLexer();
            tokenType = BasicJavaDocParser.getTokenType(builder2);
            if (tokenType != JavaDocTokenType.DOC_TAG_NAME && tokenType != JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
                builder2.advanceLexer();
                return;
            }
            BasicJavaDocParser.setBraceScope(builder2, braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_TAG_NAME) {
                    inlineTagName = builder2.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocTokenType.DOC_COMMENT_END) break;
                BasicJavaDocParser.parseDataItem(builder2, inlineTagName, true, javaDocElementTypeContainer);
                if (tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = BasicJavaDocParser.getBraceScope(builder2);
                if (braceScope > 0) {
                    BasicJavaDocParser.setBraceScope(builder2, --braceScope);
                }
                if (braceScope == 0) break;
            }
            if ("@snippet".equals(inlineTagName)) {
                tag.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG);
            } else {
                tag.done(javaDocElementTypeContainer.DOC_INLINE_TAG);
            }
        } else if (TAG_VALUES_SET.contains(tokenType)) {
            if ("@see".equals(tagName) && !isInline || "@link".equals(tagName) && isInline || BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_1_4) && "@linkplain".equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder2, false, javaDocElementTypeContainer);
            } else if (!isInline && tagName != null && REFERENCE_TAGS.contains(tagName)) {
                PsiBuilder.Marker tagValue = builder2.mark();
                builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
                builder2.advanceLexer();
                tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
            } else if (!isInline && "@param".equals(tagName)) {
                BasicJavaDocParser.parseParameterRef(builder2, javaDocElementTypeContainer);
            } else if (BasicJavaParserUtil.getLanguageLevel(builder2).isAtLeast(LanguageLevel.JDK_1_5) && "@value".equals(tagName) && isInline) {
                BasicJavaDocParser.parseSeeTagValue(builder2, true, javaDocElementTypeContainer);
            } else if ("@snippet".equals(tagName) && isInline) {
                BasicJavaDocParser.parseSnippetTagValue(builder2, javaDocElementTypeContainer);
            } else {
                BasicJavaDocParser.parseSimpleTagValue(builder2, javaDocElementTypeContainer);
            }
        } else if (tokenType == JavaDocTokenType.DOC_INLINE_CODE_FENCE) {
            BasicJavaDocParser.parseInlineCodeBlock(builder2, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_CODE_FENCE) {
            BasicJavaDocParser.parseCodeBlock(builder2, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_LBRACKET) {
            BasicJavaDocParser.parseMarkdownReferenceChecked(builder2, javaDocElementTypeContainer);
        } else {
            BasicJavaDocParser.remapAndAdvance(builder2);
        }
    }

    private static void parseInlineCodeBlock(PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(8);
        }
        PsiBuilder.Marker tag = builder2.mark();
        IElementType stopElementType = BasicJavaDocParser.findInlineToken(builder2, JavaDocTokenType.DOC_INLINE_CODE_FENCE);
        int endOffset = builder2.getCurrentOffset();
        tag.rollbackTo();
        if (stopElementType != JavaDocTokenType.DOC_INLINE_CODE_FENCE) {
            builder2.advanceLexer();
            return;
        }
        tag = builder2.mark();
        builder2.advanceLexer();
        while (builder2.getCurrentOffset() < endOffset && !builder2.eof()) {
            builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
            builder2.advanceLexer();
        }
        if (!builder2.eof()) {
            builder2.advanceLexer();
        }
        tag.done(javaDocElementTypeContainer.DOC_MARKDOWN_CODE_BLOCK);
    }

    private static void parseCodeBlock(PsiBuilder builder2,  @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(9);
        }
        if (BasicJavaDocParser.getBraceScope(builder2) > 0) {
            builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
            builder2.advanceLexer();
            return;
        }
        char fenceStart = builder2.getTokenText().charAt(0);
        PsiBuilder.Marker tag = builder2.mark();
        while (!builder2.eof()) {
            builder2.advanceLexer();
            if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_CODE_FENCE && builder2.getTokenText().charAt(0) == fenceStart) break;
            builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        if (!builder2.eof()) {
            builder2.advanceLexer();
        }
        tag.done(javaDocElementTypeContainer.DOC_MARKDOWN_CODE_BLOCK);
    }

    private static void parseMarkdownReferenceChecked(PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        int endLabelOffset;
        boolean isShortRefEmpty;
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(10);
        }
        boolean hasLabel = true;
        PsiBuilder.Marker tag = builder2.mark();
        int leftBracketCount = 1;
        int rightBracketCount = 0;
        int startLabelOffset = builder2.getCurrentOffset();
        while (!builder2.eof()) {
            IElementType token = BasicJavaDocParser.findInlineToken(builder2, JavaDocTokenType.DOC_RBRACKET, JavaDocTokenType.DOC_LBRACKET, true);
            if (token == JavaDocTokenType.DOC_LBRACKET) {
                ++leftBracketCount;
                continue;
            }
            if (token != JavaDocTokenType.DOC_RBRACKET || leftBracketCount != ++rightBracketCount) continue;
            break;
        }
        boolean bl = isShortRefEmpty = (endLabelOffset = builder2.getCurrentOffset()) - startLabelOffset <= 1;
        if (leftBracketCount != rightBracketCount || isShortRefEmpty) {
            tag.rollbackTo();
            builder2.advanceLexer();
            return;
        }
        IElementType firstReferenceToken = BasicJavaDocParser.findInlineToken(builder2, JavaDocTokenType.DOC_LBRACKET, JavaDocTokenType.DOC_SPACE, false);
        if (firstReferenceToken != JavaDocTokenType.DOC_LBRACKET) {
            hasLabel = false;
            if (leftBracketCount > 1 || firstReferenceToken == JavaDocTokenType.DOC_LPAREN) {
                tag.rollbackTo();
                builder2.advanceLexer();
                return;
            }
        }
        if (hasLabel && BasicJavaDocParser.findInlineToken(builder2, JavaDocTokenType.DOC_RBRACKET, JavaDocTokenType.DOC_LBRACKET, true) != JavaDocTokenType.DOC_RBRACKET) {
            hasLabel = false;
            if (leftBracketCount > 1) {
                tag.rollbackTo();
                builder2.advanceLexer();
                return;
            }
        }
        tag.rollbackTo();
        tag = builder2.mark();
        if (hasLabel) {
            while (!builder2.eof()) {
                builder2.advanceLexer();
                if (builder2.getCurrentOffset() >= endLabelOffset) break;
                builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
            }
            builder2.advanceLexer();
        }
        builder2.advanceLexer();
        BasicJavaDocParser.parseMarkdownReference(builder2, javaDocElementTypeContainer);
        builder2.advanceLexer();
        tag.done(javaDocElementTypeContainer.DOC_MARKDOWN_REFERENCE_LINK);
    }

    private static void parseMarkdownReference(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(11);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(12);
        }
        PsiBuilder.Marker refStart = builder2.mark();
        if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_RBRACKET) {
            refStart.drop();
            return;
        }
        if (BasicJavaDocParser.getTokenType(builder2) != JavaDocTokenType.DOC_SHARP) {
            builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
            builder2.advanceLexer();
        }
        if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_SHARP) {
            builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN);
            builder2.advanceLexer();
            builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            builder2.advanceLexer();
            if (builder2.getTokenType() == JavaDocTokenType.DOC_LPAREN) {
                builder2.advanceLexer();
                PsiBuilder.Marker subValue = builder2.mark();
                while (!builder2.eof()) {
                    IElementType type = BasicJavaDocParser.getTokenType(builder2);
                    if (type == JavaDocTokenType.DOC_COMMENT_DATA) {
                        builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_TYPE_HOLDER);
                    } else if (type != JavaDocTokenType.DOC_COMMA) break;
                    builder2.advanceLexer();
                }
                if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_RPAREN) {
                    subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
                    builder2.advanceLexer();
                } else {
                    subValue.drop();
                }
            }
            refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        refStart.drop();
    }

    @Nullable
    private static IElementType findInlineToken(@NotNull PsiBuilder builder2, IElementType needle) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(13);
        }
        return BasicJavaDocParser.findInlineToken(builder2, needle, null, false);
    }

    @Contract(mutates="param1")
    @Nullable
    private static IElementType findInlineToken(@NotNull PsiBuilder builder2, IElementType needle, @Nullable IElementType travelToken, boolean isTravelTokenDisallowed) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(14);
        }
        IElementType token = null;
        while (!builder2.eof()) {
            boolean travelTokenFound;
            builder2.advanceLexer();
            IElementType previousToken = token;
            token = BasicJavaDocParser.getTokenType(builder2, false);
            if (token == needle) {
                return token;
            }
            boolean bl = travelTokenFound = travelToken == token;
            if (!(travelToken != null && (isTravelTokenDisallowed && travelTokenFound || !isTravelTokenDisallowed && !travelTokenFound)) && (token != TokenType.WHITE_SPACE || previousToken != TokenType.WHITE_SPACE)) continue;
            break;
        }
        return builder2.eof() ? null : token;
    }

    private static void parseSnippetTagValue(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType token;
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(15);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(16);
        }
        PsiBuilder.Marker snippetValue = builder2.mark();
        snippetValue.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        while ((token = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
            builder2.advanceLexer();
        }
        IElementType tokenType = BasicJavaDocParser.getTokenType(builder2);
        if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
            BasicJavaParserUtil.emptyElement(builder2, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            BasicJavaDocParser.parseSnippetTagBody(builder2, javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            BasicJavaDocParser.parseSnippetAttributeList(builder2, javaDocElementTypeContainer);
            if (builder2.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_COLON) {
                BasicJavaDocParser.parseSnippetTagBody(builder2, javaDocElementTypeContainer);
            }
        } else {
            BasicJavaParserUtil.emptyElement(builder2, javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
            IElementType current = BasicJavaDocParser.getTokenType(builder2);
            while (current != null && current != JavaDocTokenType.DOC_INLINE_TAG_END) {
                builder2.advanceLexer();
                current = BasicJavaDocParser.getTokenType(builder2);
            }
        }
        snippetValue.done(javaDocElementTypeContainer.DOC_SNIPPET_TAG_VALUE);
    }

    private static void parseSnippetTagBody(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(17);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(18);
        }
        PsiBuilder.Marker body = builder2.mark();
        body.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        assert (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_COLON);
        builder2.advanceLexer();
        while ((tokenType = BasicJavaDocParser.getTokenType(builder2)) != null && tokenType != JavaDocTokenType.DOC_INLINE_TAG_END) {
            builder2.advanceLexer();
        }
        body.done(javaDocElementTypeContainer.DOC_SNIPPET_BODY);
    }

    private static void parseSnippetAttributeList(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(19);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(20);
        }
        PsiBuilder.Marker attributeList = builder2.mark();
        block0: while (true) {
            IElementType type = BasicJavaDocParser.getTokenType(builder2);
            while (type != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                if (type != JavaDocTokenType.DOC_TAG_VALUE_QUOTE) break block0;
                builder2.advanceLexer();
                type = BasicJavaDocParser.getTokenType(builder2);
            }
            BasicJavaDocParser.parseSnippetAttribute(builder2, javaDocElementTypeContainer);
        }
        attributeList.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_LIST);
    }

    private static void parseSnippetAttribute(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(21);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(22);
        }
        PsiBuilder.Marker attribute = builder2.mark();
        assert (builder2.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
        builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_ATTRIBUTE_NAME);
        builder2.advanceLexer();
        BasicJavaDocParser.getTokenType(builder2);
        if ("=".equals(builder2.getTokenText())) {
            builder2.advanceLexer();
            IElementType afterEqToken = BasicJavaDocParser.getTokenType(builder2);
            if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                PsiBuilder.Marker quotedValue = builder2.mark();
                builder2.advanceLexer();
                if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder2.advanceLexer();
                }
                if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_QUOTE) {
                    builder2.advanceLexer();
                }
                quotedValue.collapse(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
            } else if (afterEqToken == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE_VALUE);
                builder2.advanceLexer();
            }
        }
        attribute.done(javaDocElementTypeContainer.DOC_SNIPPET_ATTRIBUTE);
    }

    private static void parseSeeTagValue(@NotNull PsiBuilder builder2, boolean allowBareFieldReference, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        IElementType tokenType;
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(23);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(24);
        }
        if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            BasicJavaDocParser.parseMethodRef(builder2, builder2.mark(), javaDocElementTypeContainer);
        } else if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            PsiBuilder.Marker refStart = builder2.mark();
            builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_REFERENCE_HOLDER);
            builder2.advanceLexer();
            if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                BasicJavaDocParser.parseMethodRef(builder2, refStart, javaDocElementTypeContainer);
            } else if (allowBareFieldReference) {
                refStart.rollbackTo();
                builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
                BasicJavaDocParser.parseMethodRef(builder2, builder2.mark(), javaDocElementTypeContainer);
            } else {
                refStart.drop();
            }
        } else {
            PsiBuilder.Marker tagValue = builder2.mark();
            builder2.advanceLexer();
            tagValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
    }

    private static void parseMethodRef(@NotNull PsiBuilder builder2, @NotNull PsiBuilder.Marker refStart, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(25);
        }
        if (refStart == null) {
            BasicJavaDocParser.$$$reportNull$$$0(26);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(27);
        }
        if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            builder2.advanceLexer();
        }
        if (BasicJavaDocParser.getTokenType(builder2) != JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        builder2.advanceLexer();
        if (BasicJavaDocParser.getTokenType(builder2) == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
            IElementType tokenType;
            builder2.advanceLexer();
            PsiBuilder.Marker subValue = builder2.mark();
            while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder2))) {
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN) {
                    builder2.remapCurrentToken(javaDocElementTypeContainer.DOC_TYPE_HOLDER);
                    builder2.advanceLexer();
                    while (TAG_VALUES_SET.contains(tokenType = BasicJavaDocParser.getTokenType(builder2)) && tokenType != JavaDocTokenType.DOC_TAG_VALUE_COMMA && tokenType != JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                        builder2.advanceLexer();
                    }
                    continue;
                }
                if (tokenType == JavaDocTokenType.DOC_TAG_VALUE_RPAREN) {
                    subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
                    builder2.advanceLexer();
                    refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                builder2.advanceLexer();
            }
            subValue.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
        }
        refStart.done(javaDocElementTypeContainer.DOC_METHOD_OR_FIELD_REF);
    }

    private static void parseParameterRef(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(28);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(29);
        }
        PsiBuilder.Marker tagValue = builder2.mark();
        while (TAG_VALUES_SET.contains(BasicJavaDocParser.getTokenType(builder2))) {
            builder2.advanceLexer();
        }
        tagValue.done(javaDocElementTypeContainer.DOC_PARAMETER_REF);
    }

    private static void parseSimpleTagValue(@NotNull PsiBuilder builder2, @NotNull AbstractBasicJavaDocElementTypeFactory.JavaDocElementTypeContainer javaDocElementTypeContainer) {
        if (builder2 == null) {
            BasicJavaDocParser.$$$reportNull$$$0(30);
        }
        if (javaDocElementTypeContainer == null) {
            BasicJavaDocParser.$$$reportNull$$$0(31);
        }
        PsiBuilder.Marker tagData = builder2.mark();
        while (true) {
            IElementType tokenType;
            if ((tokenType = BasicJavaDocParser.getTokenType(builder2)) == JavaDocTokenType.DOC_COMMENT_BAD_CHARACTER) {
                builder2.remapCurrentToken(JavaDocTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!TAG_VALUES_SET.contains(tokenType)) break;
            builder2.advanceLexer();
        }
        tagData.done(javaDocElementTypeContainer.DOC_TAG_VALUE_ELEMENT);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder2) {
        return BasicJavaDocParser.getTokenType(builder2, true);
    }

    @Nullable
    private static IElementType getTokenType(PsiBuilder builder2, boolean skipWhitespace) {
        IElementType tokenType;
        while ((tokenType = builder2.getTokenType()) == JavaDocTokenType.DOC_SPACE) {
            builder2.remapCurrentToken(TokenType.WHITE_SPACE);
            if (!skipWhitespace) continue;
            builder2.advanceLexer();
        }
        return tokenType;
    }

    private static int getBraceScope(PsiBuilder builder2) {
        Integer braceScope = builder2.getUserData(BRACE_SCOPE_KEY);
        return braceScope != null ? braceScope : 0;
    }

    private static void setBraceScope(PsiBuilder builder2, int braceScope) {
        builder2.putUserData(BRACE_SCOPE_KEY, braceScope);
    }

    private static void remapAndAdvance(PsiBuilder builder2) {
        if (INLINE_TAG_BORDERS_SET.contains(builder2.getTokenType()) && BasicJavaDocParser.getBraceScope(builder2) != 1) {
            builder2.remapCurrentToken(JavaDocTokenType.DOC_COMMENT_DATA);
        }
        builder2.advanceLexer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaDocElementTypeContainer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refStart";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicJavaDocParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseJavadocType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDocCommentText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseTag";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDataItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInlineCodeBlock";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "parseCodeBlock";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMarkdownReferenceChecked";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMarkdownReference";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findInlineToken";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetTagBody";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttributeList";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSnippetAttribute";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSeeTagValue";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "parseMethodRef";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "parseParameterRef";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "parseSimpleTagValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

