/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LighterLazyParseableNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderFactory;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderAdapter;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.BasicJavaLexer;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.JavaDocLexer;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.lexer.TokenList;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.ParsingDiagnostics;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexingDataKeys;

@ApiStatus.Experimental
public final class BasicJavaParserUtil {
    private static final Key<LanguageLevel> LANG_LEVEL_KEY = Key.create("JavaParserUtil.LanguageLevel");
    private static final Key<Boolean> DEEP_PARSE_BLOCKS_IN_STATEMENTS = Key.create("JavaParserUtil.ParserExtender");

    private BasicJavaParserUtil() {
    }

    public static void setLanguageLevel(PsiBuilder builder2, LanguageLevel level) {
        builder2.putUserData(LANG_LEVEL_KEY, level);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(PsiBuilder builder2) {
        LanguageLevel level = builder2.getUserData(LANG_LEVEL_KEY);
        assert (level != null) : builder2;
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(0);
        }
        return languageLevel;
    }

    public static boolean isParseStatementCodeBlocksDeep(PsiBuilder builder2) {
        return Boolean.TRUE.equals(builder2.getUserData(DEEP_PARSE_BLOCKS_IN_STATEMENTS));
    }

    public static void done(@NotNull PsiBuilder.Marker marker, @NotNull IElementType type, @NotNull PsiBuilder builder2, @NotNull WhiteSpaceAndCommentSetHolder commentSetHolder) {
        if (marker == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(4);
        }
        if (type == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(5);
        }
        if (builder2 == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(6);
        }
        if (commentSetHolder == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(7);
        }
        marker.done(type);
        WhitespacesAndCommentsBinder left = commentSetHolder.getPrecedingCommentSet().contains(type) ? commentSetHolder.getPrecedingCommentBinder(BasicJavaParserUtil.getLanguageLevel(builder2)) : null;
        WhitespacesAndCommentsBinder right = commentSetHolder.getTrailingCommentSet().contains(type) ? commentSetHolder.getTrailingCommentBinder() : null;
        marker.setCustomEdgeTokenBinders(left, right);
    }

    @Nullable
    public static IElementType exprType(@Nullable PsiBuilder.Marker marker) {
        return marker != null ? marker.getTokenType() : null;
    }

    public static void error(PsiBuilder builder2, @NotNull String message2) {
        if (message2 == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(8);
        }
        builder2.mark().error(message2);
    }

    public static void error(PsiBuilder builder2, @NotNull String message2, @Nullable PsiBuilder.Marker before) {
        if (message2 == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(9);
        }
        if (before == null) {
            BasicJavaParserUtil.error(builder2, message2);
        } else {
            before.precede().errorBefore(message2, before);
        }
    }

    public static boolean expectOrError(PsiBuilder builder2, IElementType expected, @PropertyKey(resourceBundle="messages.JavaPsiBundle") @PropertyKey(resourceBundle="messages.JavaPsiBundle") String key) {
        if (!PsiBuilderUtil.expect(builder2, expected)) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message(key, new Object[0]));
            return false;
        }
        return true;
    }

    public static void emptyElement(PsiBuilder builder2, IElementType type) {
        builder2.mark().done(type);
    }

    public static void emptyElement(PsiBuilder.Marker before, IElementType type) {
        before.precede().doneBefore(type, before);
    }

    public static void semicolon(PsiBuilder builder2) {
        BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.SEMICOLON, "expected.semicolon");
    }

    public static PsiBuilder braceMatchingBuilder(PsiBuilder builder2) {
        PsiBuilder.Marker pos = builder2.mark();
        int braceCount = 1;
        while (!builder2.eof()) {
            IElementType tokenType = builder2.getTokenType();
            if (tokenType == JavaTokenType.LBRACE) {
                ++braceCount;
            } else if (tokenType == JavaTokenType.RBRACE) {
                --braceCount;
            }
            if (braceCount == 0) break;
            builder2.advanceLexer();
        }
        int stopAt = builder2.getCurrentOffset();
        pos.rollbackTo();
        return BasicJavaParserUtil.stoppingBuilder(builder2, stopAt);
    }

    public static PsiBuilder stoppingBuilder(PsiBuilder builder2, final int stopAt) {
        return new PsiBuilderAdapter(builder2){

            @Override
            public IElementType getTokenType() {
                return this.getCurrentOffset() < stopAt ? super.getTokenType() : null;
            }

            @Override
            public boolean eof() {
                return this.getCurrentOffset() >= stopAt || super.eof();
            }
        };
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper, Function<LanguageLevel, JavaDocLexer> javaDocLexer, Function<LanguageLevel, BasicJavaLexer> javaLexer) {
        return BasicJavaParserUtil.parseFragment(chameleon, wrapper, true, LanguageLevel.HIGHEST, javaDocLexer, javaLexer);
    }

    @Nullable
    public static ASTNode parseFragment(ASTNode chameleon, ParserWrapper wrapper, boolean eatAll, LanguageLevel level, Function<LanguageLevel, JavaDocLexer> javaDocLexer, Function<LanguageLevel, ? extends Lexer> javaLexer) {
        PsiElement psi;
        PsiElement psiElement = psi = chameleon.getTreeParent() != null ? chameleon.getTreeParent().getPsi() : chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        Lexer lexer = BasicJavaAstTreeUtil.is(chameleon, BasicJavaDocElementType.BASIC_DOC_COMMENT) ? (Lexer)javaDocLexer.apply(level) : javaLexer.apply(level);
        PsiBuilder builder2 = factory.createBuilder(project, chameleon, lexer, chameleon.getElementType().getLanguage(), chameleon.getChars());
        BasicJavaParserUtil.setLanguageLevel(builder2, level);
        long startTime = System.nanoTime();
        PsiBuilder.Marker root = builder2.mark();
        wrapper.parse(builder2);
        if (!builder2.eof()) {
            if (!eatAll) {
                throw new AssertionError((Object)("Unexpected token: '" + builder2.getTokenText() + "'"));
            }
            PsiBuilder.Marker extras = builder2.mark();
            while (!builder2.eof()) {
                builder2.advanceLexer();
            }
            extras.error(JavaPsiBundle.message("unexpected.tokens", new Object[0]));
        }
        root.done(chameleon.getElementType());
        ASTNode result2 = builder2.getTreeBuilt().getFirstChildNode();
        ParsingDiagnostics.registerParse(builder2, chameleon.getElementType().getLanguage(), System.nanoTime() - startTime);
        return result2;
    }

    @NotNull
    public static PsiBuilder createBuilder(@NotNull ASTNode chameleon, @NotNull Function<PsiElement, LanguageLevel> languageLevelFunction, @NotNull Function<LanguageLevel, BasicJavaLexer> lexerFunction, @NotNull Function<PsiFile, TokenList> psiAsLexer) {
        CharSequence text;
        if (chameleon == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(10);
        }
        if (languageLevelFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(11);
        }
        if (lexerFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(12);
        }
        if (psiAsLexer == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(13);
        }
        PsiElement psi = chameleon.getPsi();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        CharSequence indexedText = psi.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (TreeUtil.isCollapsedChameleon(chameleon)) {
            text = chameleon.getChars();
        } else {
            text = indexedText;
            if (text == null) {
                text = chameleon.getChars();
            }
        }
        LanguageLevel level = languageLevelFunction.apply(psi);
        Lexer lexer = psi instanceof PsiFile && indexedText != null ? psiAsLexer.apply((PsiFile)psi).asLexer() : (Lexer)lexerFunction.apply(level);
        Language language = psi.getLanguage();
        if (!language.isKindOf(JavaLanguage.INSTANCE)) {
            language = JavaLanguage.INSTANCE;
        }
        PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, lexer, language, text);
        BasicJavaParserUtil.setLanguageLevel(builder2, level);
        PsiBuilder psiBuilder = builder2;
        if (psiBuilder == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(14);
        }
        return psiBuilder;
    }

    @NotNull
    public static PsiBuilder createBuilder(@NotNull LighterLazyParseableNode chameleon, @NotNull Function<PsiElement, LanguageLevel> languageLevelFunction, @NotNull Function<LanguageLevel, BasicJavaLexer> lexerFunction) {
        if (chameleon == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(15);
        }
        if (languageLevelFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(16);
        }
        if (lexerFunction == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(17);
        }
        PsiFile psi = chameleon.getContainingFile();
        assert (psi != null) : chameleon;
        Project project = psi.getProject();
        PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
        LanguageLevel level = languageLevelFunction.apply(psi);
        Lexer lexer = lexerFunction.apply(level);
        PsiBuilder builder2 = factory.createBuilder(project, chameleon, lexer, chameleon.getTokenType().getLanguage(), chameleon.getText());
        BasicJavaParserUtil.setLanguageLevel(builder2, level);
        PsiBuilder psiBuilder = builder2;
        if (psiBuilder == null) {
            BasicJavaParserUtil.$$$reportNull$$$0(18);
        }
        return psiBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicJavaParserUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentSetHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelFunction";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexerFunction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAsLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicJavaParserUtil";
                break;
            }
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "done";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ParserWrapper {
        public void parse(PsiBuilder var1);
    }
}

