/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.SyntaxTreeBuilder;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParserUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class BasicModuleParser {
    private static final Set<String> STATEMENT_KEYWORDS = ContainerUtil.newHashSet("requires", "exports", "uses", "provides");
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicModuleParser(@NotNull BasicJavaParser parser) {
        if (parser == null) {
            BasicModuleParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = parser;
        this.myJavaElementTypeContainer = parser.getJavaElementTypeFactory().getContainer();
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder2) {
        PsiBuilder.Marker modifierList2;
        String text;
        if (builder2 == null) {
            BasicModuleParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker module2 = builder2.mark();
        PsiBuilder.Marker firstAnnotation = this.myParser.getDeclarationParser().parseAnnotations(builder2);
        IElementType type = builder2.getTokenType();
        String string = text = type == JavaTokenType.IDENTIFIER ? builder2.getTokenText() : null;
        if (!"open".equals(text) && !"module".equals(text)) {
            module2.rollbackTo();
            return null;
        }
        PsiBuilder.Marker marker = modifierList2 = firstAnnotation != null ? firstAnnotation.precede() : builder2.mark();
        if ("open".equals(text)) {
            BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.OPEN_KEYWORD);
            text = builder2.getTokenText();
        }
        BasicJavaParserUtil.done(modifierList2, this.myJavaElementTypeContainer.MODIFIER_LIST, builder2, this.myWhiteSpaceAndCommentSetHolder);
        if (!"module".equals(text)) {
            module2.drop();
            BasicModuleParser.parseExtras(builder2, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            return module2;
        }
        BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.MODULE_KEYWORD);
        if (this.parseName(builder2) == null) {
            module2.drop();
            if (builder2.getTokenType() != null) {
                BasicModuleParser.parseExtras(builder2, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            return module2;
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LBRACE)) {
            if (builder2.getTokenType() != null) {
                BasicModuleParser.parseExtras(builder2, JavaPsiBundle.message("expected.module.declaration", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        } else {
            this.parseModuleContent(builder2);
        }
        BasicJavaParserUtil.done(module2, this.myJavaElementTypeContainer.MODULE, builder2, this.myWhiteSpaceAndCommentSetHolder);
        if (builder2.getTokenType() != null) {
            BasicModuleParser.parseExtras(builder2, JavaPsiBundle.message("unexpected.tokens", new Object[0]));
        }
        return module2;
    }

    public PsiBuilder.Marker parseName(PsiBuilder builder2) {
        PsiBuilder.Marker nameElement = builder2.mark();
        boolean empty = true;
        boolean idExpected = true;
        while (true) {
            IElementType t;
            if ((t = builder2.getTokenType()) == JavaTokenType.IDENTIFIER) {
                if (!idExpected) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.dot", new Object[0]));
                }
                idExpected = false;
            } else {
                if (t != JavaTokenType.DOT) break;
                if (idExpected) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                idExpected = true;
            }
            builder2.advanceLexer();
            empty = false;
        }
        if (!empty) {
            if (idExpected) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            nameElement.done(this.myJavaElementTypeContainer.MODULE_REFERENCE);
            return nameElement;
        }
        nameElement.drop();
        return null;
    }

    private void parseModuleContent(PsiBuilder builder2) {
        IElementType token;
        SyntaxTreeBuilder.Marker invalid = null;
        while ((token = builder2.getTokenType()) != null && token != JavaTokenType.RBRACE) {
            if (token == JavaTokenType.SEMICOLON) {
                if (invalid != null) {
                    invalid.error(JavaPsiBundle.message("expected.module.statement", new Object[0]));
                    invalid = null;
                }
                builder2.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseStatement(builder2);
            if (statement == null) {
                if (invalid == null) {
                    invalid = builder2.mark();
                }
                builder2.advanceLexer();
                continue;
            }
            if (invalid == null) continue;
            invalid.errorBefore(JavaPsiBundle.message("expected.module.statement", new Object[0]), statement);
            invalid = null;
        }
        if (invalid != null) {
            invalid.error(JavaPsiBundle.message("expected.module.statement", new Object[0]));
        }
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RBRACE) && invalid == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.rbrace", new Object[0]));
        }
    }

    private PsiBuilder.Marker parseStatement(PsiBuilder builder2) {
        String kw = builder2.getTokenText();
        if ("requires".equals(kw)) {
            return this.parseRequiresStatement(builder2);
        }
        if ("exports".equals(kw)) {
            return this.parseExportsStatement(builder2);
        }
        if ("opens".equals(kw)) {
            return this.parseOpensStatement(builder2);
        }
        if ("uses".equals(kw)) {
            return this.parseUsesStatement(builder2);
        }
        if ("provides".equals(kw)) {
            return this.parseProvidesStatement(builder2);
        }
        return null;
    }

    private PsiBuilder.Marker parseRequiresStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.REQUIRES_KEYWORD);
        PsiBuilder.Marker modifierList2 = builder2.mark();
        while (true) {
            if (PsiBuilderUtil.expect(builder2, BasicElementTypes.BASIC_MODIFIER_BIT_SET)) {
                continue;
            }
            if (builder2.getTokenType() != JavaTokenType.IDENTIFIER || !"transitive".equals(builder2.getTokenText())) break;
            BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.TRANSITIVE_KEYWORD);
        }
        BasicJavaParserUtil.done(modifierList2, this.myJavaElementTypeContainer.MODIFIER_LIST, builder2, this.myWhiteSpaceAndCommentSetHolder);
        if (this.parseNameRef(builder2) != null) {
            BasicJavaParserUtil.semicolon(builder2);
        } else {
            PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.REQUIRES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseExportsStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.EXPORTS_KEYWORD);
        return this.parsePackageStatement(builder2, statement, this.myJavaElementTypeContainer.EXPORTS_STATEMENT);
    }

    private PsiBuilder.Marker parseOpensStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.OPENS_KEYWORD);
        return this.parsePackageStatement(builder2, statement, this.myJavaElementTypeContainer.OPENS_STATEMENT);
    }

    @NotNull
    private PsiBuilder.Marker parsePackageStatement(PsiBuilder builder2, PsiBuilder.Marker statement, IElementType type) {
        boolean hasError = false;
        if (this.parseClassOrPackageRef(builder2) != null) {
            if ("to".equals(builder2.getTokenText())) {
                PsiBuilder.Marker ref;
                BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.TO_KEYWORD);
                do {
                    ref = this.parseNameRef(builder2);
                } while (PsiBuilderUtil.expect(builder2, JavaTokenType.COMMA));
                if (ref == null) {
                    hasError = true;
                }
            }
        } else {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.package.reference", new Object[0]));
            hasError = true;
        }
        if (!hasError) {
            BasicJavaParserUtil.semicolon(builder2);
        } else {
            PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON);
        }
        statement.done(type);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            BasicModuleParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    private PsiBuilder.Marker parseUsesStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.USES_KEYWORD);
        if (this.parseClassOrPackageRef(builder2) != null) {
            BasicJavaParserUtil.semicolon(builder2);
        } else {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.class.reference", new Object[0]));
            PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.USES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseProvidesStatement(PsiBuilder builder2) {
        PsiBuilder.Marker statement = builder2.mark();
        boolean hasError = false;
        BasicModuleParser.mapAndAdvance(builder2, JavaTokenType.PROVIDES_KEYWORD);
        if (this.parseClassOrPackageRef(builder2) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.class.reference", new Object[0]));
            hasError = true;
        }
        if ("with".equals(builder2.getTokenText())) {
            builder2.remapCurrentToken(JavaTokenType.WITH_KEYWORD);
            hasError = this.myParser.getReferenceParser().parseReferenceList(builder2, JavaTokenType.WITH_KEYWORD, this.myJavaElementTypeContainer.PROVIDES_WITH_LIST, JavaTokenType.COMMA);
        } else if (!hasError) {
            IElementType next = builder2.getTokenType();
            if (next == JavaTokenType.IDENTIFIER && !STATEMENT_KEYWORDS.contains(builder2.getTokenText())) {
                PsiBuilder.Marker marker = builder2.mark();
                builder2.advanceLexer();
                marker.error(JavaPsiBundle.message("expected.with", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.with", new Object[0]));
            }
            hasError = true;
        }
        if (!hasError) {
            BasicJavaParserUtil.semicolon(builder2);
        } else {
            PsiBuilderUtil.expect(builder2, JavaTokenType.SEMICOLON);
        }
        statement.done(this.myJavaElementTypeContainer.PROVIDES_STATEMENT);
        return statement;
    }

    private PsiBuilder.Marker parseNameRef(PsiBuilder builder2) {
        PsiBuilder.Marker name2 = this.parseName(builder2);
        if (name2 == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
        }
        return name2;
    }

    private static void mapAndAdvance(PsiBuilder builder2, IElementType keyword) {
        builder2.remapCurrentToken(keyword);
        builder2.advanceLexer();
    }

    private static void parseExtras(PsiBuilder builder2, @NotNull String message2) {
        if (message2 == null) {
            BasicModuleParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker extras = builder2.mark();
        while (builder2.getTokenType() != null) {
            builder2.advanceLexer();
        }
        extras.error(message2);
    }

    private PsiBuilder.Marker parseClassOrPackageRef(PsiBuilder builder2) {
        return this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, false, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicModuleParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicModuleParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseExtras";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

