/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParserUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.JavaFeature;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

public class BasicReferenceParser {
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create(JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;

    public BasicReferenceParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicReferenceParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
    }

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder2, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder2, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder2, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder2, flags, false);
        if (typeInfo != null) {
            IElementType operator;
            assert (!BitUtil.isSet(flags, 16) || !BitUtil.isSet(flags, 32)) : "don't set both flags simultaneously";
            IElementType iElementType = BitUtil.isSet(flags, 16) ? JavaTokenType.OR : (operator = BitUtil.isSet(flags, 32) ? JavaTokenType.AND : null);
            if (operator != null && builder2.getTokenType() == operator) {
                typeInfo.marker = typeInfo.marker.precede();
                while (builder2.getTokenType() == operator) {
                    builder2.advanceLexer();
                    IElementType tokenType = builder2.getTokenType();
                    if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.AT) {
                        BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    this.parseTypeInfo(builder2, flags, false);
                }
                typeInfo.marker.done(this.myJavaElementTypeContainer.TYPE);
            }
        }
        return typeInfo;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder2, int flags, boolean badWildcard) {
        if (builder2.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        PsiBuilder.Marker type = builder2.mark();
        PsiBuilder.Marker anno = this.myParser.getDeclarationParser().parseAnnotations(builder2);
        IElementType tokenType = builder2.getTokenType();
        if (tokenType == JavaTokenType.IDENTIFIER && BitUtil.isSet(flags, 128) && builder2.lookAhead(1) != JavaTokenType.DOT && builder2.lookAhead(1) != JavaTokenType.COLON && "var".equals(builder2.getTokenText()) && JavaFeature.LVTI.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder2))) {
            tokenType = JavaTokenType.VAR_KEYWORD;
            builder2.remapCurrentToken(tokenType);
        } else if (tokenType == JavaTokenType.VAR_KEYWORD && !BitUtil.isSet(flags, 128)) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder2.remapCurrentToken(tokenType);
        }
        if (PsiBuilderUtil.expect(builder2, BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else {
            if ((BitUtil.isSet(flags, 4) || badWildcard) && tokenType == JavaTokenType.QUEST) {
                builder2.advanceLexer();
                this.completeWildcardType(builder2, BitUtil.isSet(flags, 4), type);
                typeInfo.marker = type;
                return typeInfo;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                this.parseJavaCodeReference(builder2, BitUtil.isSet(flags, 1), true, false, false, false, BitUtil.isSet(flags, 8), typeInfo);
            } else {
                if (tokenType == JavaTokenType.VAR_KEYWORD) {
                    builder2.advanceLexer();
                    type.done(this.myJavaElementTypeContainer.TYPE);
                    typeInfo.marker = type;
                    return typeInfo;
                }
                if (BitUtil.isSet(flags, 8) && tokenType == JavaTokenType.GT) {
                    if (anno == null) {
                        BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.DIAMOND_TYPE);
                    } else {
                        BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        typeInfo.hasErrors = true;
                    }
                    type.done(this.myJavaElementTypeContainer.TYPE);
                    typeInfo.marker = type;
                    return typeInfo;
                }
                type.drop();
                if (anno != null && BitUtil.isSet(flags, 64)) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.type", new Object[0]));
                    typeInfo.marker = anno;
                    typeInfo.hasErrors = true;
                    return typeInfo;
                }
                return null;
            }
        }
        type.done(this.myJavaElementTypeContainer.TYPE);
        while (true) {
            this.myParser.getDeclarationParser().parseAnnotations(builder2);
            PsiBuilder.Marker bracket = builder2.mark();
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
        }
        if (BitUtil.isSet(flags, 2) && builder2.getTokenType() == JavaTokenType.ELLIPSIS) {
            builder2.advanceLexer();
            typeInfo.isVarArg = true;
        }
        if (typeInfo.isVarArg || typeInfo.isArray) {
            type = type.precede();
            type.done(this.myJavaElementTypeContainer.TYPE);
        }
        typeInfo.marker = type;
        return typeInfo;
    }

    private void completeWildcardType(PsiBuilder builder2, boolean wildcard, PsiBuilder.Marker type) {
        if (PsiBuilderUtil.expect(builder2, WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder2, 1) == null) {
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type.done(this.myJavaElementTypeContainer.TYPE);
        } else {
            type.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder2, boolean eatLastDot, boolean parameterList2, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder2, eatLastDot, parameterList2, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder2, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder2, true, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder2, boolean eatLastDot, boolean parameterList2, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder2.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder2);
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList2) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder2, true, diamonds);
        } else if (!isStaticImport) {
            BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
        }
        while (builder2.getTokenType() == JavaTokenType.DOT) {
            refElement.done(this.myJavaElementTypeContainer.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder2.mark();
            builder2.advanceLexer();
            this.myParser.getDeclarationParser().parseAnnotations(builder2);
            if (isImport && PsiBuilderUtil.expect(builder2, JavaTokenType.ASTERISK)) {
                dotPos.drop();
                return refElement;
            }
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                typeInfo.hasErrors = true;
                if (isImport) {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                } else {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                dotPos.drop();
                return refElement;
            }
            dotPos.drop();
            refElement = refElement.precede();
            if (parameterList2) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder2, true, diamonds);
                continue;
            }
            BasicJavaParserUtil.emptyElement(builder2, this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
        }
        if (isStaticImport) {
            refElement.done(this.myJavaElementTypeContainer.IMPORT_STATIC_REFERENCE);
        } else {
            refElement.done(this.myJavaElementTypeContainer.JAVA_CODE_REFERENCE);
        }
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder2, boolean wildcard, boolean diamonds) {
        PsiBuilder.Marker list = builder2.mark();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LT)) {
            list.done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
            return false;
        }
        int flags = BitUtil.set(BitUtil.set(1, 4, wildcard), 8, diamonds);
        boolean isOk = true;
        while (true) {
            if (this.parseTypeInfo(builder2, flags, true) == null) {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
            } else {
                IElementType tokenType = builder2.getTokenType();
                if (WILDCARD_KEYWORD_SET.contains(tokenType)) {
                    this.parseReferenceList(builder2, tokenType, null, JavaTokenType.AND);
                }
            }
            if (PsiBuilderUtil.expect(builder2, JavaTokenType.GT)) break;
            if (!BasicJavaParserUtil.expectOrError(builder2, JavaTokenType.COMMA, "expected.gt.or.comma")) {
                isOk = false;
                break;
            }
            flags = BitUtil.set(flags, 8, false);
        }
        list.done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder2) {
        PsiBuilder.Marker list = builder2.mark();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.LT)) {
            list.done(this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
            PsiBuilder.Marker marker = list;
            if (marker == null) {
                BasicReferenceParser.$$$reportNull$$$0(1);
            }
            return marker;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder2)) != null) continue;
            BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect(builder2, JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.GT)) {
            if (builder2.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (builder2.lookAhead(1) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder2.mark();
                    builder2.advanceLexer();
                    errorElement.error(JavaPsiBundle.message("unexpected.identifier", new Object[0]));
                    builder2.advanceLexer();
                } else {
                    BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.gt", new Object[0]));
                }
            } else {
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.gt", new Object[0]));
            }
        }
        list.done(this.myJavaElementTypeContainer.TYPE_PARAMETER_LIST);
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            BasicReferenceParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder2) {
        PsiBuilder.Marker param = builder2.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder2);
        boolean wild = PsiBuilderUtil.expect(builder2, JavaTokenType.QUEST);
        if (!wild && !PsiBuilderUtil.expect(builder2, JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder2, JavaTokenType.EXTENDS_KEYWORD, this.myJavaElementTypeContainer.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(this.myJavaElementTypeContainer.TYPE_PARAMETER);
        } else {
            param.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    public boolean parseReferenceList(PsiBuilder builder2, IElementType start, @Nullable IElementType type, IElementType delimiter) {
        PsiBuilder.Marker element = builder2.mark();
        boolean endsWithError = false;
        if (PsiBuilderUtil.expect(builder2, start)) {
            do {
                endsWithError = false;
                PsiBuilder.Marker classReference = this.parseJavaCodeReference(builder2, false, true, false, false);
                if (classReference != null) continue;
                BasicJavaParserUtil.error(builder2, JavaPsiBundle.message("expected.identifier", new Object[0]));
                endsWithError = true;
            } while (PsiBuilderUtil.expect(builder2, delimiter));
        }
        if (type != null) {
            element.done(type);
        } else {
            element.error(JavaPsiBundle.message("bound.not.expected", new Object[0]));
        }
        return endsWithError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicReferenceParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicReferenceParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeInfo {
        public boolean isPrimitive;
        public boolean isParameterized;
        public boolean isArray;
        public boolean isVarArg;
        public boolean hasErrors;
        public PsiBuilder.Marker marker;
    }
}

