/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.idea.AppMode;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.util.PlatformUtils;
import org.jetbrains.kotlin.com.intellij.util.xml.dom.XmlDomReader;
import org.jetbrains.kotlin.com.intellij.util.xml.dom.XmlElement;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static XmlElement loadData() {
        XmlElement xmlElement;
        String prefix;
        block21: {
            prefix = System.getProperty("idea.platform.prefix", "");
            String appInfoData = ApplicationNamesInfo.getAppInfoData();
            if (AppMode.isDevServer() && appInfoData.isEmpty()) {
                String module2 = null;
                if (prefix.isEmpty() || prefix.equals("idea")) {
                    module2 = "intellij.idea.ultimate.customization";
                } else if (prefix.equals("WebStorm")) {
                    module2 = "intellij.webstorm";
                }
                if (module2 != null) {
                    XmlElement xmlElement2;
                    Path file = Paths.get(PathManager.getHomePath() + "/out/classes/production/" + module2 + "/idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml", new String[0]);
                    try {
                        xmlElement2 = XmlDomReader.readXmlAsModel(Files.newInputStream(file, new OpenOption[0]));
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        break block21;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot load " + file, e);
                    }
                    if (xmlElement2 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(0);
                    }
                    return xmlElement2;
                }
            } else {
                String customAppInfo;
                if (prefix.equals("Gateway") && (customAppInfo = System.getProperty("idea.application.info.value")) != null) {
                    XmlElement xmlElement3;
                    try {
                        Path file = Paths.get(customAppInfo, new String[0]);
                        xmlElement3 = XmlDomReader.readXmlAsModel(Files.newInputStream(file, new OpenOption[0]));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot load custom application info file " + customAppInfo, e);
                    }
                    if (xmlElement3 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(1);
                    }
                    return xmlElement3;
                }
                boolean forceLoadingFromResources = "true".equals(System.getProperty("intellij.platform.load.app.info.from.resources"));
                if (!forceLoadingFromResources && !appInfoData.isEmpty()) {
                    XmlElement xmlElement4 = XmlDomReader.readXmlAsModel(appInfoData.getBytes(StandardCharsets.UTF_8));
                    if (xmlElement4 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(2);
                    }
                    return xmlElement4;
                }
            }
        }
        String resource = "idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            XmlElement data = XmlDomReader.readXmlAsModel(stream);
            if (PlatformUtils.isQodana()) {
                ApplicationNamesInfo.setQodanaProductAttributes(data);
            }
            xmlElement = data;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
        if (xmlElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(3);
        }
        return xmlElement;
    }

    private static void setQodanaProductAttributes(XmlElement data) {
        XmlElement namesNode = data.getChild("names");
        assert (namesNode != null);
        String qodanaProductName = System.getProperty("qodana.product.name", "Qodana");
        namesNode.attributes.put("product", qodanaProductName);
        namesNode.attributes.put("fullname", qodanaProductName);
        XmlElement buildNode = data.getChild("build");
        assert (buildNode != null);
        buildNode.attributes.put("number", System.getProperty("qodana.build.number", "QD-SNAPSHOT"));
        String qodanaEap = System.getProperty("qodana.eap", "false");
        XmlElement versionNode = data.getChild("version");
        assert (versionNode != null);
        versionNode.attributes.put("eap", qodanaEap);
    }

    @ApiStatus.Internal
    public static String getAppInfoData() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static XmlElement initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            XmlElement data = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data);
            }
            XmlElement xmlElement = data;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (xmlElement == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(4);
            }
            return xmlElement;
        }
    }

    private ApplicationNamesInfo(@NotNull XmlElement rootElement) {
        if (rootElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(6);
        }
        XmlElement names = rootElement.getChild("names");
        assert (names != null);
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initAndGetRawData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/ApplicationNamesInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

