/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.SortingException;
import org.jetbrains.kotlin.com.intellij.util.graph.CachingSemiGraph;
import org.jetbrains.kotlin.com.intellij.util.graph.DFSTBuilder;
import org.jetbrains.kotlin.com.intellij.util.graph.GraphGenerator;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\t\b\u0012\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0016\b\u0012\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\u0013\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder;", "", "<init>", "()V", "text", "", "Lorg/jetbrains/annotations/NonNls;", "(Ljava/lang/String;)V", "name", "first", "", "last", "before", "", "after", "toString", "equals", "other", "hashCode", "", "Companion", "Orderable", "intellij.platform.extensions"})
public final class LoadingOrder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final boolean first;
    private final boolean last;
    @NotNull
    private final Set<String> before;
    @NotNull
    private final Set<String> after;
    @JvmField
    @NotNull
    public static final LoadingOrder ANY = new LoadingOrder();
    @JvmField
    @NotNull
    public static final LoadingOrder FIRST = new LoadingOrder("first");
    @JvmField
    @NotNull
    public static final LoadingOrder LAST = new LoadingOrder("last");

    private LoadingOrder() {
        this.name = "ANY";
        this.first = false;
        this.last = false;
        this.before = SetsKt.emptySet();
        this.after = SetsKt.emptySet();
    }

    private LoadingOrder(String text) {
        Set set;
        this.name = text;
        boolean last = false;
        boolean first = false;
        Set<String> before = null;
        Set after = null;
        char[] cArray = new char[]{','};
        for (String s : SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null), LoadingOrder::_init_$lambda$0), LoadingOrder::_init_$lambda$1)) {
            if (StringsKt.equals((String)s, (String)"first", (boolean)true)) {
                first = true;
                continue;
            }
            if (StringsKt.equals((String)s, (String)"last", (boolean)true)) {
                last = true;
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)"before ", (boolean)true)) {
                if (before == null) {
                    before = new LinkedHashSet(2);
                }
                String string = s.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                before.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)"before:", (boolean)true)) {
                if (before == null) {
                    before = new LinkedHashSet(2);
                }
                String string = s.substring(7);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                before.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)"after ", (boolean)true)) {
                if (after == null) {
                    after = new LinkedHashSet(2);
                }
                String string = s.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                after.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            if (StringsKt.startsWith((String)s, (String)"after:", (boolean)true)) {
                if (after == null) {
                    after = new LinkedHashSet(2);
                }
                String string = s.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                after.add(((Object)StringsKt.trim((CharSequence)string)).toString());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + s + "; should be one of first, last, before <id> or after <id>"));
        }
        Set<String> set2 = before;
        if (set2 == null) {
            set2 = this.before = SetsKt.emptySet();
        }
        if ((set = after) == null) {
            set = SetsKt.emptySet();
        }
        this.after = set;
        this.first = first;
        this.last = last;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoadingOrder)) {
            return false;
        }
        return this.first == ((LoadingOrder)other).first && this.last == ((LoadingOrder)other).last && Intrinsics.areEqual(this.after, ((LoadingOrder)other).after) && Intrinsics.areEqual(this.before, ((LoadingOrder)other).before);
    }

    public int hashCode() {
        int result2 = this.first ? 1 : 0;
        result2 = 31 * result2 + (this.last ? 1 : 0);
        result2 = 31 * result2 + ((Object)this.before).hashCode();
        result2 = 31 * result2 + ((Object)this.after).hashCode();
        return result2;
    }

    private static final String _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean _init_$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    public /* synthetic */ LoadingOrder(String text, DefaultConstructorMarker $constructor_marker) {
        this(text);
    }

    public static final /* synthetic */ Set access$getAfter$p(LoadingOrder $this) {
        return $this.after;
    }

    public static final /* synthetic */ boolean access$getLast$p(LoadingOrder $this) {
        return $this.last;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0012\u001a\u00020\u000f2\r\u0010\u0013\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0007J\u0017\u0010\u0014\u001a\u00020\u000f2\r\u0010\u0013\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018H\u0007J\u0012\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0005H\u0007R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder$Companion;", "", "<init>", "()V", "FIRST_STR", "", "Lorg/jetbrains/annotations/NonNls;", "LAST_STR", "BEFORE_STR", "BEFORE_STR_OLD", "AFTER_STR", "AFTER_STR_OLD", "ORDER_RULE_SEPARATOR", "", "ANY", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder;", "FIRST", "LAST", "before", "id", "after", "sortByLoadingOrder", "", "orderable", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder$Orderable;", "readOrder", "orderAttr", "anchorToOrder", "anchor", "intellij.platform.extensions"})
    @SourceDebugExtension(value={"SMAP\nLoadingOrder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadingOrder.kt\ncom/intellij/openapi/extensions/LoadingOrder$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,253:1\n15#2:254\n*S KotlinDebug\n*F\n+ 1 LoadingOrder.kt\ncom/intellij/openapi/extensions/LoadingOrder$Companion\n*L\n222#1:254\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        public final void sortByLoadingOrder(@NotNull List<? extends Orderable> orderable) {
            Orderable[] orderableArray;
            Intrinsics.checkNotNullParameter(orderable, (String)"orderable");
            if (orderable.size() < 2) {
                return;
            }
            LinkedHashMap<String, Orderable> map = new LinkedHashMap<String, Orderable>();
            LinkedHashMap<Orderable, LoadingOrder> cachedMap2 = new LinkedHashMap<Orderable, LoadingOrder>();
            LinkedHashSet<Orderable> first = new LinkedHashSet<Orderable>(1);
            LinkedHashSet<Orderable> hasBefore = new LinkedHashSet<Orderable>(orderable.size());
            for (Orderable orderable2 : orderable) {
                LoadingOrder order;
                String id = orderable2.getOrderId();
                orderableArray = (Orderable[])id;
                if (!(orderableArray == null || orderableArray.length() == 0)) {
                    map.put(id, orderable2);
                }
                if ((order = orderable2.getOrder()) == ANY) continue;
                cachedMap2.put(orderable2, order);
                if (order.first) {
                    first.add(orderable2);
                }
                if (order.before.isEmpty()) continue;
                hasBefore.add(orderable2);
            }
            if (cachedMap2.isEmpty()) {
                return;
            }
            InboundSemiGraph<Orderable> graph2 = new InboundSemiGraph<Orderable>(orderable, cachedMap2, map, hasBefore, first){
                final /* synthetic */ List<? extends Orderable> $orderable;
                final /* synthetic */ LinkedHashMap<Orderable, LoadingOrder> $cachedMap;
                final /* synthetic */ LinkedHashMap<String, Orderable> $map;
                final /* synthetic */ LinkedHashSet<Orderable> $hasBefore;
                final /* synthetic */ LinkedHashSet<Orderable> $first;
                {
                    this.$orderable = $orderable;
                    this.$cachedMap = $cachedMap;
                    this.$map = $map;
                    this.$hasBefore = $hasBefore;
                    this.$first = $first;
                }

                public Collection<Orderable> getNodes() {
                    return CollectionsKt.reversed((Iterable)this.$orderable);
                }

                public Iterator<Orderable> getIn(Orderable n) {
                    LoadingOrder hisOrder;
                    Intrinsics.checkNotNullParameter((Object)n, (String)"n");
                    LoadingOrder loadingOrder = this.$cachedMap.getOrDefault(n, LoadingOrder.ANY);
                    Intrinsics.checkNotNullExpressionValue((Object)loadingOrder, (String)"getOrDefault(...)");
                    LoadingOrder order = loadingOrder;
                    LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                    for (String id : LoadingOrder.access$getAfter$p(order)) {
                        Orderable orderable = this.$map.get(id);
                        if (orderable == null) continue;
                        predecessors.add(orderable);
                    }
                    String id = n.getOrderId();
                    Object object = id;
                    if (!(object == null || object.length() == 0)) {
                        Iterator<E> iterator2 = this.$hasBefore.iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                        object = iterator2;
                        while (object.hasNext()) {
                            Orderable orderable = object.next();
                            Intrinsics.checkNotNullExpressionValue((Object)this.$cachedMap.getOrDefault(orderable, LoadingOrder.ANY), (String)"getOrDefault(...)");
                            if (!LoadingOrder.access$getBefore$p(hisOrder).contains(id)) continue;
                            predecessors.add(orderable);
                        }
                    }
                    if (LoadingOrder.access$getLast$p(order)) {
                        for (Orderable orderable : this.$orderable) {
                            Intrinsics.checkNotNullExpressionValue((Object)this.$cachedMap.getOrDefault(orderable, LoadingOrder.ANY), (String)"getOrDefault(...)");
                            if (LoadingOrder.access$getLast$p(hisOrder)) continue;
                            predecessors.add(orderable);
                        }
                    }
                    if (!LoadingOrder.access$getFirst$p(order)) {
                        predecessors.addAll((Collection)this.$first);
                    }
                    Iterator<Orderable> iterator3 = predecessors.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
                    return iterator3;
                }
            };
            DFSTBuilder dFSTBuilder = new DFSTBuilder(GraphGenerator.generate(CachingSemiGraph.cache((InboundSemiGraph)graph2)));
            if (!dFSTBuilder.isAcyclic()) {
                Map.Entry entry = dFSTBuilder.getCircularDependency();
                Intrinsics.checkNotNull(entry);
                Map.Entry p = entry;
                orderableArray = new Orderable[]{p.getKey(), p.getValue()};
                throw new SortingException("Could not satisfy sorting requirements", orderableArray);
            }
            Comparator comparator = dFSTBuilder.comparator();
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparator(...)");
            CollectionsKt.sortWith(orderable, comparator);
        }

        @JvmStatic
        @ApiStatus.Internal
        @NotNull
        public final LoadingOrder readOrder(@Nullable String orderAttr) {
            String string = orderAttr;
            return string == null ? ANY : (Intrinsics.areEqual((Object)string, (Object)"first") ? FIRST : (Intrinsics.areEqual((Object)string, (Object)"last") ? LAST : new LoadingOrder(orderAttr, null)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder$Orderable;", "", "orderId", "", "getOrderId", "()Ljava/lang/String;", "order", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/LoadingOrder;", "getOrder", "()Lcom/intellij/openapi/extensions/LoadingOrder;", "intellij.platform.extensions"})
    @ApiStatus.Internal
    public static interface Orderable {
        @Nullable
        public String getOrderId();

        @NotNull
        public LoadingOrder getOrder();
    }
}

