/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import java.util.List;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValueKt;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValueListener;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValueSource;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.ValueWithSource;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B(\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0007J\r\u0010\u001e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001fH\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\u0006\u0010!\u001a\u00020\u0016J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$J\u001a\u0010(\u001a\u00020*2\b\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010+\u001a\u00020\u001dH\u0007J\u000e\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0005J\u0006\u0010.\u001a\u00020\u0019J\b\u0010/\u001a\u00020\u0019H\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000101J\b\u00105\u001a\u00020\u0011H\u0016J\b\u00106\u001a\u00020\u0011H\u0016J\u0017\u00109\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0017\u0010:\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0007J\u0015\u0010;\u001a\u00020\u00052\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0015\u0010<\u001a\u00020*2\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u000e\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0016J\u0010\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001dH\u0017J\u0016\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010>\u001a\u00020?J\u0016\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010>\u001a\u00020?J\u0018\u0010=\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?H\u0007J\u0006\u0010@\u001a\u00020*J\u0016\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020?J\u0016\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EJ\r\u0010F\u001a\u00020*H\u0000\u00a2\u0006\u0002\bGJ\b\u0010I\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0011\u0010\"\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R2\u0010&\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001f2\r\u0010%\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\f\"\u0004\b(\u0010)R\u0019\u00103\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\fR\u0013\u00107\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\fR\u0014\u0010H\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0013\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue;", "", "registry", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry;", "key", "", "Lorg/jetbrains/annotations/NonNls;", "keyDescriptor", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryKeyDescriptor;", "<init>", "(Lcom/intellij/openapi/util/registry/Registry;Ljava/lang/String;Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;)V", "getKey", "()Ljava/lang/String;", "listeners", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValueListener;", "value", "", "isChangedSinceAppStart", "()Z", "stringCachedValue", "intCachedValue", "", "Ljava/lang/Integer;", "doubleCachedValue", "", "booleanCachedValue", "Ljava/lang/Boolean;", "getSource", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValueSource;", "asString", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/NlsSafe;", "asBoolean", "asInteger", "isMultiValue", "asOptions", "", "selected", "selectedOption", "getSelectedOption", "setSelectedOption", "(Ljava/lang/String;)V", "", "source", "isOptionEnabled", "option", "asDouble", "computeDouble", "asColor", "Ljava/awt/Color;", "defaultValue", "description", "getDescription", "isRestartRequired", "isChangedFromDefault", "pluginId", "getPluginId", "getAsValue", "resolveNotRequiredValue", "resolveRequiredValue", "checkIsLoaded", "setValue", "parentDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "resetToDefault", "addListener", "listener", "parent", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "resetCache", "resetCache$intellij_platform_util", "isBoolean", "toString", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nRegistryValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryValue.kt\ncom/intellij/openapi/util/registry/RegistryValue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n739#2,9:320\n739#2,9:329\n1#3:338\n*S KotlinDebug\n*F\n+ 1 RegistryValue.kt\ncom/intellij/openapi/util/registry/RegistryValue\n*L\n81#1:320,9\n147#1:329,9\n*E\n"})
public class RegistryValue {
    @NotNull
    private final Registry registry;
    @NotNull
    private final String key;
    @Nullable
    private final RegistryKeyDescriptor keyDescriptor;
    @NotNull
    private final List<RegistryValueListener> listeners;
    private boolean isChangedSinceAppStart;
    @Nullable
    private String stringCachedValue;
    @Nullable
    private Integer intCachedValue;
    private double doubleCachedValue;
    @Nullable
    private Boolean booleanCachedValue;

    @ApiStatus.Internal
    public RegistryValue(@NotNull Registry registry, @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.registry = registry;
        this.key = key;
        this.keyDescriptor = keyDescriptor;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"createLockFreeCopyOnWriteList(...)");
        this.listeners = list;
        this.doubleCachedValue = Double.NaN;
    }

    @NotNull
    public String asString() {
        String result2 = this.stringCachedValue;
        if (result2 == null) {
            this.stringCachedValue = result2 = this.resolveRequiredValue(this.key);
        }
        return result2;
    }

    public boolean asBoolean() {
        Boolean result2 = this.booleanCachedValue;
        if (result2 == null) {
            this.booleanCachedValue = result2 = Boolean.valueOf(Boolean.parseBoolean(this.resolveRequiredValue(this.key)));
        }
        return result2;
    }

    public final int asInteger() {
        Integer result2 = this.intCachedValue;
        if (result2 == null) {
            Integer n;
            try {
                n = Integer.parseInt(this.resolveRequiredValue(this.key));
            }
            catch (NumberFormatException e) {
                n = Integer.parseInt(this.registry.getBundleValue$intellij_platform_util(this.key, this.keyDescriptor));
            }
            this.intCachedValue = result2 = n;
        }
        return result2;
    }

    @Nullable
    public final String getSelectedOption() {
        String value2 = this.asString();
        int length = value2.length();
        if (length < 3 || value2.charAt(0) != '[' || value2.charAt(length - 1) != ']') {
            return null;
        }
        int pos = 1;
        while (pos < length) {
            int end = StringsKt.indexOf$default((CharSequence)value2, (char)'|', (int)pos, (boolean)false, (int)4, null);
            if (end == -1) {
                end = length - 1;
            }
            if (value2.charAt(end - 1) == '*') {
                String string = value2.substring(pos, end - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            pos = end + 1;
        }
        return null;
    }

    public boolean isRestartRequired() {
        if (this.keyDescriptor == null) {
            return Boolean.parseBoolean(this.resolveNotRequiredValue(this.key + ".restartRequired"));
        }
        return this.keyDescriptor.isRestartRequired();
    }

    @ApiStatus.Internal
    @Nullable
    public final String resolveNotRequiredValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(key);
        if (valueWithSource != null) {
            ValueWithSource it = valueWithSource;
            boolean bl = false;
            return it.getValue();
        }
        String string = System.getProperty(key);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        this.checkIsLoaded(key);
        return this.registry.getBundleValueOrNull(key);
    }

    private final String resolveRequiredValue(String key) throws MissingResourceException {
        ValueWithSource valueWithSource = this.registry.getStoredProperties().get(key);
        if (valueWithSource != null) {
            ValueWithSource it = valueWithSource;
            boolean bl = false;
            return it.getValue();
        }
        String string = System.getProperty(key);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        this.checkIsLoaded(key);
        return this.registry.getBundleValue$intellij_platform_util(key, this.keyDescriptor);
    }

    private final void checkIsLoaded(String key) {
        if (this.registry.isLoaded()) {
            return;
        }
        String message2 = "Attempt to load key '" + key + "' for not yet loaded registry";
        if (Disposer.isDebugMode()) {
            RegistryValueKt.access$getLOG$p().error(message2 + ". Use system properties instead of registry values to configure behaviour at early startup stages.");
        } else {
            RegistryValueKt.access$getLOG$p().warn(message2);
        }
    }

    public final void setValue(boolean value2) {
        this.setValue(String.valueOf(value2));
    }

    public void setValue(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.setValue(value2, RegistryValueSource.SYSTEM);
    }

    @ApiStatus.Experimental
    public void setValue(@NotNull String value2, @NotNull RegistryValueSource source) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        RegistryValueListener globalValueChangeListener = this.registry.getValueChangeListener();
        globalValueChangeListener.beforeValueChanged(this);
        for (RegistryValueListener each : this.listeners) {
            each.beforeValueChanged(this);
        }
        this.resetCache$intellij_platform_util();
        this.registry.getStoredProperties().put(this.key, new ValueWithSource(value2, source));
        RegistryValueKt.access$getLOG$p().info("Registry value '" + this.key + "' has changed to '" + value2 + "' by " + source.name());
        globalValueChangeListener.afterValueChanged(this);
        for (RegistryValueListener listener : this.listeners) {
            listener.afterValueChanged(this);
        }
        if (!this.isRestartRequired() && Intrinsics.areEqual((Object)this.resolveNotRequiredValue(this.key), (Object)this.registry.getBundleValueOrNull(this.key))) {
            this.registry.getStoredProperties().remove(this.key);
        }
        this.isChangedSinceAppStart = true;
    }

    public final void setValue(boolean value2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        boolean prev = this.asBoolean();
        this.setValue(value2);
        Disposer.register(parentDisposable, () -> RegistryValue.setValue$lambda$7(this, prev));
    }

    public final void resetCache$intellij_platform_util() {
        this.stringCachedValue = null;
        this.intCachedValue = null;
        this.doubleCachedValue = Double.NaN;
        this.booleanCachedValue = null;
    }

    @NotNull
    public String toString() {
        return this.key + '=' + this.asString();
    }

    private static final void setValue$lambda$7(RegistryValue this$0, boolean $prev) {
        this$0.setValue($prev);
    }
}

