/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public class PsiArrayType
extends PsiType.Stub
implements JvmArrayType {
    private final PsiType myComponentType;

    public PsiArrayType(@NotNull PsiType componentType) {
        if (componentType == null) {
            PsiArrayType.$$$reportNull$$$0(0);
        }
        this(componentType, TypeAnnotationProvider.EMPTY);
    }

    public PsiArrayType(@NotNull PsiType componentType, PsiAnnotation @NotNull [] annotations2) {
        if (componentType == null) {
            PsiArrayType.$$$reportNull$$$0(1);
        }
        if (annotations2 == null) {
            PsiArrayType.$$$reportNull$$$0(2);
        }
        super(annotations2);
        this.myComponentType = componentType;
    }

    public PsiArrayType(@NotNull PsiType componentType, @NotNull TypeAnnotationProvider provider) {
        if (componentType == null) {
            PsiArrayType.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PsiArrayType.$$$reportNull$$$0(4);
        }
        super(provider);
        this.myComponentType = componentType;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(this.getDeepComponentType().getPresentableText(annotated), "[]", false, annotated);
        if (string == null) {
            PsiArrayType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(this.getDeepComponentType().getCanonicalText(annotated), "[]", true, annotated);
        if (string == null) {
            PsiArrayType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(this.getDeepComponentType().getInternalCanonicalText(), "[]", true, true);
        if (string == null) {
            PsiArrayType.$$$reportNull$$$0(7);
        }
        return string;
    }

    protected String getText(@NotNull String prefix, @NotNull String suffix, boolean qualified, boolean annotated) {
        if (prefix == null) {
            PsiArrayType.$$$reportNull$$$0(8);
        }
        if (suffix == null) {
            PsiArrayType.$$$reportNull$$$0(9);
        }
        int dimensions = this.getArrayDimensions();
        StringBuilder sb = new StringBuilder(prefix.length() + (dimensions - 1) * 2 + suffix.length());
        sb.append(prefix);
        PsiType current = this;
        for (int i = 0; i < dimensions; ++i) {
            PsiAnnotation[] annotations2;
            if (annotated && (annotations2 = current.getAnnotations()).length != 0) {
                sb.append(' ');
                PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
            }
            if (i == dimensions - 1) {
                sb.append(suffix);
                continue;
            }
            sb.append("[]");
            current = current.getComponentType();
        }
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return this.myComponentType.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiArrayType.$$$reportNull$$$0(10);
        }
        return text.endsWith("[]") && this.myComponentType.equalsToText(text.substring(0, text.length() - 2));
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiArrayType.$$$reportNull$$$0(11);
        }
        return visitor2.visitArrayType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myComponentType.getResolveScope();
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] superTypes = this.myComponentType.getSuperTypes();
        PsiType[] result2 = PsiArrayType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            result2[i] = superTypes[i].createArrayType();
        }
        if (result2 == null) {
            PsiArrayType.$$$reportNull$$$0(12);
        }
        return result2;
    }

    @Contract(pure=true)
    @NotNull
    public PsiType getComponentType() {
        PsiType psiType = this.myComponentType;
        if (psiType == null) {
            PsiArrayType.$$$reportNull$$$0(13);
        }
        return psiType;
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiArrayType && this instanceof PsiEllipsisType == obj instanceof PsiEllipsisType && this.myComponentType.equals(((PsiArrayType)obj).getComponentType());
    }

    public int hashCode() {
        return this.myComponentType.hashCode() * 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiArrayType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

