/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginAware;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.patterns.ElementPattern;
import org.jetbrains.kotlin.com.intellij.patterns.ElementPatternBean;
import org.jetbrains.kotlin.com.intellij.patterns.StandardPatterns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceProvider;
import org.jetbrains.kotlin.com.intellij.util.KeyedLazyInstance;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Property;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.XCollection;

public class PsiReferenceProviderBean
implements PluginAware,
KeyedLazyInstance<PsiReferenceProviderBean> {
    public static final ExtensionPointName<PsiReferenceProviderBean> EP_NAME = new ExtensionPointName("org.jetbrains.kotlin.com.intellij.psi.referenceProvider");
    @Attribute(value="language")
    public String language = Language.ANY.getID();
    @Attribute(value="providerClass")
    public String className;
    @Tag(value="description")
    public String description;
    @Property(surroundWithTag=false)
    @XCollection
    public ElementPatternBean[] patterns;
    private PluginDescriptor pluginDescriptor;

    public String getDescription() {
        return this.description;
    }

    public PsiReferenceProvider instantiate() {
        try {
            return (PsiReferenceProvider)ApplicationManager.getApplication().instantiateClass(this.className, this.pluginDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(PsiReferenceProviderBean.class).error(e);
            return null;
        }
    }

    @Override
    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public ElementPattern<PsiElement> createElementPattern() {
        if (this.patterns == null || this.patterns.length == 0) {
            Logger.getInstance(PsiReferenceProviderBean.class).error(new PluginException("At least one pattern should be specified", this.pluginDescriptor.getPluginId()));
            return null;
        }
        if (this.patterns.length > 1) {
            List<ElementPattern> result2 = new ArrayList(this.patterns.length);
            for (ElementPatternBean t : this.patterns) {
                ElementPattern<PsiElement> o = t.compilePattern();
                if (o == null) continue;
                result2.add(o);
            }
            result2 = result2.isEmpty() ? Collections.emptyList() : result2;
            return StandardPatterns.or(result2.toArray(new ElementPattern[0]));
        }
        return this.patterns[0].compilePattern();
    }

    @Override
    @NotNull
    public String getKey() {
        String string = this.language;
        if (string == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiReferenceProviderBean getInstance() {
        PsiReferenceProviderBean psiReferenceProviderBean = this;
        if (psiReferenceProviderBean == null) {
            PsiReferenceProviderBean.$$$reportNull$$$0(2);
        }
        return psiReferenceProviderBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceProviderBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiReferenceProviderBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPluginDescriptor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

