/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiJavaModuleStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiPackageAccessibilityStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiProvidesStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiRequiresStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl.PsiUsesStatementStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.commons.ModuleResolutionAttribute;

public class ModuleStubBuildingVisitor
extends ClassVisitor {
    private static final Function<String, String> NAME_MAPPER = name1 -> name1.replace('/', '.');
    private static final Attribute[] ATTRIBUTES = new Attribute[]{new ModuleResolutionAttribute()};
    private final ModuleStubBuilder myBuilder;

    public ModuleStubBuildingVisitor(PsiJavaFileStub parent2) {
        super(589824);
        this.myBuilder = new ModuleStubBuilder(parent2);
    }

    public PsiJavaModuleStub getResult() {
        return this.myBuilder.build();
    }

    @Override
    public ModuleVisitor visitModule(String name2, int access, String version2) {
        this.myBuilder.name(name2).flags(ModuleStubBuildingVisitor.moduleFlags(access));
        return new ModuleVisitor(589824){

            @Override
            public void visitRequire(String module2, int access, String version2) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    ModuleStubBuildingVisitor.this.myBuilder.addRequires(module2, ModuleStubBuildingVisitor.requiresFlags(access));
                }
            }

            @Override
            public void visitExport(String packageName, int access, String ... modules) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    ModuleStubBuildingVisitor.this.myBuilder.addPackageAccessibility(JavaStubElementTypes.EXPORTS_STATEMENT, packageName, modules);
                }
            }

            @Override
            public void visitOpen(String packageName, int access, String ... modules) {
                if (!ModuleStubBuildingVisitor.isGenerated(access)) {
                    ModuleStubBuildingVisitor.this.myBuilder.addPackageAccessibility(JavaStubElementTypes.OPENS_STATEMENT, packageName, modules);
                }
            }

            @Override
            public void visitUse(String service) {
                ModuleStubBuildingVisitor.this.myBuilder.addUses(service);
            }

            @Override
            public void visitProvide(String service, String ... providers) {
                ModuleStubBuildingVisitor.this.myBuilder.addProvide(service, providers);
            }
        };
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return StubBuildingVisitor.getAnnotationTextCollector(desc, text -> this.myBuilder.addAnnotation((String)text));
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleResolutionAttribute) {
            this.myBuilder.resolution(((ModuleResolutionAttribute)attribute).resolution);
        }
        super.visitAttribute(attribute);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    private static boolean isGenerated(int access) {
        return BitUtil.isSet(access, 4096) || BitUtil.isSet(access, 32768);
    }

    private static int moduleFlags(int access) {
        return BitUtil.isSet(access, 32) ? 8192 : 0;
    }

    private static int requiresFlags(int access) {
        int flags = 0;
        if (BitUtil.isSet(access, 32)) {
            flags |= 0x4000;
        }
        if (BitUtil.isSet(access, 64)) {
            flags |= 8;
        }
        return flags;
    }

    public Attribute[] attributes() {
        return ATTRIBUTES;
    }

    private static class ModuleStubBuilder {
        private final PsiJavaFileStub myParent;
        private volatile PsiJavaModuleStub myResult;
        private volatile String myName;
        private volatile int myFlags;
        private volatile int myResolution;
        private final List<Requires> myRequires = new ArrayList<Requires>();
        private final List<PackageAccessibility> myPackageAccessibilities = new ArrayList<PackageAccessibility>();
        private final List<Provide> myProvides = new ArrayList<Provide>();
        private final List<String> myServices = new ArrayList<String>();
        private final List<String> myAnnotations = new ArrayList<String>();

        ModuleStubBuilder(PsiJavaFileStub parent2) {
            this.myParent = parent2;
        }

        ModuleStubBuilder name(String name2) {
            this.myName = name2;
            return this;
        }

        void flags(int flags) {
            this.myFlags = flags;
        }

        void addRequires(String module2, int flags) {
            this.myRequires.add(new Requires(module2, flags));
        }

        void addPackageAccessibility(IStubElementType type, String packageName, String[] modules) {
            this.myPackageAccessibilities.add(new PackageAccessibility(type, packageName, modules));
        }

        void resolution(int resolution) {
            this.myResolution = resolution;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PsiJavaModuleStub build() {
            if (this.myResult == null) {
                ModuleStubBuilder moduleStubBuilder = this;
                synchronized (moduleStubBuilder) {
                    if (this.myResult == null) {
                        PsiJavaModuleStubImpl result2 = new PsiJavaModuleStubImpl(this.myParent, this.myName, this.myResolution);
                        PsiModifierListStubImpl modifiers = new PsiModifierListStubImpl((StubElement)result2, this.myFlags);
                        for (Requires require : this.myRequires) {
                            PsiRequiresStatementStubImpl req = new PsiRequiresStatementStubImpl((StubElement)result2, require.name);
                            new PsiModifierListStubImpl((StubElement)req, require.flags);
                        }
                        for (PackageAccessibility accessibility : this.myPackageAccessibilities) {
                            new PsiPackageAccessibilityStatementStubImpl(result2, accessibility.myType, (String)NAME_MAPPER.fun(accessibility.myPackageName), accessibility.myModules);
                        }
                        for (String service : this.myServices) {
                            new PsiUsesStatementStubImpl((StubElement)result2, (String)NAME_MAPPER.fun(service));
                        }
                        for (Provide provide : this.myProvides) {
                            PsiProvidesStatementStubImpl statementStub = new PsiProvidesStatementStubImpl((StubElement)result2, (String)NAME_MAPPER.fun(provide.myService));
                            String[] names = ContainerUtil.map2Array(provide.myProviders, String.class, NAME_MAPPER);
                            new PsiClassReferenceListStubImpl(JavaStubElementTypes.PROVIDES_WITH_LIST, (StubElement)statementStub, names.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : names);
                        }
                        for (String annotation : this.myAnnotations) {
                            new PsiAnnotationStubImpl(modifiers, annotation);
                        }
                        this.myResult = result2;
                    }
                }
            }
            return this.myResult;
        }

        void addUses(String service) {
            this.myServices.add(service);
        }

        void addProvide(String service, String[] providers) {
            this.myProvides.add(new Provide(service, providers));
        }

        void addAnnotation(String annotationName) {
            this.myAnnotations.add(annotationName);
        }

        private static class Requires {
            final String name;
            final int flags;

            Requires(String name2, int flags) {
                this.name = name2;
                this.flags = flags;
            }
        }

        private static class PackageAccessibility {
            final IStubElementType myType;
            final String myPackageName;
            final List<String> myModules;

            PackageAccessibility(IStubElementType type, String packageName, String[] modules) {
                this.myType = type;
                this.myPackageName = packageName;
                this.myModules = modules == null ? null : Arrays.asList(modules);
            }
        }

        private static class Provide {
            private final String myService;
            private final List<String> myProviders;

            Provide(String service, String[] providers) {
                this.myService = service;
                this.myProviders = providers == null ? null : Arrays.asList(providers);
            }
        }
    }
}

