/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.ProjectRootModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportModuleStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageAccessibilityStatement;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiJavaModuleModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiImportStatementBaseImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;

public class PsiImportModuleStatementImpl
extends PsiImportStatementBaseImpl
implements PsiImportModuleStatement {
    public static final PsiImportModuleStatementImpl[] EMPTY_ARRAY = new PsiImportModuleStatementImpl[0];
    public static final ArrayFactory<PsiImportModuleStatementImpl> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiImportModuleStatementImpl[count];
    private SoftReference<PsiJavaModuleReferenceElement> myRefElement;

    public PsiImportModuleStatementImpl(PsiImportStatementStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.IMPORT_MODULE_STATEMENT);
    }

    public PsiImportModuleStatementImpl(ASTNode node) {
        super(node);
    }

    @Override
    @Nullable
    public PsiJavaModule resolveTargetModule() {
        PsiJavaModuleReferenceElement refElement = this.getModuleReference();
        if (refElement == null) {
            return null;
        }
        PsiJavaModuleReference ref = refElement.getReference();
        if (ref == null) {
            return null;
        }
        return ref.resolve();
    }

    @Override
    public String getReferenceName() {
        PsiJavaModuleReferenceElement refElement = this.getModuleReference();
        if (refElement == null) {
            return null;
        }
        PsiJavaModuleReference ref = refElement.getReference();
        if (ref == null) {
            return null;
        }
        return ref.getCanonicalText();
    }

    @Override
    @Nullable
    public PsiJavaModuleReferenceElement getModuleReference() {
        PsiImportStatementStub stub = (PsiImportStatementStub)this.getStub();
        if (stub != null) {
            String refText = StringUtil.nullize(stub.getImportReferenceText());
            if (refText == null) {
                return null;
            }
            PsiJavaModuleReferenceElement refElement = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myRefElement);
            if (refElement == null) {
                refElement = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createModuleReferenceFromText(refText, this);
                this.myRefElement = new SoftReference<PsiJavaModuleReferenceElement>(refElement);
            }
            return refElement;
        }
        this.myRefElement = null;
        return PsiTreeUtil.getChildOfType(this, PsiJavaModuleReferenceElement.class);
    }

    @Override
    @Nullable
    public PsiPackageAccessibilityStatement findImportedPackage(@NotNull String packageName) {
        if (packageName == null) {
            PsiImportModuleStatementImpl.$$$reportNull$$$0(0);
        }
        PsiImportModuleStatementImpl moduleStatement = this;
        return (PsiPackageAccessibilityStatement)((Map)CachedValuesManager.getCachedValue(moduleStatement, () -> {
            Project project = moduleStatement.getProject();
            HashMap<String, PsiPackageAccessibilityStatement> packagesByName = new HashMap<String, PsiPackageAccessibilityStatement>();
            PsiJavaModule module2 = this.resolveTargetModule();
            if (module2 == null) {
                return CachedValueProvider.Result.create(packagesByName, PsiJavaModuleModificationTracker.getInstance(project), ProjectRootModificationTracker.getInstance(project));
            }
            List<PsiPackageAccessibilityStatement> packages = JavaResolveUtil.getExportedPackages(module2, module2);
            for (PsiPackageAccessibilityStatement aPackage : packages) {
                String currentPackageName = aPackage.getPackageName();
                if (currentPackageName == null) continue;
                packagesByName.put(currentPackageName, aPackage);
            }
            return CachedValueProvider.Result.create(packagesByName, PsiJavaModuleModificationTracker.getInstance(project), ProjectRootModificationTracker.getInstance(project));
        })).get(packageName);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiImportModuleStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitImportModuleStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiElement resolve() {
        PsiJavaModuleReferenceElement refElement = this.getModuleReference();
        if (refElement == null) {
            return null;
        }
        PsiJavaModuleReference ref = refElement.getReference();
        return ref != null ? ref.resolve() : null;
    }

    @Override
    public boolean isOnDemand() {
        return true;
    }

    @Override
    public String toString() {
        return "PsiImportModuleStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiImportModuleStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findImportedPackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

