/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.JavaFeature;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ParentAwareTokenSet;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class WhiteSpaceAndCommentSetHolder {
    public static final WhiteSpaceAndCommentSetHolder INSTANCE = new WhiteSpaceAndCommentSetHolder();
    private static final ParentAwareTokenSet PRECEDING_COMMENT_SET = ParentAwareTokenSet.orSet(ParentAwareTokenSet.create(BasicJavaElementType.BASIC_MODULE, BasicJavaElementType.BASIC_IMPLICIT_CLASS), BasicElementTypes.BASIC_FULL_MEMBER_BIT_SET);
    private static final ParentAwareTokenSet TRAILING_COMMENT_SET = ParentAwareTokenSet.orSet(ParentAwareTokenSet.create(BasicJavaElementType.BASIC_PACKAGE_STATEMENT), BasicElementTypes.BASIC_IMPORT_STATEMENT_BASE_BIT_SET, BasicElementTypes.BASIC_FULL_MEMBER_BIT_SET, BasicElementTypes.BASIC_JAVA_STATEMENT_BIT_SET);
    private final WhitespacesAndCommentsBinder PRECEDING_COMMENT_BINDER_WITH_MARKDOWN = new PrecedingWhitespacesAndCommentsBinder(false, true);
    private final WhitespacesAndCommentsBinder SPECIAL_PRECEDING_COMMENT_BINDER_WITH_MARKDOWN = new PrecedingWhitespacesAndCommentsBinder(true, true);
    private final WhitespacesAndCommentsBinder PRECEDING_COMMENT_BINDER_WITHOUT_MARKDOWN = new PrecedingWhitespacesAndCommentsBinder(false, false);
    private final WhitespacesAndCommentsBinder SPECIAL_PRECEDING_COMMENT_BINDER_WITHOUT_MARKDOWN = new PrecedingWhitespacesAndCommentsBinder(true, false);
    private final WhitespacesAndCommentsBinder TRAILING_COMMENT_BINDER = new TrailingWhitespacesAndCommentsBinder();

    private WhiteSpaceAndCommentSetHolder() {
    }

    public WhitespacesAndCommentsBinder getPrecedingCommentBinder(@NotNull LanguageLevel myLanguageLevel) {
        if (myLanguageLevel == null) {
            WhiteSpaceAndCommentSetHolder.$$$reportNull$$$0(0);
        }
        return JavaFeature.MARKDOWN_COMMENT.isSufficient(myLanguageLevel) ? this.PRECEDING_COMMENT_BINDER_WITH_MARKDOWN : this.PRECEDING_COMMENT_BINDER_WITHOUT_MARKDOWN;
    }

    public WhitespacesAndCommentsBinder getSpecialPrecedingCommentBinder(@NotNull LanguageLevel myLanguageLevel) {
        if (myLanguageLevel == null) {
            WhiteSpaceAndCommentSetHolder.$$$reportNull$$$0(1);
        }
        return JavaFeature.MARKDOWN_COMMENT.isSufficient(myLanguageLevel) ? this.SPECIAL_PRECEDING_COMMENT_BINDER_WITH_MARKDOWN : this.SPECIAL_PRECEDING_COMMENT_BINDER_WITHOUT_MARKDOWN;
    }

    public WhitespacesAndCommentsBinder getTrailingCommentBinder() {
        return this.TRAILING_COMMENT_BINDER;
    }

    public ParentAwareTokenSet getPrecedingCommentSet() {
        return PRECEDING_COMMENT_SET;
    }

    public ParentAwareTokenSet getTrailingCommentSet() {
        return TRAILING_COMMENT_SET;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "myLanguageLevel";
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/WhiteSpaceAndCommentSetHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrecedingCommentBinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecialPrecedingCommentBinder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PrecedingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAfterEmptyImport;
        private final boolean mySupportMarkdown;

        PrecedingWhitespacesAndCommentsBinder(boolean afterImport, boolean supportMarkdown) {
            this.myAfterEmptyImport = afterImport;
            this.mySupportMarkdown = supportMarkdown;
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            int idx;
            if (tokens.isEmpty()) {
                return 0;
            }
            if (this.mySupportMarkdown) {
                for (idx = tokens.size() - 1; idx >= 0; --idx) {
                    if (!BasicJavaAstTreeUtil.is(tokens.get(idx), BasicJavaDocElementType.BASIC_DOC_COMMENT)) continue;
                    return idx;
                }
            } else {
                for (idx = tokens.size() - 1; idx >= 0; --idx) {
                    if (!BasicJavaAstTreeUtil.is(tokens.get(idx), BasicJavaDocElementType.BASIC_DOC_COMMENT) || PrecedingWhitespacesAndCommentsBinder.isDocMarkdownComment(idx, getter2)) continue;
                    return idx;
                }
                for (idx = tokens.size() - 1; idx >= 0; --idx) {
                    if (!BasicJavaAstTreeUtil.is(tokens.get(idx), BasicJavaDocElementType.BASIC_DOC_COMMENT)) continue;
                    return idx;
                }
            }
            int result2 = tokens.size();
            for (int idx2 = tokens.size() - 1; idx2 >= 0; --idx2) {
                IElementType tokenType = tokens.get(idx2);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (StringUtil.getLineBreakCount(getter2.get(idx2)) <= 1) continue;
                    break;
                }
                if (!BasicElementTypes.BASIC_JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                if (!atStreamEdge && (idx2 != 0 || !this.myAfterEmptyImport) && (idx2 <= 0 || !TokenSet.WHITE_SPACE.contains(tokens.get(idx2 - 1)) || !StringUtil.containsLineBreak(getter2.get(idx2 - 1)))) continue;
                result2 = idx2;
            }
            return result2;
        }

        private static boolean isDocMarkdownComment(int idx, @NotNull WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            CharSequence sequence2;
            if (getter2 == null) {
                PrecedingWhitespacesAndCommentsBinder.$$$reportNull$$$0(0);
            }
            return (sequence2 = getter2.get(idx)).length() >= 3 && "///".equals(sequence2.subSequence(0, 3).toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "org/jetbrains/kotlin/com/intellij/psi/impl/source/WhiteSpaceAndCommentSetHolder$PrecedingWhitespacesAndCommentsBinder", "isDocMarkdownComment"));
        }
    }

    private static class TrailingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private TrailingWhitespacesAndCommentsBinder() {
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.isEmpty()) {
                return 0;
            }
            int result2 = 0;
            for (int idx = 0; idx < tokens.size(); ++idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (!StringUtil.containsLineBreak(getter2.get(idx))) continue;
                    break;
                }
                if (!BasicElementTypes.BASIC_JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                result2 = idx + 1;
            }
            return result2;
        }
    }
}

