/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSet;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSetEx;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.impl.VirtualFileEnumeration;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

@ApiStatus.Internal
public abstract class AbstractFilesScope
extends GlobalSearchScope
implements VirtualFileEnumeration {
    volatile Boolean myHasFilesOutOfProjectRoots;

    AbstractFilesScope(@Nullable Project project, @Nullable Boolean hasFilesOutOfProjectRoots) {
        super(project);
        this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
    }

    @Override
    @Nullable
    public Collection<VirtualFile> getFilesIfCollection() {
        return this.getFiles();
    }

    @NotNull
    abstract VirtualFileSet getFiles();

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AbstractFilesScope.$$$reportNull$$$0(0);
        }
        return this.getFiles().contains(file);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            AbstractFilesScope.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.hasFilesOutOfProjectRoots();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof AbstractFilesScope && this.getFiles().equals(((AbstractFilesScope)o).getFiles());
    }

    @Override
    public int calcHashCode() {
        return this.getFiles().hashCode();
    }

    private boolean hasFilesOutOfProjectRoots() {
        Boolean result2 = this.myHasFilesOutOfProjectRoots;
        if (result2 == null) {
            Project project = this.getProject();
            this.myHasFilesOutOfProjectRoots = result2 = Boolean.valueOf(project != null && !project.isDefault() && ContainerUtil.find(this.getFiles(), file -> FileIndexFacade.getInstance(project).getModuleForFile((VirtualFile)file) != null) == null);
        }
        return result2;
    }

    @Override
    public boolean contains(int fileId) {
        return ((VirtualFileSetEx)this.getFiles()).containsId(fileId);
    }

    @Override
    public int @NotNull [] asArray() {
        int[] nArray = ((VirtualFileSetEx)this.getFiles()).onlyInternalFileIds();
        if (nArray == null) {
            AbstractFilesScope.$$$reportNull$$$0(2);
        }
        return nArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/AbstractFilesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/AbstractFilesScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

