/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.CodeInsightContext;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.CodeInsightContextKt;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.ActualCodeInsightContextInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.ActualContextFileInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.ActualContextFileInfoImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.CodeInsightContextAwareSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.CodeInsightContextFileInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.CodeInsightContextInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.DoesNotContainFileInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.DoesNotContainFileInfoImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.NoContextFileInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.NoContextFileInfoImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.NoContextInformation;
import org.jetbrains.kotlin.com.intellij.psi.search.NoContextInformationImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\b\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0007\u001a\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0007\u001a\b\u0010\u0017\u001a\u00020\u0018H\u0007\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"contains", "", "Lorg/jetbrains/kotlin/com/intellij/psi/search/SearchScope;", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "context", "Lorg/jetbrains/kotlin/com/intellij/codeInsight/multiverse/CodeInsightContext;", "getFileContextInfo", "Lorg/jetbrains/kotlin/com/intellij/psi/search/CodeInsightContextFileInfo;", "getAnyCorrespondingContext", "codeInsightContextInfo", "Lorg/jetbrains/kotlin/com/intellij/psi/search/CodeInsightContextInfo;", "getCodeInsightContextInfo", "(Lcom/intellij/psi/search/SearchScope;)Lcom/intellij/psi/search/CodeInsightContextInfo;", "NoContextInformation", "Lorg/jetbrains/kotlin/com/intellij/psi/search/NoContextInformation;", "DoesNotContainFileInfo", "Lorg/jetbrains/kotlin/com/intellij/psi/search/DoesNotContainFileInfo;", "ActualContextFileInfo", "Lorg/jetbrains/kotlin/com/intellij/psi/search/ActualContextFileInfo;", "contexts", "", "createContainingContextFileInfo", "NoContextFileInfo", "Lorg/jetbrains/kotlin/com/intellij/psi/search/NoContextFileInfo;", "intellij.platform.core"})
public final class CodeInsightContextAwareSearchScopesKt {
    @ApiStatus.Internal
    public static final boolean contains(@NotNull SearchScope $this$contains, @NotNull VirtualFile file, @NotNull CodeInsightContext context2) {
        boolean bl;
        CodeInsightContextInfo info;
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CodeInsightContextInfo codeInsightContextInfo = info = CodeInsightContextAwareSearchScopesKt.getCodeInsightContextInfo($this$contains);
        if (codeInsightContextInfo instanceof NoContextInformation) {
            bl = $this$contains.contains(file);
        } else if (codeInsightContextInfo instanceof ActualCodeInsightContextInfo) {
            bl = ((ActualCodeInsightContextInfo)info).contains(file, context2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @ApiStatus.Internal
    @NotNull
    public static final CodeInsightContextFileInfo getFileContextInfo(@NotNull SearchScope $this$getFileContextInfo, @NotNull VirtualFile file) {
        CodeInsightContextFileInfo codeInsightContextFileInfo;
        CodeInsightContextInfo info;
        Intrinsics.checkNotNullParameter((Object)$this$getFileContextInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeInsightContextInfo codeInsightContextInfo = info = CodeInsightContextAwareSearchScopesKt.getCodeInsightContextInfo($this$getFileContextInfo);
        if (codeInsightContextInfo instanceof NoContextInformation) {
            codeInsightContextFileInfo = $this$getFileContextInfo.contains(file) ? (CodeInsightContextFileInfo)CodeInsightContextAwareSearchScopesKt.NoContextFileInfo() : (CodeInsightContextFileInfo)CodeInsightContextAwareSearchScopesKt.DoesNotContainFileInfo();
        } else if (codeInsightContextInfo instanceof ActualCodeInsightContextInfo) {
            codeInsightContextFileInfo = ((ActualCodeInsightContextInfo)info).getFileInfo(file);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return codeInsightContextFileInfo;
    }

    @ApiStatus.Internal
    @NotNull
    public static final CodeInsightContext getAnyCorrespondingContext(@NotNull SearchScope $this$getAnyCorrespondingContext, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$getAnyCorrespondingContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CodeInsightContextFileInfo contextInfo = CodeInsightContextAwareSearchScopesKt.getFileContextInfo($this$getAnyCorrespondingContext, file);
        return contextInfo instanceof ActualContextFileInfo ? (CodeInsightContext)CollectionsKt.first((Iterable)((ActualContextFileInfo)contextInfo).getContexts()) : CodeInsightContextKt.anyContext();
    }

    @ApiStatus.Internal
    @NotNull
    public static final CodeInsightContextInfo getCodeInsightContextInfo(@NotNull SearchScope $this$codeInsightContextInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$codeInsightContextInfo, (String)"<this>");
        return $this$codeInsightContextInfo instanceof CodeInsightContextAwareSearchScope ? ((CodeInsightContextAwareSearchScope)((Object)$this$codeInsightContextInfo)).getCodeInsightContextInfo() : (CodeInsightContextInfo)CodeInsightContextAwareSearchScopesKt.NoContextInformation();
    }

    @ApiStatus.Internal
    @NotNull
    public static final NoContextInformation NoContextInformation() {
        return NoContextInformationImpl.INSTANCE;
    }

    @ApiStatus.Internal
    @NotNull
    public static final DoesNotContainFileInfo DoesNotContainFileInfo() {
        return DoesNotContainFileInfoImpl.INSTANCE;
    }

    @ApiStatus.Internal
    @NotNull
    public static final ActualContextFileInfo ActualContextFileInfo(@NotNull Collection<? extends CodeInsightContext> contexts2) {
        Intrinsics.checkNotNullParameter(contexts2, (String)"contexts");
        if (contexts2.isEmpty()) {
            throw new IllegalArgumentException("Contexts cannot be empty");
        }
        return new ActualContextFileInfoImpl(contexts2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final CodeInsightContextFileInfo createContainingContextFileInfo(@NotNull Collection<? extends CodeInsightContext> contexts2) {
        Intrinsics.checkNotNullParameter(contexts2, (String)"contexts");
        if (contexts2.isEmpty()) {
            return CodeInsightContextAwareSearchScopesKt.NoContextFileInfo();
        }
        return CodeInsightContextAwareSearchScopesKt.ActualContextFileInfo(contexts2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final NoContextFileInfo NoContextFileInfo() {
        return NoContextFileInfoImpl.INSTANCE;
    }
}

