/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSet;
import org.jetbrains.kotlin.com.intellij.psi.search.AbstractFilesScope;

class LazyFilesScope
extends AbstractFilesScope {
    private volatile VirtualFileSet myFiles;
    @NotNull
    private Supplier<? extends Collection<? extends VirtualFile>> myFilesSupplier;

    LazyFilesScope(@Nullable Project project, @NotNull Supplier<? extends Collection<? extends VirtualFile>> files2) {
        if (files2 == null) {
            LazyFilesScope.$$$reportNull$$$0(0);
        }
        super(project, null);
        this.myFilesSupplier = files2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public VirtualFileSet getFiles() {
        if (this.myFiles == null) {
            LazyFilesScope lazyFilesScope = this;
            synchronized (lazyFilesScope) {
                if (this.myFiles == null) {
                    VirtualFileSet fileSet = VfsUtilCore.createCompactVirtualFileSet(this.myFilesSupplier.get());
                    fileSet.freeze();
                    this.myFilesSupplier = null;
                    this.myFiles = fileSet;
                }
            }
        }
        VirtualFileSet virtualFileSet = this.myFiles;
        if (virtualFileSet == null) {
            LazyFilesScope.$$$reportNull$$$0(1);
        }
        return virtualFileSet;
    }

    public String toString() {
        return "Files: [" + (this.myFiles == null ? "(not loaded yet)" : StringUtil.join(this.myFiles, ", ")) + "]; search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/LazyFilesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/LazyFilesScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

